/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.filters;

import com.google.common.collect.Multimap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.Queries;
import org.jclouds.s3.filters.Aws4SignerForAuthorizationHeader;
import org.jclouds.s3.filters.Aws4SignerForChunkedUpload;
import org.jclouds.s3.filters.Aws4SignerForQueryString;
import org.jclouds.s3.filters.RequestAuthorizeSignatureV4;

@Singleton
public class AWSRequestAuthorizeSignatureV4
extends RequestAuthorizeSignatureV4 {
    @Inject
    public AWSRequestAuthorizeSignatureV4(Aws4SignerForAuthorizationHeader signerForAuthorizationHeader, Aws4SignerForChunkedUpload signerForChunkedUpload, Aws4SignerForQueryString signerForQueryString) {
        super(signerForAuthorizationHeader, signerForChunkedUpload, signerForQueryString);
    }

    protected HttpRequest signForAuthorizationHeader(HttpRequest request) {
        Multimap queryMap = (Multimap)Queries.queryParser().apply((Object)request.getEndpoint().getQuery());
        if (queryMap.containsKey((Object)"X-Amz-Signature") || queryMap.containsKey((Object)"Signature")) {
            return request;
        }
        return super.signForAuthorizationHeader(request);
    }
}

