/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.PetSetSpec;
import io.fabric8.kubernetes.api.model.extensions.PetSetSpecFluent;
import java.util.ArrayList;
import java.util.List;

public class PetSetSpecFluentImpl<A extends PetSetSpecFluent<A>>
extends BaseFluent<A>
implements PetSetSpecFluent<A> {
    private Integer replicas;
    private VisitableBuilder<? extends LabelSelector, ?> selector;
    private String serviceName;
    private VisitableBuilder<? extends PodTemplateSpec, ?> template;
    private List<VisitableBuilder<? extends PersistentVolumeClaim, ?>> volumeClaimTemplates = new ArrayList();

    public PetSetSpecFluentImpl() {
    }

    public PetSetSpecFluentImpl(PetSetSpec instance) {
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withServiceName(instance.getServiceName());
        this.withTemplate(instance.getTemplate());
        this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public LabelSelector getSelector() {
        return this.selector != null ? (LabelSelector)this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.add(this.selector);
        }
        return (A)this;
    }

    @Override
    public PetSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public PetSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public PetSetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PetSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PetSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    @Override
    public PodTemplateSpec getTemplate() {
        return this.template != null ? (PodTemplateSpec)this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (A)this;
    }

    @Override
    public PetSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public PetSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public PetSetSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public PetSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public PetSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public A addToVolumeClaimTemplates(PersistentVolumeClaim ... items) {
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeClaimTemplates(PersistentVolumeClaim ... items) {
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.remove(builder);
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<PersistentVolumeClaim> getVolumeClaimTemplates() {
        return PetSetSpecFluentImpl.build(this.volumeClaimTemplates);
    }

    @Override
    public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates) {
        this._visitables.removeAll(this.volumeClaimTemplates);
        this.volumeClaimTemplates.clear();
        if (volumeClaimTemplates != null) {
            for (PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumeClaimTemplates(PersistentVolumeClaim ... volumeClaimTemplates) {
        this.volumeClaimTemplates.clear();
        if (volumeClaimTemplates != null) {
            for (PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        }
        return (A)this;
    }

    @Override
    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate() {
        return new VolumeClaimTemplatesNestedImpl();
    }

    @Override
    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PetSetSpecFluentImpl that = (PetSetSpecFluentImpl)o;
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return !(this.volumeClaimTemplates != null ? !this.volumeClaimTemplates.equals(that.volumeClaimTemplates) : that.volumeClaimTemplates != null);
    }

    public class VolumeClaimTemplatesNestedImpl<N>
    extends PersistentVolumeClaimFluentImpl<PetSetSpecFluent.VolumeClaimTemplatesNested<N>>
    implements PetSetSpecFluent.VolumeClaimTemplatesNested<N>,
    Nested<N> {
        private final PersistentVolumeClaimBuilder builder;

        VolumeClaimTemplatesNestedImpl(PersistentVolumeClaim item) {
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        VolumeClaimTemplatesNestedImpl() {
            this.builder = new PersistentVolumeClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)PetSetSpecFluentImpl.this.addToVolumeClaimTemplates(this.builder.build());
        }

        @Override
        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<PetSetSpecFluent.TemplateNested<N>>
    implements PetSetSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)PetSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PetSetSpecFluent.SelectorNested<N>>
    implements PetSetSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PetSetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

