/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionPredicates {
    public static Predicate<Integer> MODIFIERS_PRIVATE = new ModifiersPrivate();
    public static Predicate<Integer> MODIFIERS_PUBLIC = new ModifiersPublic();
    public static Predicate<Integer> MODIFIERS_PROTECTED = new ModifiersProtected();
    public static Predicate<Integer> MODIFIERS_TRANSIENT = new ModifiersTransient();
    public static Predicate<Integer> MODIFIERS_STATIC = new ModifiersStatic();
    public static Predicate<Field> IS_FIELD_PUBLIC = ReflectionPredicates.fieldModifiers(MODIFIERS_PUBLIC);
    public static Predicate<Field> IS_FIELD_TRANSIENT = ReflectionPredicates.fieldModifiers(MODIFIERS_TRANSIENT);
    public static Predicate<Field> IS_FIELD_NON_TRANSIENT = Predicates.not(IS_FIELD_TRANSIENT);
    public static Predicate<Field> IS_FIELD_STATIC = ReflectionPredicates.fieldModifiers(MODIFIERS_STATIC);
    public static Predicate<Field> IS_FIELD_NON_STATIC = Predicates.not(IS_FIELD_STATIC);

    public static Predicate<Field> fieldModifiers(Predicate<Integer> modifiersCheck) {
        return new FieldModifiers(modifiersCheck);
    }

    public static Predicate<Method> methodModifiers(Predicate<Integer> modifiersCheck) {
        return new MethodModifiers(modifiersCheck);
    }

    private static class MethodModifiers
    implements Predicate<Method> {
        private Predicate<Integer> modifiersCheck;

        private MethodModifiers(Predicate<Integer> modifiersCheck) {
            this.modifiersCheck = modifiersCheck;
        }

        public boolean apply(Method m) {
            return this.modifiersCheck.apply((Object)m.getModifiers());
        }
    }

    private static class FieldModifiers
    implements Predicate<Field> {
        private Predicate<Integer> modifiersCheck;

        private FieldModifiers(Predicate<Integer> modifiersCheck) {
            this.modifiersCheck = modifiersCheck;
        }

        public boolean apply(Field f) {
            return this.modifiersCheck.apply((Object)f.getModifiers());
        }
    }

    private static class ModifiersStatic
    implements Predicate<Integer> {
        private ModifiersStatic() {
        }

        public boolean apply(Integer modifiers) {
            return Modifier.isStatic(modifiers);
        }
    }

    private static class ModifiersTransient
    implements Predicate<Integer> {
        private ModifiersTransient() {
        }

        public boolean apply(Integer modifiers) {
            return Modifier.isTransient(modifiers);
        }
    }

    private static class ModifiersProtected
    implements Predicate<Integer> {
        private ModifiersProtected() {
        }

        public boolean apply(Integer modifiers) {
            return Modifier.isProtected(modifiers);
        }
    }

    private static class ModifiersPublic
    implements Predicate<Integer> {
        private ModifiersPublic() {
        }

        public boolean apply(Integer modifiers) {
            return Modifier.isPublic(modifiers);
        }
    }

    private static class ModifiersPrivate
    implements Predicate<Integer> {
        private ModifiersPrivate() {
        }

        public boolean apply(Integer modifiers) {
            return Modifier.isPrivate(modifiers);
        }
    }
}

