/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.spi.collection;

import java.util.ArrayList;
import java.util.List;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.camp.spi.collection.AbstractResourceLookup;
import org.apache.brooklyn.camp.spi.collection.ResolvableLink;
import org.apache.brooklyn.camp.spi.collection.ResourceLookup;

public class AggregatingResourceLookup<T extends AbstractResource>
extends AbstractResourceLookup<T> {
    List<ResourceLookup<T>> targets = new ArrayList<ResourceLookup<T>>();

    @SafeVarargs
    public static <T extends AbstractResource> AggregatingResourceLookup<T> of(ResourceLookup<T> ... targets) {
        AggregatingResourceLookup<T> result = new AggregatingResourceLookup<T>();
        for (ResourceLookup<T> item : targets) {
            result.targets.add(item);
        }
        return result;
    }

    public static <T extends AbstractResource> AggregatingResourceLookup<T> of(Iterable<ResourceLookup<T>> targets) {
        AggregatingResourceLookup<T> result = new AggregatingResourceLookup<T>();
        for (ResourceLookup<T> item : targets) {
            result.targets.add(item);
        }
        return result;
    }

    @Override
    public T get(String id) {
        for (ResourceLookup<T> item : this.targets) {
            T result = item.get(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<ResolvableLink<T>> links() {
        ArrayList<ResolvableLink<T>> result = new ArrayList<ResolvableLink<T>>();
        for (ResourceLookup<T> item : this.targets) {
            result.addAll(item.links());
        }
        return result;
    }
}

