/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.Map;
import org.jclouds.ec2.domain.Subnet;

public class SubnetFilterBuilder
extends ImmutableMultimap.Builder<String, String> {
    private static final String AVAILABILITY_ZONE = "availability-zone";
    private static final String AVAILABLE_IP_ADDRESS_COUNT = "available-ip-address-count";
    private static final String CIDR = "cidr";
    private static final String STATE = "state";
    private static final String SUBNET_ID = "subnet-id";
    private static final String TAG_KEY = "tag-key";
    private static final String TAG_VALUE = "tag-value";
    private static final String TAG_ARBITRARY_BASE = "tag:";
    private static final String VPC_ID = "vpc-id";

    public SubnetFilterBuilder availabilityZone(String availabilityZone) {
        return this.put(AVAILABILITY_ZONE, availabilityZone);
    }

    public SubnetFilterBuilder availabilityZones(String ... availabilityZones) {
        return this.putAll(AVAILABILITY_ZONE, availabilityZones);
    }

    public SubnetFilterBuilder availabilityZones(Iterable<String> availabilityZones) {
        return this.putAll(AVAILABILITY_ZONE, availabilityZones);
    }

    public SubnetFilterBuilder anyAvailabilityZone() {
        return this.putAll(AVAILABILITY_ZONE, (Iterable<? extends String>)ImmutableSet.of());
    }

    public SubnetFilterBuilder availableIpAddressCount(String availableIpAddressCount) {
        return this.put(AVAILABLE_IP_ADDRESS_COUNT, availableIpAddressCount);
    }

    public SubnetFilterBuilder availableIpAddressCounts(String ... availableIpAddressCounts) {
        return this.putAll(AVAILABLE_IP_ADDRESS_COUNT, availableIpAddressCounts);
    }

    public SubnetFilterBuilder availableIpAddressCounts(Iterable<String> availableIpAddressCounts) {
        return this.putAll(AVAILABLE_IP_ADDRESS_COUNT, availableIpAddressCounts);
    }

    public SubnetFilterBuilder anyAvailableIpAddressCount() {
        return this.putAll(AVAILABLE_IP_ADDRESS_COUNT, (Iterable<? extends String>)ImmutableSet.of());
    }

    public SubnetFilterBuilder cidr(String cidr) {
        return this.put(CIDR, cidr);
    }

    public SubnetFilterBuilder cidrs(String ... cidrs) {
        return this.putAll(CIDR, cidrs);
    }

    public SubnetFilterBuilder cidrs(Iterable<String> cidrs) {
        return this.putAll(CIDR, cidrs);
    }

    public SubnetFilterBuilder anyCidr() {
        return this.putAll(CIDR, (Iterable<? extends String>)ImmutableSet.of());
    }

    public SubnetFilterBuilder state(String state) {
        return this.put(STATE, state);
    }

    public SubnetFilterBuilder states(String ... states) {
        return this.putAll(STATE, states);
    }

    public SubnetFilterBuilder states(Iterable<String> states) {
        return this.putAll(STATE, states);
    }

    public SubnetFilterBuilder anyState() {
        return this.putAll(STATE, (Iterable<? extends String>)ImmutableSet.of());
    }

    public SubnetFilterBuilder available() {
        return this.put(STATE, Subnet.State.AVAILABLE.value());
    }

    public SubnetFilterBuilder pending() {
        return this.put(STATE, Subnet.State.PENDING.value());
    }

    public SubnetFilterBuilder subnetId(String subnetId) {
        return this.put(SUBNET_ID, subnetId);
    }

    public SubnetFilterBuilder subnetIds(String ... subnetIds) {
        return this.putAll(SUBNET_ID, subnetIds);
    }

    public SubnetFilterBuilder subnetIds(Iterable<String> subnetIds) {
        return this.putAll(SUBNET_ID, subnetIds);
    }

    public SubnetFilterBuilder anySubnetId() {
        return this.putAll(SUBNET_ID, (Iterable<? extends String>)ImmutableSet.of());
    }

    public SubnetFilterBuilder tagKey(String tagKey) {
        return this.put(TAG_KEY, tagKey);
    }

    public SubnetFilterBuilder tagKeys(String ... tagKeys) {
        return this.putAll(TAG_KEY, tagKeys);
    }

    public SubnetFilterBuilder tagKeys(Iterable<String> tagKeys) {
        return this.putAll(TAG_KEY, tagKeys);
    }

    public SubnetFilterBuilder anyTagKey() {
        return this.putAll(TAG_KEY, (Iterable<? extends String>)ImmutableSet.of());
    }

    public SubnetFilterBuilder tagValue(String tagValue) {
        return this.put(TAG_VALUE, tagValue);
    }

    public SubnetFilterBuilder tagValues(String ... tagValues) {
        return this.putAll(TAG_VALUE, tagValues);
    }

    public SubnetFilterBuilder tagValues(Iterable<String> tagValues) {
        return this.putAll(TAG_VALUE, tagValues);
    }

    public SubnetFilterBuilder anyTagValue() {
        return this.putAll(TAG_VALUE, (Iterable<? extends String>)ImmutableSet.of());
    }

    public SubnetFilterBuilder vpcId(String vpcId) {
        return this.put(VPC_ID, vpcId);
    }

    public SubnetFilterBuilder vpcIds(String ... vpcIds) {
        return this.putAll(VPC_ID, vpcIds);
    }

    public SubnetFilterBuilder vpcIds(Iterable<String> vpcIds) {
        return this.putAll(VPC_ID, vpcIds);
    }

    public SubnetFilterBuilder anyVpcId() {
        return this.putAll(VPC_ID, (Iterable<? extends String>)ImmutableSet.of());
    }

    public SubnetFilterBuilder arbitraryTag(String arbitraryTagKey, String arbitraryTagValue) {
        return this.put(TAG_ARBITRARY_BASE + arbitraryTagKey, arbitraryTagValue);
    }

    public SubnetFilterBuilder arbitraryTag(String arbitraryTagKey, String ... arbitraryTagValues) {
        return this.putAll(TAG_ARBITRARY_BASE + arbitraryTagKey, arbitraryTagValues);
    }

    public SubnetFilterBuilder arbitraryTag(String arbitraryTagKey, Iterable<String> arbitraryTagValues) {
        return this.putAll(TAG_ARBITRARY_BASE + arbitraryTagKey, arbitraryTagValues);
    }

    public SubnetFilterBuilder put(String key, String value) {
        return (SubnetFilterBuilder)((Object)SubnetFilterBuilder.class.cast(super.put((Object)key, (Object)value)));
    }

    public SubnetFilterBuilder put(Map.Entry<? extends String, ? extends String> entry) {
        return (SubnetFilterBuilder)((Object)SubnetFilterBuilder.class.cast(super.put(entry)));
    }

    public SubnetFilterBuilder putAll(String key, Iterable<? extends String> values) {
        return (SubnetFilterBuilder)((Object)SubnetFilterBuilder.class.cast(super.putAll((Object)key, values)));
    }

    public SubnetFilterBuilder putAll(String key, String ... values) {
        return (SubnetFilterBuilder)((Object)SubnetFilterBuilder.class.cast(super.putAll((Object)key, (Object[])values)));
    }

    public SubnetFilterBuilder putAll(Multimap<? extends String, ? extends String> multimap) {
        return (SubnetFilterBuilder)((Object)SubnetFilterBuilder.class.cast(super.putAll(multimap)));
    }

    @Beta
    public SubnetFilterBuilder orderKeysBy(Comparator<? super String> keyComparator) {
        return (SubnetFilterBuilder)((Object)SubnetFilterBuilder.class.cast(super.orderKeysBy(keyComparator)));
    }

    @Beta
    public SubnetFilterBuilder orderValuesBy(Comparator<? super String> valueComparator) {
        return (SubnetFilterBuilder)((Object)SubnetFilterBuilder.class.cast(super.orderValuesBy(valueComparator)));
    }
}

