/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.config.AtmosObjectModule;
import org.jclouds.atmos.config.AtmosParserModule;
import org.jclouds.atmos.handlers.AtmosClientErrorRetryHandler;
import org.jclouds.atmos.handlers.AtmosServerErrorRetryHandler;
import org.jclouds.atmos.handlers.ParseAtmosErrorFromXmlContent;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class AtmosHttpApiModule
extends HttpApiModule<AtmosClient> {
    protected void configure() {
        this.install((Module)new AtmosParserModule());
        this.install((Module)new AtmosObjectModule());
        super.configure();
    }

    @Provides
    @TimeStamp
    protected final String guiceProvideTimeStamp(@TimeStamp Supplier<String> cache) {
        return this.provideTimeStamp(cache);
    }

    protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
        return (String)cache.get();
    }

    @Provides
    @TimeStamp
    final Supplier<String> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds, final DateService dateService) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<String>(){

            public String get() {
                return dateService.rfc822DateFormat();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @TimeStamp
    protected final Long provideShareableUrlTimeout() {
        return new Date().getTime() + TimeUnit.HOURS.toMillis(1L);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseAtmosErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseAtmosErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseAtmosErrorFromXmlContent.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(AtmosClientErrorRetryHandler.class);
        this.bind(HttpRetryHandler.class).annotatedWith(ServerError.class).to(AtmosServerErrorRetryHandler.class);
    }
}

