/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.authentication.TokenRequestSpec;
import io.fabric8.kubernetes.api.model.authentication.TokenRequestSpecFluent;

public class TokenRequestSpecBuilder
extends TokenRequestSpecFluent<TokenRequestSpecBuilder>
implements VisitableBuilder<TokenRequestSpec, TokenRequestSpecBuilder> {
    TokenRequestSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TokenRequestSpecBuilder() {
        this(false);
    }

    public TokenRequestSpecBuilder(Boolean validationEnabled) {
        this(new TokenRequestSpec(), validationEnabled);
    }

    public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TokenRequestSpec(), validationEnabled);
    }

    public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent, TokenRequestSpec instance) {
        this(fluent, instance, false);
    }

    public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent, TokenRequestSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        TokenRequestSpec tokenRequestSpec = instance = instance != null ? instance : new TokenRequestSpec();
        if (instance != null) {
            fluent.withAudiences(instance.getAudiences());
            fluent.withBoundObjectRef(instance.getBoundObjectRef());
            fluent.withExpirationSeconds(instance.getExpirationSeconds());
            fluent.withAudiences(instance.getAudiences());
            fluent.withBoundObjectRef(instance.getBoundObjectRef());
            fluent.withExpirationSeconds(instance.getExpirationSeconds());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public TokenRequestSpecBuilder(TokenRequestSpec instance) {
        this(instance, (Boolean)false);
    }

    public TokenRequestSpecBuilder(TokenRequestSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        TokenRequestSpec tokenRequestSpec = instance = instance != null ? instance : new TokenRequestSpec();
        if (instance != null) {
            this.withAudiences(instance.getAudiences());
            this.withBoundObjectRef(instance.getBoundObjectRef());
            this.withExpirationSeconds(instance.getExpirationSeconds());
            this.withAudiences(instance.getAudiences());
            this.withBoundObjectRef(instance.getBoundObjectRef());
            this.withExpirationSeconds(instance.getExpirationSeconds());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public TokenRequestSpec build() {
        TokenRequestSpec buildable = new TokenRequestSpec(this.fluent.getAudiences(), this.fluent.buildBoundObjectRef(), this.fluent.getExpirationSeconds());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

