/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListBucketOptions
extends BaseHttpRequestOptions
implements Cloneable {
    public static final ListBucketOptions NONE = new ListBucketOptions();

    public ListBucketOptions withPrefix(String prefix) {
        this.queryParameters.put((Object)"prefix", (Object)((String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix")));
        return this;
    }

    public String getPrefix() {
        return this.getFirstQueryOrNull("prefix");
    }

    public ListBucketOptions afterMarker(String marker) {
        this.queryParameters.put((Object)"marker", (Object)((String)Preconditions.checkNotNull((Object)marker, (Object)"marker")));
        return this;
    }

    public String getMarker() {
        return this.getFirstQueryOrNull("marker");
    }

    public ListBucketOptions maxResults(int maxKeys) {
        Preconditions.checkState((maxKeys >= 0 ? 1 : 0) != 0, (Object)"maxKeys must be >= 0");
        this.queryParameters.put((Object)"max-keys", (Object)Long.toString(maxKeys));
        return this;
    }

    public Integer getMaxResults() {
        String returnVal = this.getFirstQueryOrNull("max-keys");
        return returnVal != null ? Integer.valueOf(returnVal) : null;
    }

    public ListBucketOptions delimiter(String delimiter) {
        this.queryParameters.put((Object)"delimiter", (Object)((String)Preconditions.checkNotNull((Object)delimiter, (Object)"delimiter")));
        return this;
    }

    public String getDelimiter() {
        return this.getFirstQueryOrNull("delimiter");
    }

    public ListBucketOptions clone() {
        ListBucketOptions newOptions = new ListBucketOptions();
        newOptions.queryParameters.putAll(this.queryParameters);
        return newOptions;
    }

    public static class Builder {
        public static ListBucketOptions withPrefix(String prefix) {
            ListBucketOptions options = new ListBucketOptions();
            return options.withPrefix(prefix);
        }

        public static ListBucketOptions afterMarker(String marker) {
            ListBucketOptions options = new ListBucketOptions();
            return options.afterMarker(marker);
        }

        public static ListBucketOptions maxResults(int maxKeys) {
            ListBucketOptions options = new ListBucketOptions();
            return options.maxResults(maxKeys);
        }

        public static ListBucketOptions delimiter(String delimiter) {
            ListBucketOptions options = new ListBucketOptions();
            return options.delimiter(delimiter);
        }
    }
}

