/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.cinder.v1.domain.Snapshot;
import org.jclouds.openstack.cinder.v1.options.CreateSnapshotOptions;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/snapshots")
public interface SnapshotApi {
    @Named(value="snapshot:list")
    @GET
    @SelectJson(value={"snapshots"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<? extends Snapshot> list();

    @Named(value="snapshot:list")
    @GET
    @Path(value="/detail")
    @SelectJson(value={"snapshots"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<? extends Snapshot> listInDetail();

    @Named(value="snapshot:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"snapshot"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Snapshot get(@PathParam(value="id") String var1);

    @Named(value="snapshot:create")
    @POST
    @SelectJson(value={"snapshot"})
    @Produces(value={"application/json"})
    @MapBinder(value=CreateSnapshotOptions.class)
    public Snapshot create(@PayloadParam(value="volume_id") String var1, CreateSnapshotOptions ... var2);

    @Named(value="snapshot:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

