/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.internal.AppGroupTraverser;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowReplayUtils;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeEffectorWorkflowStep
extends WorkflowStepDefinition
implements WorkflowStepDefinition.WorkflowStepDefinitionWithSubWorkflow {
    private static final Logger LOG = LoggerFactory.getLogger(InvokeEffectorWorkflowStep.class);
    public static final String SHORTHAND = "${effector}";
    public static final ConfigKey<Object> ENTITY = ConfigKeys.newConfigKey(Object.class, "entity");
    public static final ConfigKey<String> EFFECTOR = ConfigKeys.newStringConfigKey("effector");
    public static final ConfigKey<Map<String, Object>> ARGS = new MapConfigKey.Builder<Object>(Object.class, "args").build();

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        if (!this.getInput().containsKey(EFFECTOR.getName())) {
            throw new IllegalArgumentException("Missing required input: " + EFFECTOR.getName());
        }
    }

    @Override
    @JsonIgnore
    public WorkflowStepDefinition.SubWorkflowsForReplay getSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext context, boolean forced, boolean peekingOnly, boolean allowInternallyEvenIfDisabled) {
        return WorkflowReplayUtils.getSubWorkflowsForReplay(context, forced, peekingOnly, allowInternallyEvenIfDisabled, sw -> {
            StepState state = this.getStepState(context);
            sw.isResumableOnlyAtParent = !state.submitted ? true : !state.nonWorkflowEffector;
        });
    }

    @Override
    public Object doTaskBodyWithSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext context, @Nonnull List<WorkflowExecutionContext> subworkflows, WorkflowStepDefinition.ReplayContinuationInstructions instructions) {
        return WorkflowReplayUtils.replayResumingInSubWorkflow("workflow effector", context, (WorkflowExecutionContext)Iterables.getOnlyElement(subworkflows), instructions, (w, e) -> {
            LOG.debug("Sub workflow " + w + " is not replayable; running anew (" + Exceptions.collapseText((Throwable)e) + ")");
            return this.doTaskBody(context);
        }, true);
    }

    @Override
    protected StepState getStepState(WorkflowStepInstanceExecutionContext context) {
        StepState result = (StepState)super.getStepState(context);
        if (result == null) {
            result = new StepState();
        }
        return result;
    }

    void setStepState(WorkflowStepInstanceExecutionContext context, StepState state) {
        context.setStepState(state, true);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        Object te = context.getInput(ENTITY);
        if (te == null) {
            te = context.getEntity();
        }
        if (te instanceof String) {
            String desiredComponentId = (String)te;
            List<Entity> firstGroupOfMatches = AppGroupTraverser.findFirstGroupOfMatches(context.getEntity(), true, arg_0 -> ((Predicate)Predicates.and(EntityPredicates.configEqualTo(BrooklynConfigKeys.PLAN_ID, desiredComponentId), x -> true)).apply(arg_0));
            if (firstGroupOfMatches.isEmpty()) {
                firstGroupOfMatches = AppGroupTraverser.findFirstGroupOfMatches(context.getEntity(), true, arg_0 -> ((Predicate)Predicates.and(EntityPredicates.idEqualTo(desiredComponentId), x -> true)).apply(arg_0));
            }
            if (!firstGroupOfMatches.isEmpty()) {
                te = firstGroupOfMatches.get(0);
            } else {
                throw new IllegalStateException("Cannot find entity with ID '" + desiredComponentId + "'");
            }
        }
        if (!(te instanceof Entity)) {
            throw new IllegalStateException("Unsupported object for entity '" + te + "' (" + te.getClass() + ")");
        }
        Effector effector = (Effector)((Entity)te).getEntityType().getEffectorByName(context.getInput(EFFECTOR)).get();
        TaskAdaptable invocation = Effectors.invocationPossiblySubWorkflow((Entity)te, effector, context.getInput(ARGS), context.getWorkflowExectionContext(), workflowTag -> WorkflowReplayUtils.setNewSubWorkflows(context, (List<BrooklynTaskTags.WorkflowTaskTag>)MutableList.of((Object)workflowTag), workflowTag.getWorkflowId()));
        StepState state = this.getStepState(context);
        state.nonWorkflowEffector = context.getSubWorkflows().isEmpty();
        state.submitted = true;
        this.setStepState(context, state);
        return DynamicTasks.queue(invocation).asTask().getUnchecked();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return null;
    }

    static class StepState {
        boolean submitted;
        boolean nonWorkflowEffector;

        StepState() {
        }
    }
}

