/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.flow;

import java.util.Arrays;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWorkflowStep
extends WorkflowStepDefinition {
    public static final String SHORTHAND = "${message...}";
    public static final ConfigKey<String> MESSAGE = ConfigKeys.newStringConfigKey("message");
    public static final ConfigKey<String> LEVEL = ConfigKeys.newStringConfigKey("level");
    public static final ConfigKey<String> CATEGORY = ConfigKeys.newStringConfigKey("category");

    @Override
    public void populateFromShorthand(String value) {
        this.populateFromShorthandTemplate(SHORTHAND, value);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        String message = context.getInput(MESSAGE);
        String level = context.getInput(LEVEL);
        String category = context.getInput(CATEGORY);
        if (Strings.isBlank((CharSequence)message)) {
            throw new IllegalArgumentException("Log message is required");
        }
        Logger log = LoggerFactory.getLogger(LogWorkflowStep.class);
        if (!Strings.isBlank((CharSequence)category)) {
            log = LoggerFactory.getLogger((String)category);
        }
        String messageLogged = message;
        if (!Strings.isBlank((CharSequence)level)) {
            Boolean levelExists = Arrays.stream(BrooklynLogging.LoggingLevel.values()).anyMatch(t -> t.name().equals(level.toUpperCase()));
            if (levelExists.booleanValue()) {
                BrooklynLogging.log(log, BrooklynLogging.LoggingLevel.valueOf(level.toUpperCase()), message, new Object[0]);
                messageLogged = "[" + level.toUpperCase() + "]  " + messageLogged;
            } else {
                log.info("{}", (Object)message);
            }
        } else {
            log.info("{}", (Object)message);
        }
        context.noteOtherMetadata("Message", messageLogged, false);
        return context.getPreviousStepOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }
}

