/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.core.workflow.ShorthandProcessor;
import org.apache.brooklyn.core.workflow.steps.variables.TransformSlice;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformDefault;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.guava.Maybe;

public class TransformSplit
extends WorkflowTransformDefault {
    String SHORTHAND = "\"split\" [ \"limit\" ${limit} ] [ ?${keep_delimiters} \"keep_delimiters\" ] [ ?${literal} \"literal\" ] [ ?${regex} \"regex\" ] ${delimiter}";
    Integer limit;
    String delimiter;
    boolean keep_delimiters;
    boolean literal;
    boolean regex;

    @Override
    protected void initCheckingDefinition() {
        Maybe<Map<String, Object>> maybeResult = new ShorthandProcessor(this.SHORTHAND).withFinalMatchRaw(false).withFailOnMismatch(true).process(this.transformDef);
        if (maybeResult.isPresent()) {
            Map result = (Map)maybeResult.get();
            this.keep_delimiters = Boolean.TRUE.equals(result.get("keep_delimiters"));
            this.literal = Boolean.TRUE.equals(result.get("literal"));
            this.regex = Boolean.TRUE.equals(result.get("regex"));
            this.limit = TransformSlice.resolveAs(result.get("limit"), this.context, "First argument 'limit'", false, Integer.class, "an integer");
            this.delimiter = TransformSlice.resolveAs(result.get("delimiter"), this.context, "Last argument 'delimiter'", true, String.class, "a string");
            if (this.regex && this.literal) {
                throw new IllegalArgumentException("Only one of regex and literal can be set");
            }
            if (!this.regex && !this.literal) {
                this.literal = true;
            }
        } else {
            throw new IllegalArgumentException("Expression must be of the form 'split [limit L] [keep_delimiters] [literal|regex] DELIMITER");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Object apply(Object v) {
        void var2_4;
        if (!(v instanceof String)) throw new IllegalStateException("Input must be a string to split");
        MutableList mutableList = MutableList.of();
        String s = (String)v;
        Matcher m = this.regex ? Pattern.compile(this.delimiter).matcher((String)v) : null;
        int lastEnd = 0;
        while (true) {
            block13: {
                if (m == null) {
                    int index = s.indexOf(this.delimiter, lastEnd);
                    if (this.delimiter.isEmpty()) {
                        if (mutableList.isEmpty()) {
                            mutableList.add("");
                            if (s.isEmpty()) {
                                return var2_4;
                            }
                            if (this.keep_delimiters) {
                                mutableList.add("");
                            }
                        }
                        ++index;
                    }
                    if (index >= 0 && index <= s.length() && !s.isEmpty()) {
                        mutableList.add(s.substring(lastEnd, index));
                        if (this.keep_delimiters) {
                            mutableList.add(this.delimiter);
                        }
                        lastEnd = index + this.delimiter.length();
                        break block13;
                    } else {
                        mutableList.add(s.substring(lastEnd));
                        return var2_4;
                    }
                }
                if (m.find() && !s.isEmpty()) {
                    if (m.start() < lastEnd) continue;
                    if (lastEnd == m.end() && !mutableList.isEmpty()) {
                        throw new IllegalStateException("Regex match repeats splitting on empty string at same position");
                    }
                    mutableList.add(s.substring(lastEnd, m.start()));
                    if (this.keep_delimiters) {
                        mutableList.add(s.substring(m.start(), m.end()));
                    }
                    lastEnd = m.end();
                } else {
                    mutableList.add(s.substring(lastEnd));
                    return var2_4;
                }
            }
            if (this.limit != null && mutableList.size() >= this.limit) break;
        }
        List list = mutableList.subList(0, this.limit);
        return var2_4;
    }
}

