/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformDefault;
import org.apache.brooklyn.util.collections.MutableSet;

public class TransformType
extends WorkflowTransformDefault {
    private TypeToken<?> type;

    @Override
    protected void initCheckingDefinition() {
        MutableSet d = MutableSet.copyOf(this.definition.subList(1, this.definition.size()));
        if (d.isEmpty()) {
            throw new IllegalArgumentException("Transform 'type' requires a type argument");
        }
        if (d.size() > 1) {
            throw new IllegalArgumentException("Transform 'type' requires a single argument being the type; not " + d);
        }
        this.type = this.context.lookupType((String)Iterables.getOnlyElement((Iterable)d), () -> null);
    }

    public Object apply(Object v) {
        return this.context.resolveCoercingOnly(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, v, this.type);
    }
}

