/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.byon;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineLocationCustomizer;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.mgmt.LocationManager;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.CollectionFunctionals;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.WildcardGlobs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedListMachineProvisioningLocation<T extends MachineLocation>
extends AbstractLocation
implements MachineProvisioningLocation<T>,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(FixedListMachineProvisioningLocation.class);
    public static final ConfigKey<Function<Iterable<? extends MachineLocation>, MachineLocation>> MACHINE_CHOOSER = ConfigKeys.newConfigKey(new TypeToken<Function<Iterable<? extends MachineLocation>, MachineLocation>>(){}, "byon.machineChooser", "For choosing which of the possible machines is chosen and returned by obtain()", CollectionFunctionals.firstElement());
    public static final ConfigKey<Collection<MachineLocationCustomizer>> MACHINE_LOCATION_CUSTOMIZERS = CloudLocationConfig.MACHINE_LOCATION_CUSTOMIZERS;
    @Beta
    public static final ConfigKey<List<LocationSpec<? extends MachineLocation>>> MACHINE_SPECS = ConfigKeys.newConfigKey(new TypeToken<List<LocationSpec<? extends MachineLocation>>>(){}, "byon.machineSpecs", "Specs of machines that should be immediately instantiated on init", ImmutableList.of());
    @Beta
    public static final ConfigKey<Supplier<? extends List<? extends MachineLocation>>> INITIAL_MACHINES_FACTORY = ConfigKeys.newConfigKey(new TypeToken<Supplier<? extends List<? extends MachineLocation>>>(){}, "byon.initialMachinesFactory", "Factory for creating the machines that should be immediately instantiated on init", null);
    private final Object lock = new Object();
    @SetFromFlag
    protected Set<T> machines;
    @SetFromFlag
    protected Set<T> inUse;
    @SetFromFlag
    protected Set<T> pendingRemoval;
    @SetFromFlag
    protected Map<T, Map<String, Object>> origConfigs;

    public FixedListMachineProvisioningLocation() {
        this(Maps.newLinkedHashMap());
    }

    public FixedListMachineProvisioningLocation(Map<?, ?> properties) {
        super(properties);
        if (this.isLegacyConstruction()) {
            this.init();
        }
    }

    @Override
    public void init() {
        List initialMachines;
        super.init();
        List<LocationSpec<? extends MachineLocation>> machineSpecs = this.getConfig(MACHINE_SPECS);
        if (machineSpecs != null) {
            for (LocationSpec<? extends MachineLocation> spec : machineSpecs) {
                MachineLocation machine = (MachineLocation)this.getManagementContext().getLocationManager().createLocation(spec);
                this.machines.add(machine);
            }
        }
        this.config().set(MACHINE_SPECS, null);
        Supplier<? extends List<? extends MachineLocation>> initialMachinesFactory = this.getConfig(INITIAL_MACHINES_FACTORY);
        if (initialMachinesFactory != null && (initialMachines = (List)initialMachinesFactory.get()) != null) {
            Iterator<Object> iterator = initialMachines.iterator();
            while (iterator.hasNext()) {
                MachineLocation machine;
                MachineLocation castMachine = machine = (MachineLocation)iterator.next();
                this.machines.add(castMachine);
            }
        }
        this.config().set(INITIAL_MACHINES_FACTORY, null);
        MutableSet machinesCopy = MutableSet.of();
        for (MachineLocation location : this.machines) {
            if (location == null) {
                log.warn("" + this + " initialized with null location, removing (may be due to rebind with reference to an unmanaged location)");
                continue;
            }
            Location parent = location.getParent();
            if (parent == null) {
                this.addChild((Location)location);
            }
            machinesCopy.add(location);
        }
        if (!machinesCopy.equals(this.machines)) {
            this.machines = machinesCopy;
        }
    }

    @Override
    public String toVerboseString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId()).add("name", (Object)this.getDisplayName()).add("machinesAvailable", this.getAvailable()).add("machinesInUse", this.getInUse()).toString();
    }

    @Override
    public AbstractLocation configure(Map<?, ?> properties) {
        if (this.machines == null) {
            this.machines = Sets.newLinkedHashSet();
        }
        if (this.inUse == null) {
            this.inUse = Sets.newLinkedHashSet();
        }
        if (this.pendingRemoval == null) {
            this.pendingRemoval = Sets.newLinkedHashSet();
        }
        if (this.origConfigs == null) {
            this.origConfigs = Maps.newLinkedHashMap();
        }
        return super.configure((Map)properties);
    }

    public FixedListMachineProvisioningLocation<T> newSubLocation(Map<?, ?> newFlags) {
        return (FixedListMachineProvisioningLocation)this.getManagementContext().getLocationManager().createLocation((LocationSpec)((LocationSpec)LocationSpec.create(this.getClass()).parent((Location)this).configure(this.config().getAllLocalRaw())).configure(newFlags));
    }

    @Override
    public void close() {
        for (MachineLocation machine : this.machines) {
            if (!(machine instanceof Closeable)) continue;
            Streams.closeQuietly((Closeable)((Closeable)machine));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMachine(T machine) {
        Object object = this.lock;
        synchronized (object) {
            if (this.machines.contains(machine)) {
                throw new IllegalArgumentException("Cannot add " + machine + " to " + this.toString() + ", because already contained");
            }
            Location existingParent = machine.getParent();
            if (existingParent == null) {
                this.addChild((Location)machine);
            }
            this.machines.add(machine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMachine(T machine) {
        Object object = this.lock;
        synchronized (object) {
            if (this.inUse.contains(machine)) {
                this.pendingRemoval.add(machine);
            } else {
                this.machines.remove(machine);
                this.pendingRemoval.remove(machine);
                if (this.equals(machine.getParent())) {
                    this.removeChild((Location)machine);
                }
            }
        }
    }

    protected Set<T> getMachines() {
        return this.machines;
    }

    public Set<T> getAvailable() {
        LinkedHashSet a = Sets.newLinkedHashSet(this.machines);
        a.removeAll(this.inUse);
        return a;
    }

    public Set<T> getInUse() {
        return Sets.newLinkedHashSet(this.inUse);
    }

    public Set<T> getAllMachines() {
        return ImmutableSet.copyOf(this.machines);
    }

    @Override
    public void addChild(Location child) {
        super.addChild(child);
        this.machines.add((MachineLocation)child);
    }

    @Override
    public boolean removeChild(Location child) {
        if (this.inUse.contains(child)) {
            throw new IllegalStateException("Child location " + child + " is in use; cannot remove from " + this);
        }
        this.machines.remove(child);
        return super.removeChild(child);
    }

    protected boolean canProvisionMore() {
        return false;
    }

    protected void provisionMore(int size) {
        this.provisionMore(size, (Map<?, ?>)ImmutableMap.of());
    }

    protected void provisionMore(int size, Map<?, ?> flags) {
        throw new IllegalStateException("more not permitted");
    }

    public T obtain() throws NoMachinesAvailableException {
        return this.obtain(Maps.newLinkedHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        MachineLocation machine;
        MachineLocation desiredMachine = (MachineLocation)flags.get("desiredMachine");
        ConfigBag allflags = ConfigBag.newInstanceExtending(this.config().getBag()).putAll(flags);
        Function<Iterable<? extends MachineLocation>, MachineLocation> chooser = allflags.get(MACHINE_CHOOSER);
        Iterator<MachineLocationCustomizer> iterator = this.lock;
        synchronized (iterator) {
            Set<T> a = this.getAvailable();
            if (a.isEmpty()) {
                if (this.canProvisionMore()) {
                    this.provisionMore(1, allflags.getAllConfig());
                    a = this.getAvailable();
                }
                if (a.isEmpty()) {
                    throw new NoMachinesAvailableException("No machines available in " + this.toString());
                }
            }
            if (desiredMachine != null) {
                if (!a.contains(desiredMachine)) throw new IllegalStateException("Desired machine " + desiredMachine + " not available in " + this.toString() + "; " + (this.inUse.contains(desiredMachine) ? "machine in use" : "machine unknown"));
                machine = desiredMachine;
            } else {
                machine = (MachineLocation)chooser.apply(a);
                if (!a.contains(machine)) {
                    throw new IllegalStateException("Machine chooser attempted to choose '" + machine + "' from outside the available set, in " + this);
                }
            }
            this.inUse.add(machine);
            this.updateMachineConfig(machine, flags);
        }
        for (MachineLocationCustomizer customizer : this.getMachineCustomizers(allflags)) {
            customizer.customize(machine);
        }
        return (T)machine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T machine) {
        ConfigBag machineConfig = ((BrooklynObjectInternal.ConfigurationSupportInternal)machine.config()).getBag();
        for (MachineLocationCustomizer customizer : this.getMachineCustomizers(machineConfig)) {
            customizer.preRelease(machine);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.inUse.contains(machine)) {
                throw new IllegalStateException("Request to release machine " + machine + ", but this machine is not currently allocated");
            }
            this.restoreMachineConfig((MachineLocation)machine);
            this.inUse.remove(machine);
            if (this.pendingRemoval.contains(machine)) {
                this.removeMachine(machine);
            }
        }
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return Maps.newLinkedHashMap();
    }

    protected void updateMachineConfig(T machine, Map<?, ?> flags) {
        if (this.origConfigs == null) {
            this.origConfigs = Maps.newLinkedHashMap();
        }
        Map<String, Object> strFlags = ConfigBag.newInstance(flags).getAllConfig();
        Map<String, Object> origConfig = ((BrooklynObjectInternal.ConfigurationSupportInternal)machine.config()).getLocalBag().getAllConfig();
        this.origConfigs.put(machine, origConfig);
        this.requestPersist();
        ((BrooklynObjectInternal.ConfigurationSupportInternal)machine.config()).putAll(strFlags);
    }

    protected void restoreMachineConfig(MachineLocation machine) {
        Map<String, Object> origConfig;
        if (this.origConfigs == null) {
            this.origConfigs = Maps.newLinkedHashMap();
        }
        if ((origConfig = this.origConfigs.remove(machine)) == null) {
            return;
        }
        this.requestPersist();
        Set<String> currentKeys = ((BrooklynObjectInternal.ConfigurationSupportInternal)machine.config()).getLocalBag().getAllConfig().keySet();
        Sets.SetView newKeys = Sets.difference(currentKeys, origConfig.entrySet());
        for (String key : newKeys) {
            ((BrooklynObjectInternal.ConfigurationSupportInternal)machine.config()).removeKey(key);
        }
        ((BrooklynObjectInternal.ConfigurationSupportInternal)machine.config()).putAll(origConfig);
    }

    private <K> K getConfigPreferringOverridden(ConfigKey<K> key, Map<?, ?> overrides) {
        Object result = overrides.get(key);
        if (result == null) {
            result = overrides.get(key.getName());
        }
        if (result == null) {
            result = this.getConfig(key);
        }
        return (K)result;
    }

    protected Collection<MachineLocationCustomizer> getMachineCustomizers(ConfigBag setup) {
        Collection<MachineLocationCustomizer> customizers = EntityInitializers.resolve(setup, MACHINE_LOCATION_CUSTOMIZERS);
        return customizers == null ? ImmutableList.of() : customizers;
    }

    public static class Builder {
        LocationManager lm;
        String user;
        String privateKeyPassphrase;
        String privateKeyFile;
        String privateKeyData;
        File localTempDir;
        List machines = Lists.newArrayList();

        public Builder(LocationManager lm) {
            this.lm = lm;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder keyPassphrase(String keyPassphrase) {
            this.privateKeyPassphrase = keyPassphrase;
            return this;
        }

        public Builder keyFile(String keyFile) {
            this.privateKeyFile = keyFile;
            return this;
        }

        public Builder keyData(String keyData) {
            this.privateKeyData = keyData;
            return this;
        }

        public Builder localTempDir(File val) {
            this.localTempDir = val;
            return this;
        }

        public Builder add(SshMachineLocation location) {
            this.machines.add(location);
            return this;
        }

        public Builder addAddress(String address) {
            return this.addAddresses(address, new String[0]);
        }

        public Builder addAddressMultipleTimes(String address, int n) {
            for (int i = 0; i < n; ++i) {
                this.addAddresses(address, new String[0]);
            }
            return this;
        }

        public Builder addAddresses(String address1, String ... others) {
            ArrayList addrs = new ArrayList();
            addrs.addAll(WildcardGlobs.getGlobsAfterBraceExpansion((String)("{" + address1 + "}"), (boolean)true, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR));
            for (String address : others) {
                addrs.addAll(WildcardGlobs.getGlobsAfterBraceExpansion((String)("{" + address + "}"), (boolean)true, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR));
            }
            for (String addr : addrs) {
                this.add(this.createMachine(addr));
            }
            return this;
        }

        protected SshMachineLocation createMachine(String addr) {
            if (this.lm == null) {
                return new SshMachineLocation(this.makeConfig(addr));
            }
            return (SshMachineLocation)this.lm.createLocation(this.makeConfig(addr), SshMachineLocation.class);
        }

        private Map makeConfig(String address) {
            String user = this.user;
            if (address.contains("@")) {
                user = address.substring(0, address.indexOf("@"));
                address = address.substring(address.indexOf("@") + 1);
            }
            MutableMap config = MutableMap.of((Object)"address", (Object)address);
            if (JavaGroovyEquivalents.groovyTruth((String)user)) {
                config.put("user", user);
                config.put("sshconfig.user", user);
            }
            if (JavaGroovyEquivalents.groovyTruth((String)this.privateKeyPassphrase)) {
                config.put("sshconfig.privateKeyPassphrase", this.privateKeyPassphrase);
            }
            if (JavaGroovyEquivalents.groovyTruth((String)this.privateKeyFile)) {
                config.put("sshconfig.privateKeyFile", this.privateKeyFile);
            }
            if (JavaGroovyEquivalents.groovyTruth((String)this.privateKeyData)) {
                config.put("sshconfig.privateKey", this.privateKeyData);
            }
            if (JavaGroovyEquivalents.groovyTruth((Object)this.localTempDir)) {
                config.put("localTempDir", this.localTempDir);
            }
            return config;
        }

        public FixedListMachineProvisioningLocation<SshMachineLocation> build() {
            if (this.lm == null) {
                return new FixedListMachineProvisioningLocation<SshMachineLocation>((Map<?, ?>)MutableMap.builder().putIfNotNull((Object)"machines", (Object)this.machines).putIfNotNull((Object)"user", (Object)this.user).putIfNotNull((Object)"privateKeyPassphrase", (Object)this.privateKeyPassphrase).putIfNotNull((Object)"privateKeyFile", (Object)this.privateKeyFile).putIfNotNull((Object)"privateKeyData", (Object)this.privateKeyData).putIfNotNull((Object)"localTempDir", (Object)this.localTempDir).build());
            }
            return (FixedListMachineProvisioningLocation)this.lm.createLocation((Map)MutableMap.builder().putIfNotNull((Object)"machines", (Object)this.machines).putIfNotNull((Object)"user", (Object)this.user).putIfNotNull((Object)"privateKeyPassphrase", (Object)this.privateKeyPassphrase).putIfNotNull((Object)"privateKeyFile", (Object)this.privateKeyFile).putIfNotNull((Object)"privateKeyData", (Object)this.privateKeyData).putIfNotNull((Object)"localTempDir", (Object)this.localTempDir).build(), FixedListMachineProvisioningLocation.class);
        }
    }
}

