/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang.coerce;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.brooklyn.core.validation.BrooklynValidation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.AnyExceptionSupplier;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.javalang.coerce.ClassCoercionException;
import org.apache.brooklyn.util.javalang.coerce.CoerceFunctionals;
import org.apache.brooklyn.util.javalang.coerce.CommonAdaptorTryCoercions;
import org.apache.brooklyn.util.javalang.coerce.CommonAdaptorTypeCoercions;
import org.apache.brooklyn.util.javalang.coerce.TryCoercer;
import org.apache.brooklyn.util.javalang.coerce.TypeCoercer;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCoercerExtensible
implements TypeCoercer {
    private static final Logger log = LoggerFactory.getLogger(TypeCoercerExtensible.class);
    private final Table<Class<?>, Class<?>, Function<?, ?>> registry = HashBasedTable.create();
    private final Map<String, TryCoercer> genericCoercersByName = Maps.newTreeMap();
    private List<TryCoercer> genericCoercers = new ArrayList<TryCoercer>();

    protected TypeCoercerExtensible() {
    }

    public static TypeCoercerExtensible newDefault() {
        TypeCoercerExtensible result = TypeCoercerExtensible.newEmpty();
        new CommonAdaptorTypeCoercions(result).registerAllAdapters();
        new CommonAdaptorTryCoercions(result).registerAllAdapters();
        return result;
    }

    public static TypeCoercerExtensible newEmpty() {
        return new TypeCoercerExtensible();
    }

    @Override
    public <T> T coerce(Object value, Class<T> targetType) {
        return this.coerce(value, TypeToken.of(targetType));
    }

    public <T> T coerce(Object value, TypeToken<T> targetTypeToken) {
        return this.tryCoerce(value, targetTypeToken).get();
    }

    @Override
    public <T> Maybe<T> tryCoerce(Object input, Class<T> type) {
        return this.changeExceptionSupplier(this.tryCoerceInternal(input, null, type));
    }

    @Override
    public <T> Maybe<T> tryCoerce(Object value, TypeToken<T> targetTypeToken) {
        return this.changeExceptionSupplier(this.tryCoerceInternal(value, targetTypeToken, null));
    }

    protected <T> Maybe<T> changeExceptionSupplier(Maybe<T> result) {
        return Maybe.Absent.changeExceptionSupplier(result, ClassCoercionException.class);
    }

    protected <T> Maybe<T> tryCoerceInternal(Object value, TypeToken<T> targetTypeToken, Class<T> targetType) {
        return this.tryCoerceInternal2(value, targetTypeToken, targetType).map(BrooklynValidation.getInstance()::ensureValid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Maybe<T> tryCoerceInternal2(Object value, TypeToken<T> targetTypeToken, Class<T> targetType) {
        if (value == null) {
            return Maybe.of(null);
        }
        Maybe<T> result = null;
        MutableList errors = MutableList.of();
        targetType = TypeTokens.getRawType(targetTypeToken, targetType);
        if (targetTypeToken != null && targetTypeToken.getType() instanceof ParameterizedType) {
            if (value instanceof Iterable && Iterable.class.isAssignableFrom(targetType)) {
                result = this.tryCoerceIterable(value, targetTypeToken, targetType);
            } else if (value.getClass().isArray() && Iterable.class.isAssignableFrom(targetType)) {
                result = this.tryCoerceArray(value, targetTypeToken, targetType);
            } else if (value instanceof Map && Map.class.isAssignableFrom(targetType)) {
                result = this.tryCoerceMap(value, targetTypeToken);
            }
            if (result != null) {
                if (result.isPresent()) {
                    return result;
                }
                TypeToken targetTypeTokenF = targetTypeToken;
                RuntimeException e = Maybe.getException(result);
                return Maybe.absent(new AnyExceptionSupplier<ClassCoercionException>(ClassCoercionException.class, (Supplier<String>)((Supplier)() -> "Generic type mismatch coercing " + value.getClass().getName() + " to " + targetTypeTokenF + ": " + Exceptions.collapseText(e)), (Throwable)e));
            }
        }
        if (targetType.isInstance(value)) {
            return Maybe.of(value);
        }
        targetTypeToken = TypeTokens.getTypeToken(targetTypeToken, targetType);
        for (TryCoercer coercer : this.genericCoercers) {
            result = coercer.tryCoerce(value, targetTypeToken);
            if (result != null && result.isPresentAndNonNull()) {
                if (!Objects.equal((Object)value, result.get()) && !Objects.equal(value.getClass(), result.get().getClass())) {
                    Maybe<T> resultM = this.tryCoerce(result.get(), targetTypeToken);
                    if (resultM != null) {
                        if (resultM.isPresent()) {
                            return resultM;
                        }
                        result = resultM;
                    }
                } else {
                    return result;
                }
            }
            if (result == null) continue;
            if (result.isAbsent()) {
                errors.add(result);
                continue;
            }
            if (coercer instanceof TryCoercer.TryCoercerReturningNull) {
                return result;
            }
            String c = this.getCoercerName(coercer);
            log.warn("Coercer " + c + " returned wrapped null when coercing " + value);
            errors.add(Maybe.absent("coercion returned null (" + c + ")"));
        }
        Class<T> boxedT = (Class<T>)Boxing.PRIMITIVE_TO_BOXED.get(targetType);
        Class boxedVT = (Class)Boxing.PRIMITIVE_TO_BOXED.get(value.getClass());
        if (boxedT != null || boxedVT != null) {
            try {
                if (boxedT == null) {
                    boxedT = targetType;
                }
                Object boxedV = boxedVT == null ? value : boxedVT.getConstructor(value.getClass()).newInstance(value);
                return this.tryCoerce(boxedV, boxedT);
            }
            catch (Exception e) {
                return Maybe.absent(new ClassCoercionException("Cannot coerce type " + value.getClass() + " to " + targetType.getCanonicalName() + " (" + value + "): unboxing failed", e));
            }
        }
        Table<Class<?>, Class<?>, Function<?, ?>> table = this.registry;
        synchronized (table) {
            Map adapters = this.registry.row(targetType);
            for (Map.Entry entry : adapters.entrySet()) {
                if (!((Class)entry.getKey()).isInstance(value)) continue;
                try {
                    Object resultT = ((Function)entry.getValue()).apply(value);
                    if (!Objects.equal((Object)value, (Object)resultT) && targetTypeToken.getType() instanceof ParameterizedType) {
                        Maybe<T> resultM = this.tryCoerce(resultT, targetTypeToken);
                        if (resultM == null) continue;
                        if (resultM.isPresent()) {
                            return resultM;
                        }
                        errors.add(resultM);
                        continue;
                    }
                    return Maybe.of(resultT);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal(e);
                    if (log.isDebugEnabled()) {
                        log.debug("When coercing, registry adapter " + entry + " gave error on " + value + " -> " + targetType + " " + (errors.isEmpty() ? "(rethrowing)" : "(adding as secondary error as there is already another)") + ": " + e, (Throwable)e);
                    }
                    if (e instanceof ClassCoercionException) {
                        errors.add(Maybe.absent(e));
                        continue;
                    }
                    errors.add(Maybe.absent(new ClassCoercionException("Cannot coerce type " + value.getClass().getCanonicalName() + " to " + targetTypeToken + " (" + value + "): registered coercer failed", e)));
                }
            }
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                return (Maybe)Iterables.getOnlyElement(errors);
            }
            return Maybe.absent(Exceptions.create(errors.stream().map(Maybe::getException).collect(Collectors.toList())));
        }
        if (value instanceof Map) {
            if (((Map)value).containsKey("type")) {
                return Maybe.absent(new ClassCoercionException("Cannot coerce map containing {type: \"" + ((Map)value).get("type") + "\"} to " + targetTypeToken + ": type not known or not supported here"));
            }
            return Maybe.absent(new ClassCoercionException("Cannot coerce map to " + targetTypeToken + " (" + value + "): no adapter known"));
        }
        return Maybe.absent(new ClassCoercionException("Cannot coerce type " + value.getClass().getCanonicalName() + " to " + targetTypeToken + " (" + value + "): no adapter known"));
    }

    protected String getCoercerName(TryCoercer coercer) {
        Optional<Map.Entry> bn = this.genericCoercersByName.entrySet().stream().filter(es -> Objects.equal((Object)coercer, es.getValue())).findAny();
        if (bn.isPresent()) {
            return (String)bn.get().getKey();
        }
        int index = this.genericCoercers.indexOf(coercer);
        return coercer.toString() + (index >= 0 ? " (index " + index + ")" : "");
    }

    protected <T> Maybe<T> tryCoerceMap(Object value, TypeToken<T> targetTypeToken) {
        if (!(value instanceof Map) || !TypeTokens.isAssignableFromRaw(Map.class, targetTypeToken)) {
            return null;
        }
        Type[] arguments = ((ParameterizedType)targetTypeToken.getType()).getActualTypeArguments();
        if (arguments.length != 2) {
            throw new IllegalStateException("Unexpected number of parameters in map type: " + arguments);
        }
        LinkedHashMap coerced = Maps.newLinkedHashMap();
        TypeToken mapKeyType = TypeToken.of((Type)arguments[0]);
        TypeToken mapValueType = TypeToken.of((Type)arguments[1]);
        int i = 0;
        for (Map.Entry entry : ((Map)value).entrySet()) {
            Maybe<T> k = this.tryCoerce(entry.getKey(), mapKeyType);
            if (k.isAbsent()) {
                return Maybe.absent(new ClassCoercionException("Could not coerce key of entry " + i + " (" + entry.getKey() + ") to " + mapKeyType + " in " + targetTypeToken, ((Maybe.Absent)k).getException()));
            }
            Maybe<T> v = this.tryCoerce(entry.getValue(), mapValueType);
            if (v.isAbsent()) {
                return Maybe.absent(new ClassCoercionException("Could not coerce value of entry " + i + " (" + entry.getValue() + ") to " + mapValueType + " in " + targetTypeToken, ((Maybe.Absent)v).getException()));
            }
            coerced.put(k.get(), v.get());
            ++i;
        }
        return Maybe.of(Maps.newLinkedHashMap((Map)coerced));
    }

    protected <T> Maybe<T> tryCoerceArray(Object value, TypeToken<T> targetTypeToken, Class<? super T> targetType) {
        List<?> listValue = Reflections.arrayToList(value);
        return this.tryCoerceIterable(listValue, targetTypeToken, targetType);
    }

    protected <T> Maybe<T> tryCoerceIterable(Object value, TypeToken<T> targetTypeToken, Class<? super T> targetType) {
        if (!(value instanceof Iterable) || !TypeTokens.isAssignableFromRaw(Iterable.class, targetTypeToken)) {
            return null;
        }
        Type[] arguments = ((ParameterizedType)targetTypeToken.getType()).getActualTypeArguments();
        if (arguments.length != 1) {
            return Maybe.absent(new IllegalStateException("Unexpected number of parameters in iterable type: " + arguments));
        }
        LinkedList coerced = Lists.newLinkedList();
        TypeToken listEntryType = TypeToken.of((Type)arguments[0]);
        int i = 0;
        for (Object entry : (Iterable)value) {
            Maybe<T> entryCoerced = this.tryCoerce(entry, listEntryType);
            if (!entryCoerced.isPresent()) {
                return Maybe.absent(new ClassCoercionException("Could not coerce entry " + i + " (" + entry + ") to " + listEntryType, ((Maybe.Absent)entryCoerced).getException()));
            }
            coerced.add(entryCoerced.get());
            ++i;
        }
        if (Set.class.isAssignableFrom(targetType)) {
            return Maybe.of(Sets.newLinkedHashSet((Iterable)coerced));
        }
        return Maybe.of(Lists.newArrayList((Iterable)coerced));
    }

    public <T> Function<Object, T> function(Class<T> type) {
        return new CoerceFunctionals.CoerceFunction<T>(this, type);
    }

    public synchronized <A, B> Function<? super A, B> registerAdapter(Class<A> sourceType, Class<B> targetType, Function<? super A, B> fn) {
        return (Function)this.registry.put(targetType, sourceType, fn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public synchronized void registerAdapter(String nameAndOrder, TryCoercer fn) {
        Map<String, TryCoercer> map = this.genericCoercersByName;
        synchronized (map) {
            this.genericCoercersByName.put(nameAndOrder, fn);
            this.genericCoercers = ImmutableList.copyOf(this.genericCoercersByName.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Beta
    public synchronized void registerAdapter(TryCoercer fn) {
        Map<String, TryCoercer> map = this.genericCoercersByName;
        synchronized (map) {
            this.genericCoercersByName.put(Time.makeDateStampString() + "-" + Strings.makePaddedString("" + this.genericCoercersByName.size(), 3, "0", ""), fn);
            this.genericCoercers = ImmutableList.copyOf(this.genericCoercersByName.values());
        }
    }
}

