/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.winrm;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineDetails;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.location.AbstractMachineLocation;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.ManagementContextInjectable;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.location.ssh.CanResolveOnBoxDir;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.internal.winrm.WinRmTool;
import org.apache.brooklyn.util.core.internal.winrm.WinRmToolResponse;
import org.apache.brooklyn.util.core.internal.winrm.winrm4j.Winrm4jTool;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmMachineLocation
extends AbstractMachineLocation
implements MachineLocation,
CanResolveOnBoxDir {
    private static final Logger LOG = LoggerFactory.getLogger(WinRmMachineLocation.class);
    private static final Logger logWinRm = LoggerFactory.getLogger((String)"org.apache.brooklyn.WinRm");
    public static final ConfigKey<InetAddress> ADDRESS = ConfigKeys.newConfigKey(InetAddress.class, (String)"address", (String)"Address of the remote machine");
    public static final ConfigKey<Integer> WINRM_CONFIG_PORT = ConfigKeys.newConfigKeyWithPrefix((String)"brooklyn.winrm.config.", WinRmTool.PROP_PORT);
    public static final ConfigKey<String> OPERATION_TIMEOUT = ConfigKeys.newConfigKeyWithPrefix((String)"brooklyn.winrm.config.", WinRmTool.OPERATION_TIMEOUT);
    public static final ConfigKey<Integer> RETRIES_OF_NETWORK_FAILURES = ConfigKeys.newConfigKeyWithPrefix((String)"brooklyn.winrm.config.", WinRmTool.RETRIES_OF_NETWORK_FAILURES);
    public static final ConfigKey<Boolean> USE_HTTPS_WINRM = WinRmTool.USE_HTTPS_WINRM;
    public static final ConfigKey<String> WAIT_WINDOWS_TO_START = ConfigKeys.newStringConfigKey((String)"waitWindowsToStart", (String)"By default Brooklyn will return the machine immediately after Brooklyn is able to WinRM. Sometimes restart could happen after a Windows VM is provisioned. This could be because of System Upgrade or other. By setting this config key to 60s, 5m or other X Duration of time Brooklyn will wait X amount of time for disconnect to occur. If connection failure occurs it will wait X amount of time for the machine to come up.", null);
    @Beta
    public static final ConfigKey<Boolean> USE_NTLM = WinRmTool.USE_NTLM;
    public static final ConfigKey<String> USER = WinRmTool.PROP_USER;
    public static final ConfigKey<String> PASSWORD = WinRmTool.PROP_PASSWORD;
    public static final ConfigKey<Integer> COPY_FILE_CHUNK_SIZE_BYTES = WinRmTool.COPY_FILE_CHUNK_SIZE_BYTES;
    public static final ConfigKey<String> WINRM_TOOL_CLASS = ConfigKeys.newConfigKeyWithPrefixRemoved((String)"brooklyn.winrm.config.", (ConfigKey)((ConfigKey)Preconditions.checkNotNull((Object)BrooklynConfigKeys.WINRM_TOOL_CLASS, (Object)"static final initializer classload ordering problem")));
    public static final String WINRM_TOOL_CLASS_PROPERTIES_PREFIX = WINRM_TOOL_CLASS.getName() + ".";
    @Deprecated
    public static final ConfigKey<Integer> EXECUTION_ATTEMPTS = ConfigKeys.newIntegerConfigKey((String)"windows.exec.attempts", (String)"Number of attempts to execute a remote command", (Integer)1);
    public static final ConfigKey<Integer> EXEC_TRIES = WinRmTool.PROP_EXEC_TRIES;
    public static final ConfigKey<Iterable<String>> PRIVATE_ADDRESSES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Iterable<String>>(){}, (String)"privateAddresses", (String)"Private addresses of this machine, e.g. those within the private network", null);
    public static final ConfigKey<Map<Integer, String>> TCP_PORT_MAPPINGS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<Integer, String>>(){}, (String)"tcpPortMappings", (String)"NAT'ed ports, giving the mapping from private TCP port to a public host:port", null);
    public static final Set<ConfigKey.HasConfigKey<?>> ALL_WINRM_CONFIG_KEYS = ImmutableSet.builder().addAll((Iterable)ConfigUtils.getStaticKeysOnClass(WinRmMachineLocation.class)).addAll((Iterable)ConfigUtils.getStaticKeysOnClass(WinRmTool.class)).build();
    public static final Set<String> ALL_WINRM_CONFIG_KEY_NAMES = ImmutableSet.copyOf((Iterable)Iterables.transform(ALL_WINRM_CONFIG_KEYS, (Function)new Function<ConfigKey.HasConfigKey<?>, String>(){

        public String apply(ConfigKey.HasConfigKey<?> input) {
            return input.getConfigKey().getName();
        }
    }));

    public void init() {
        super.init();
        Map tcpPortMappings = (Map)this.getConfig(TCP_PORT_MAPPINGS);
        if (tcpPortMappings != null) {
            PortForwardManager pfm = (PortForwardManager)this.getManagementContext().getLocationRegistry().getLocationManaged("portForwardManager(scope=global)");
            for (Map.Entry entry : tcpPortMappings.entrySet()) {
                int targetPort = (Integer)entry.getKey();
                HostAndPort publicEndpoint = HostAndPort.fromString((String)((String)entry.getValue()));
                if (!publicEndpoint.hasPort()) {
                    throw new IllegalArgumentException("Invalid portMapping ('" + (String)entry.getValue() + "') for port " + targetPort + " in machine " + (Object)((Object)this));
                }
                pfm.associate(publicEndpoint.getHost(), publicEndpoint, (Location)this, targetPort);
            }
        }
    }

    protected MachineDetails detectMachineDetails() {
        return UNKNOWN_MACHINE_DETAILS;
    }

    public String getUser() {
        return (String)this.config().get(USER);
    }

    public int execCommands(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        ImmutableMap properties = ImmutableMap.builder().putAll(props).put((Object)Winrm4jTool.ENVIRONMENT, env).build();
        return this.executeCommand((Map<?, ?>)properties, commands).getStatusCode();
    }

    public int execScript(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        ImmutableMap properties = ImmutableMap.builder().putAll(props).put((Object)Winrm4jTool.ENVIRONMENT, env).build();
        return this.executePsScript((Map<?, ?>)properties, commands).getStatusCode();
    }

    public InetAddress getAddress() {
        return (InetAddress)this.getConfig(ADDRESS);
    }

    public OsDetails getOsDetails() {
        return null;
    }

    public MachineDetails getMachineDetails() {
        return null;
    }

    @Nullable
    public String getHostname() {
        InetAddress address = this.getAddress();
        return address != null ? address.getHostAddress() : null;
    }

    @Nullable
    protected String getHostAndPort() {
        String host = this.getHostname();
        return host == null ? null : host + ":" + this.getPort();
    }

    public int getPort() {
        Maybe raw = this.config().getRaw(WinRmTool.PROP_PORT);
        if (raw.orNull() == null && this.config().getRaw(WINRM_CONFIG_PORT).orNull() != null) {
            return (Integer)this.config().get(WINRM_CONFIG_PORT);
        }
        Integer result = (Integer)this.config().get(WinRmTool.PROP_PORT);
        return result != null ? result.intValue() : this.getDefaultPort();
    }

    private int getDefaultPort() {
        return (Boolean)this.getConfig(USE_HTTPS_WINRM) != false ? 5986 : 5985;
    }

    public Set<String> getPublicAddresses() {
        InetAddress address = this.getAddress();
        return address == null ? ImmutableSet.of() : ImmutableSet.of((Object)address.getHostAddress());
    }

    public Set<String> getPrivateAddresses() {
        Iterable result = (Iterable)this.getConfig(PRIVATE_ADDRESSES);
        return result == null ? ImmutableSet.of() : ImmutableSet.copyOf((Iterable)result);
    }

    @Deprecated
    public WinRmToolResponse executeScript(String script) {
        return this.executeCommand(script);
    }

    @Deprecated
    public WinRmToolResponse executeScript(List<String> script) {
        return this.executeCommand(script);
    }

    @Deprecated
    public WinRmToolResponse executeScript(Map<?, ?> props, List<String> script) {
        return this.executeCommand(props, script);
    }

    public WinRmToolResponse executeCommand(String script) {
        return this.executeCommand((List<String>)ImmutableList.of((Object)script));
    }

    public WinRmToolResponse executeCommand(List<String> script) {
        return this.executeCommand((Map<?, ?>)ImmutableMap.of(), script);
    }

    public WinRmToolResponse executeCommand(Map<?, ?> props, List<String> script) {
        WinRmTool tool = this.newWinRmTool(props);
        return this.runWithLogging(props, script, (Supplier<WinRmToolResponse>)((Supplier)() -> tool.executeCommand(script)));
    }

    public WinRmToolResponse executePsScript(String psScript) {
        return this.executePsScript((Map<?, ?>)ImmutableMap.of(), (List<String>)ImmutableList.of((Object)psScript));
    }

    public WinRmToolResponse executePsScript(List<String> psScript) {
        return this.executePsScript((Map<?, ?>)ImmutableMap.of(), psScript);
    }

    public WinRmToolResponse executePsScript(Map<?, ?> props, List<String> psScript) {
        WinRmTool tool = this.newWinRmTool(props);
        return this.runWithLogging(props, psScript, (Supplier<WinRmToolResponse>)((Supplier)() -> tool.executePs(psScript)));
    }

    private WinRmToolResponse runWithLogging(Map<?, ?> props, List<String> stdinToLog, Supplier<WinRmToolResponse> r) {
        String user = this.getUser();
        String prefix = "[" + (user != null ? user + "@" : "") + this.getHostAndPort() + "]";
        if (logWinRm.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            Sanitizer.sanitizeMapToString((Map)((Map)props.get(WinRmTool.ENVIRONMENT)), (StringBuilder)sb);
            this.logIfPresent("{} env: {}", prefix, sb.toString());
            this.logIfPresent("{} stdin: {}", prefix, stdinToLog != null ? Strings.join(stdinToLog, (String)"\n") : null);
        }
        WinRmToolResponse result = (WinRmToolResponse)r.get();
        if (logWinRm.isDebugEnabled()) {
            this.logIfPresent("{} status code: {}", prefix, "" + result.getStatusCode());
            this.logIfPresent("{} stdout: {}", prefix, this.getBuffer("stdout", props, ShellTool.PROP_OUT_STREAM, (Supplier<String>)((Supplier)result::getStdOut)));
            this.logIfPresent("{} winrm: {}", prefix, (String)this.getTaskStream("winrm").map(s -> (String)s.streamContents.get()).orNull());
            this.logIfPresent("{} stderr: {}", prefix, this.getBuffer("stderr", props, ShellTool.PROP_ERR_STREAM, (Supplier<String>)((Supplier)result::getStdErr)));
        }
        return result;
    }

    private String getBuffer(String firstTryStreamType, Map<?, ?> secondTryProps, Object secondTryKey, Supplier<String> thirdTryFallback) {
        return (String)this.getTaskStream(firstTryStreamType).map(s -> (String)s.streamContents.get()).orMaybe(() -> this.getBufferOutput(secondTryProps, secondTryKey)).or(thirdTryFallback);
    }

    private Maybe<BrooklynTaskTags.WrappedStream> getTaskStream(String streamType) {
        return Maybe.ofDisallowingNull((Object)BrooklynTaskTags.stream((Task)Tasks.current(), (String)streamType)).or(Maybe.absent());
    }

    private Maybe<String> getBufferOutput(Map<?, ?> props, Object key) {
        if (props == null) {
            return Maybe.absent();
        }
        Object b = props.get(key);
        if (b == null && key instanceof ConfigKey) {
            b = props.get(((ConfigKey)key).getName());
        }
        if (b == null) {
            return Maybe.absent();
        }
        if (b instanceof String) {
            return Maybe.of((Object)((String)b));
        }
        if (b instanceof ByteArrayOutputStream) {
            return Maybe.of((Object)new String(((ByteArrayOutputStream)b).toByteArray()));
        }
        return Maybe.of((Object)("" + b));
    }

    private void logIfPresent(String format, String prefix, String output) {
        if (Strings.isNonEmpty((CharSequence)output)) {
            logWinRm.debug(format, (Object)prefix, (Object)output);
        }
    }

    protected WinRmTool newWinRmTool(Map<?, ?> props) {
        try {
            WinRmTool tool;
            String toolClass;
            ConfigBag args = new ConfigBag();
            for (Map.Entry entry : this.config().getBag().getAllConfigAsConfigKeyMap().entrySet()) {
                boolean include = false;
                String keyName = ((ConfigKey)entry.getKey()).getName();
                if (keyName.startsWith(WinRmTool.BROOKLYN_CONFIG_KEY_PREFIX)) {
                    keyName = Strings.removeFromStart((String)keyName, (String)WinRmTool.BROOKLYN_CONFIG_KEY_PREFIX);
                    include = true;
                }
                if (keyName.startsWith(WINRM_TOOL_CLASS_PROPERTIES_PREFIX)) {
                    keyName = Strings.removeFromStart((String)keyName, (String)WINRM_TOOL_CLASS_PROPERTIES_PREFIX);
                    include = true;
                }
                if (ALL_WINRM_CONFIG_KEY_NAMES.contains(keyName)) {
                    include = true;
                }
                if (!include) continue;
                args.putStringKey(keyName, this.config().get((ConfigKey)entry.getKey()));
            }
            args.putAll(props);
            args.configure(SshTool.PROP_HOST, (Object)this.getAddress().getHostAddress());
            args.configure(WinRmTool.USE_NTLM, this.getConfig(USE_NTLM));
            args.configure(WinRmTool.PROP_PORT, (Object)this.getPort());
            if (LOG.isTraceEnabled()) {
                LOG.trace("creating WinRM session for " + Sanitizer.sanitize((ConfigBag)args));
            }
            if ((toolClass = (String)args.get(WINRM_TOOL_CLASS)) == null) {
                toolClass = Winrm4jTool.class.getName();
            }
            if ((tool = (WinRmTool)new ClassLoaderUtils((Object)this, this.getManagementContext()).loadClass(toolClass).getConstructor(Map.class).newInstance(args.getAllConfig())) instanceof ManagementContextInjectable) {
                ((ManagementContextInjectable)tool).setManagementContext(this.getManagementContext());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("using ssh-tool {} (of type {}); props ", (Object)tool, (Object)toolClass);
            }
            return tool;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public int copyTo(File source, String destination) {
        FileInputStream sourceStream = null;
        try {
            sourceStream = new FileInputStream(source);
            int n = this.copyTo(sourceStream, destination);
            return n;
        }
        catch (FileNotFoundException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            if (sourceStream != null) {
                Streams.closeQuietly((Closeable)sourceStream);
            }
        }
    }

    public int copyTo(InputStream source, String destination) {
        return this.copyTo((Map<?, ?>)ImmutableMap.of(), source, destination);
    }

    public int copyTo(Map<?, ?> props, InputStream source, String destination) {
        WinRmTool tool = this.newWinRmTool(props);
        WinRmToolResponse response = tool.copyToServer(source, destination);
        return response.getStatusCode();
    }

    public static String getDefaultUserMetadataString(BrooklynObjectInternal.ConfigurationSupportInternal config) {
        String unencodePowershell = Joiner.on((String)"\r\n").join((Iterable)ImmutableList.of((Object)"$RDP = Get-WmiObject -Class Win32_TerminalServiceSetting -ComputerName $env:computername -Namespace root\\CIMV2\\TerminalServices -Authentication PacketPrivacy", (Object)"$RDP.SetAllowTSConnections(1,1)", (Object)"Set-ExecutionPolicy Unrestricted -Force", (Object)"Set-Item WSMan:\\localhost\\Shell\\MaxConcurrentUsers 100", (Object)"Set-Item WSMan:\\localhost\\Shell\\MaxMemoryPerShellMB 0", (Object)"Set-Item WSMan:\\localhost\\Shell\\MaxProcessesPerShell 0", (Object)"Set-Item WSMan:\\localhost\\Shell\\MaxShellsPerUser 0", (Object)"New-ItemProperty \"HKLM:\\System\\CurrentControlSet\\Control\\LSA\" -Name \"SuppressExtendedProtection\" -Value 1 -PropertyType \"DWord\"", (Object)"$allowed = @('WSMAN/*')", (Object)"$key = 'hklm:\\SOFTWARE\\Policies\\Microsoft\\Windows\\CredentialsDelegation'", (Object)"if (!(Test-Path $key)) {", (Object)"    md $key", (Object[])new String[]{"}", "New-ItemProperty -Path $key -Name AllowFreshCredentials -Value 1 -PropertyType Dword -Force", "New-ItemProperty -Path $key -Name AllowFreshCredentialsWhenNTLMOnly -Value 1 -PropertyType Dword -Force", "$credKey = Join-Path $key 'AllowFreshCredentials'", "if (!(Test-Path $credKey)) {", "    md $credkey", "}", "$ntlmKey = Join-Path $key 'AllowFreshCredentialsWhenNTLMOnly'", "if (!(Test-Path $ntlmKey)) {", "    md $ntlmKey", "}", "$i = 1", "$allowed |% {", "    # Script does not take into account existing entries in this key", "    New-ItemProperty -Path $credKey -Name $i -Value $_ -PropertyType String -Force", "    New-ItemProperty -Path $ntlmKey -Name $i -Value $_ -PropertyType String -Force", "    $i++", "}"}));
        boolean useSecureWinrm = (Boolean)config.getBag().get(USE_HTTPS_WINRM);
        boolean basicAuth = (Boolean)config.getBag().get(USE_NTLM) == false;
        boolean allowUnencrypted = !useSecureWinrm;
        int port = useSecureWinrm ? 5986 : 5985;
        String encoded = new String(Base64.encodeBase64((byte[])unencodePowershell.getBytes(Charsets.UTF_16LE)));
        return String.format("winrm quickconfig -q & winrm set winrm/config/service/auth @{Basic=\"%1$s\"} & winrm set winrm/config/service @{AllowUnencrypted=\"%2$s\"} & winrm set winrm/config/winrs @{MaxConcurrentUsers=\"100\"} & winrm set winrm/config/winrs @{MaxMemoryPerShellMB=\"0\"} & winrm set winrm/config/winrs @{MaxProcessesPerShell=\"0\"} & winrm set winrm/config/winrs @{MaxShellsPerUser=\"0\"} & netsh advfirewall firewall add rule name=RDP dir=in protocol=tcp localport=3389 action=allow profile=any & netsh advfirewall firewall add rule name=WinRM dir=in protocol=tcp localport=%3$d action=allow profile=any & powershell -EncodedCommand ", basicAuth, allowUnencrypted, port) + encoded;
    }

    public String resolveOnBoxDirFor(Entity entity, String unresolvedPath) {
        if (unresolvedPath.startsWith("./") || unresolvedPath.startsWith("~/")) {
            unresolvedPath = "C:\\" + unresolvedPath.substring(2);
        }
        return unresolvedPath.replaceAll("/", "\\");
    }

    /*
     * Exception decompiling
     */
    public int installTo(ResourceUtils utils, Map<String, ?> props, String url, String destPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 11 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

