/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.http.HttpResponse;

@Singleton
public class ParseJobStatus
implements Function<HttpResponse, JobStatus> {
    public JobStatus apply(HttpResponse from) {
        if (from.getStatusCode() == 202) {
            return JobStatus.IN_PROGRESS;
        }
        if (from.getStatusCode() == 204) {
            return JobStatus.NO_CONTENT;
        }
        if (from.getStatusCode() == 200) {
            return JobStatus.DONE;
        }
        return JobStatus.FAILED;
    }

    public static enum JobStatus {
        DONE,
        IN_PROGRESS,
        FAILED,
        NO_CONTENT,
        UNRECOGNIZED;


        public static JobStatus fromValue(String text) {
            return (JobStatus)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }
    }
}

