/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynType;
import org.apache.brooklyn.config.ConfigInheritance;
import org.apache.brooklyn.config.ConfigInheritances;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.objs.BrooklynTypeSnapshot;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrooklynDynamicType<T extends BrooklynObject, AbstractT extends AbstractBrooklynObject> {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynDynamicType.class);
    protected final Class<? extends T> brooklynClass;
    protected final AbstractT instance;
    protected volatile String name;
    protected final Map<String, FieldAndValue<ConfigKey<?>>> configKeysNCC = new LinkedHashMap();
    protected final transient ReadWriteLock configKeysRW = new ReentrantReadWriteLock();
    private volatile BrooklynTypeSnapshot snapshot;
    private final AtomicBoolean snapshotValid = new AtomicBoolean(false);

    public BrooklynDynamicType(AbstractT instance) {
        this(instance.getClass(), instance);
    }

    public BrooklynDynamicType(Class<? extends T> clazz) {
        this(clazz, null);
    }

    protected BrooklynDynamicType(Class<? extends T> clazz, AbstractT instance) {
        this.brooklynClass = (Class)Preconditions.checkNotNull(clazz, (Object)"brooklyn class");
        this.instance = instance;
        this.name = clazz.getCanonicalName() == null ? clazz.getName() : clazz.getCanonicalName();
        BrooklynDynamicType.buildConfigKeys(clazz, null, this.configKeysNCC);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Entity {} config keys: {}", (Object)(instance == null ? clazz.getName() : ((AbstractBrooklynObject)instance).getId()), (Object)Joiner.on((String)", ").join(this.configKeysNCC.keySet()));
        }
    }

    protected abstract BrooklynTypeSnapshot newSnapshot();

    protected void invalidateSnapshot() {
        this.snapshotValid.set(false);
    }

    public void setName(String name) {
        if (Strings.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Invalid name " + (name == null ? "null" : "'" + name + "'") + "; name must be non-empty and not just white space");
        }
        this.name = name;
        this.invalidateSnapshot();
    }

    public synchronized BrooklynType getSnapshot() {
        return this.refreshSnapshot();
    }

    public Class<? extends T> getBrooklynClass() {
        return this.brooklynClass;
    }

    protected Map<String, ConfigKey<?>> getConfigKeysModifiableCopy() {
        return BrooklynDynamicType.withLock(this.configKeysRW.readLock(), () -> BrooklynDynamicType.value(this.configKeysNCC));
    }

    public Map<String, ConfigKey<?>> getConfigKeys() {
        return Collections.unmodifiableMap(this.getConfigKeysModifiableCopy());
    }

    public ConfigKey<?> getConfigKey(String keyName) {
        return (ConfigKey)BrooklynDynamicType.value(BrooklynDynamicType.withLock(this.configKeysRW.readLock(), () -> this.configKeysNCC.get(keyName)));
    }

    public Field getConfigKeyField(String keyName) {
        return BrooklynDynamicType.field(BrooklynDynamicType.withLock(this.configKeysRW.readLock(), () -> this.configKeysNCC.get(keyName)));
    }

    protected BrooklynTypeSnapshot refreshSnapshot() {
        if (this.snapshotValid.compareAndSet(false, true)) {
            this.snapshot = this.newSnapshot();
        }
        return this.snapshot;
    }

    protected static void buildConfigKeys(Class<? extends BrooklynObject> clazz, AbstractBrooklynObject optionalInstance, Map<String, FieldAndValue<ConfigKey<?>>> configKeys) {
        ArrayListMultimap configKeysAll = ArrayListMultimap.create();
        for (Field f : FlagUtils.getAllFields(clazz)) {
            boolean isConfigKey = ConfigKey.class.isAssignableFrom(f.getType());
            if (!isConfigKey && !ConfigKey.HasConfigKey.class.isAssignableFrom(f.getType())) continue;
            if (!Modifier.isStatic(f.getModifiers())) {
                LOG.warn("Discouraged use of non-static config key " + f + " defined in " + (optionalInstance != null ? optionalInstance : clazz));
                if (optionalInstance == null) continue;
            }
            try {
                Object v = f.get(optionalInstance);
                if (v == null) {
                    LOG.warn("no value defined for config key field (skipping): " + f);
                    continue;
                }
                ConfigKey k = isConfigKey ? (ConfigKey)v : ((ConfigKey.HasConfigKey)v).getConfigKey();
                configKeysAll.put((Object)k.getName(), new FieldAndValue<ConfigKey>(f, k));
            }
            catch (IllegalAccessException e) {
                LOG.warn("cannot access config key (skipping): " + f);
            }
        }
        MutableSet interfaces = MutableSet.copyOf(Arrays.asList(clazz.getInterfaces()));
        LinkedHashSet keys = new LinkedHashSet(configKeysAll.keys());
        for (String kn : keys) {
            ArrayList kk = Lists.newArrayList((Iterable)configKeysAll.get((Object)kn));
            for (FieldAndValue k : kk) {
                ConfigKey key = (ConfigKey)BrooklynDynamicType.value(k);
                if (!(ConfigInheritances.isKeyReinheritable((ConfigKey)key, (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.TYPE_DEFINITION) || k.field.getDeclaringClass().equals(clazz) || interfaces.contains(k.field.getDeclaringClass()))) {
                    configKeysAll.remove((Object)((ConfigKey)k.value).getName(), (Object)k);
                }
                if (!(key instanceof BasicConfigKey.BasicConfigKeyOverwriting)) continue;
                ConfigKey parent = ((BasicConfigKey.BasicConfigKeyOverwriting)key).getParentKey();
                for (FieldAndValue k2 : kk) {
                    if (BrooklynDynamicType.value(k2) != parent) continue;
                    configKeysAll.remove((Object)kn, (Object)k2);
                }
            }
            kk = Lists.newArrayList((Iterable)configKeysAll.get((Object)kn));
            FieldAndValue<Object> best = null;
            for (FieldAndValue<ConfigKey> k : kk) {
                ConfigKey lowerV;
                if (best == null) {
                    best = k;
                    continue;
                }
                Field lower = Reflections.inferSubbestField((Field)k.field, (Field)best.field);
                ConfigKey configKey = lower == null ? null : (lowerV = lower.equals(k.field) ? (ConfigKey)k.value : (ConfigKey)best.value);
                if (best.value == k.value) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("multiple definitions for config key {} on {}; same value {}; from {} and {}, preferring {}", new Object[]{((ConfigKey)best.value).getName(), optionalInstance != null ? optionalInstance : clazz, ((ConfigKey)best.value).getDefaultValue(), k.field, best.field, lower});
                    }
                    best = new FieldAndValue(lower != null ? lower : best.field, best.value);
                    continue;
                }
                if (lower != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("multiple definitions for config key {} on {}; from {} and {}, preferring lower {}, value {}", new Object[]{((ConfigKey)best.value).getName(), optionalInstance != null ? optionalInstance : clazz, k.field, best.field, lower, lowerV.getDefaultValue()});
                    }
                    best = new FieldAndValue<ConfigKey>(lower, lowerV);
                    continue;
                }
                LOG.warn("multiple ambiguous definitions for config key {} on {}; from {} and {}, values {} and {}; keeping latter (arbitrarily)", new Object[]{((ConfigKey)best.value).getName(), optionalInstance != null ? optionalInstance : clazz, k.field, best.field, ((ConfigKey)k.value).getDefaultValue(), ((ConfigKey)best.value).getDefaultValue()});
            }
            if (best == null) continue;
            configKeys.put(((ConfigKey)best.value).getName(), best);
        }
    }

    protected static <V> V value(FieldAndValue<V> fv) {
        if (fv == null) {
            return null;
        }
        return fv.value;
    }

    protected static Field field(FieldAndValue<?> fv) {
        if (fv == null) {
            return null;
        }
        return fv.field;
    }

    protected static <V> Collection<V> value(Collection<FieldAndValue<V>> fvs) {
        ArrayList<V> result = new ArrayList<V>();
        for (FieldAndValue<V> fv : fvs) {
            result.add(BrooklynDynamicType.value(fv));
        }
        return result;
    }

    protected static <K, V> Map<K, V> value(Map<K, FieldAndValue<V>> fvs) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (K key : fvs.keySet()) {
            result.put(key, BrooklynDynamicType.value(fvs.get(key)));
        }
        return result;
    }

    protected static <T> T withLock(Lock lock, Supplier<T> call) {
        try {
            lock.lock();
            T t = call.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    protected static class FieldAndValue<V> {
        public final Field field;
        public final V value;

        public FieldAndValue(Field field, V value) {
            this.field = field;
            this.value = value;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).add("value", this.value).toString();
        }
    }
}

