/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import org.apache.brooklyn.util.collections.MutableList;

public class MutableListConverter
extends CollectionConverter {
    final SerializableConverter serializableConverterTweakedForDeserializing;

    public MutableListConverter(Mapper mapper, ReflectionProvider reflectionProvider, ClassLoaderReference classLoaderReference) {
        super(mapper);
        this.serializableConverterTweakedForDeserializing = new SerializableConverter((Mapper)new MapperWrapper(mapper){

            public String aliasForSystemAttribute(String attribute) {
                if ("serialization".equals(attribute)) {
                    return null;
                }
                return super.aliasForSystemAttribute(attribute);
            }
        }, reflectionProvider, classLoaderReference);
    }

    public boolean canConvert(Class type) {
        return MutableList.class.isAssignableFrom(type);
    }

    protected Object createCollection(Class type) {
        return new MutableList();
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        super.marshal((Object)MutableList.copyOf((Iterable)((MutableList)source)), writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        boolean legacy = "unserializable-parents".equals(((ExtendedHierarchicalStreamReader)reader).peekNextChild());
        if (legacy) {
            return this.serializableConverterTweakedForDeserializing.unmarshal(reader, context);
        }
        return super.unmarshal(reader, context);
    }
}

