/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.apache.brooklyn.rest.domain.ApplicationSpec;
import org.apache.brooklyn.rest.domain.HasId;
import org.apache.brooklyn.rest.domain.Status;

public class ApplicationSummary
implements HasId,
Serializable {
    private static final long serialVersionUID = -247411021540729088L;
    private static final Map<Status, Status> validTransitions = ImmutableMap.builder().put((Object)Status.UNKNOWN, (Object)Status.ACCEPTED).put((Object)Status.ACCEPTED, (Object)Status.STARTING).put((Object)Status.STARTING, (Object)Status.RUNNING).put((Object)Status.RUNNING, (Object)Status.STOPPING).put((Object)Status.STOPPING, (Object)Status.STOPPED).put((Object)Status.STOPPED, (Object)Status.STARTING).build();
    private final String id;
    private final ApplicationSpec spec;
    private final Status status;
    private final Map<String, URI> links;

    public ApplicationSummary(@JsonProperty(value="id") String id, @JsonProperty(value="spec") ApplicationSpec spec, @JsonProperty(value="status") Status status, @JsonProperty(value="links") Map<String, URI> links) {
        this.id = id;
        this.spec = (ApplicationSpec)Preconditions.checkNotNull((Object)spec, (Object)"spec");
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ApplicationSpec getSpec() {
        return this.spec;
    }

    public Status getStatus() {
        return this.status;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public ApplicationSummary transitionTo(Status newStatus) {
        if (newStatus == Status.ERROR || validTransitions.get((Object)this.status) == newStatus) {
            return new ApplicationSummary(this.id, this.spec, newStatus, this.links);
        }
        throw new IllegalStateException("Invalid transition from '" + (Object)((Object)this.status) + "' to '" + (Object)((Object)newStatus) + "'");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary that = (ApplicationSummary)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.spec, that.spec) && this.status == that.status && Objects.equals(this.links, that.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.spec, this.status, this.links});
    }

    public String toString() {
        return "ApplicationSummary{id='" + this.id + '\'' + ", spec=" + this.spec + ", status=" + (Object)((Object)this.status) + ", links=" + this.links + '}';
    }
}

