/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.rest.filter.HaHotCheckHelperAbstract;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.lang3.tuple.Pair;

@Provider
@Priority(value=300)
public class HaHotCheckResourceFilter
implements ContainerRequestFilter {
    private static final Set<String> SAFE_STANDBY_METHODS = ImmutableSet.of((Object)"GET", (Object)"HEAD");
    public static final String SKIP_CHECK_HEADER = "Brooklyn-Allow-Non-Master-Access";
    @Context
    private ContextResolver<ManagementContext> mgmt;
    @Context
    private ResourceInfo resourceInfo;
    private HaHotCheckHelperAbstract helper = new HaHotCheckHelperAbstract(){

        @Override
        public ManagementContext mgmt() {
            return (ManagementContext)HaHotCheckResourceFilter.this.mgmt.getContext(ManagementContext.class);
        }
    };

    public HaHotCheckResourceFilter() {
    }

    @VisibleForTesting
    public HaHotCheckResourceFilter(ContextResolver<ManagementContext> mgmt) {
        this.mgmt = mgmt;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Pair<String, Boolean> problemAndMaster = this.lookForProblem(requestContext);
        if (problemAndMaster != null && Strings.isNonBlank((CharSequence)((CharSequence)problemAndMaster.getLeft()))) {
            requestContext.abortWith(this.helper.disallowResponse((String)problemAndMaster.getLeft(), requestContext.getUriInfo().getAbsolutePath() + " (" + this.resourceInfo.getResourceMethod() + ")", (Boolean)problemAndMaster.getRight()));
        }
    }

    private Pair<String, Boolean> lookForProblem(ContainerRequestContext requestContext) {
        if (this.helper.isSkipCheckHeaderSet(requestContext.getHeaderString(SKIP_CHECK_HEADER))) {
            return null;
        }
        if (this.isMasterRequiredForRequest(requestContext) && !this.isMaster()) {
            return Pair.of((Object)"server not in required HA primary state", (Object)true);
        }
        if (!this.isHaHotStateRequired()) {
            return null;
        }
        Maybe<String> problem = this.helper.getProblemMessageIfServerNotRunning();
        if (problem.isPresent()) {
            return Pair.of((Object)problem.get(), (Object)false);
        }
        if (!this.helper.isHaHotStatus()) {
            return Pair.of((Object)"server not in required HA hot state", (Object)false);
        }
        if (this.helper.isStateNotYetValid()) {
            return Pair.of((Object)"server not yet completed loading data for required HA hot state", (Object)false);
        }
        return null;
    }

    private boolean isMaster() {
        return ManagementNodeState.MASTER.equals((Object)((ManagementContext)this.mgmt.getContext(ManagementContext.class)).getHighAvailabilityManager().getNodeState());
    }

    private boolean isMasterRequiredForRequest(ContainerRequestContext requestContext) {
        if (SAFE_STANDBY_METHODS.contains(requestContext.getMethod())) {
            return false;
        }
        return !this.isCallAllowedInAnyState(requestContext.getUriInfo().getPath());
    }

    protected boolean isCallAllowedInAnyState(String uri) {
        if (uri != null) {
            if ((uri = Strings.removeAllFromStart((String)uri, (String[])new String[]{"/", "v1/"})).startsWith("logout")) {
                return true;
            }
            if ("server/shutdown".equals(uri)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isHaHotStateRequired() {
        Method m = this.resourceInfo.getResourceMethod();
        return this.getAnnotation(m, HaHotStateRequired.class) != null;
    }

    private <T extends Annotation> T getAnnotation(Method m, Class<T> annotation) {
        T am = m.getAnnotation(annotation);
        if (am != null) {
            return am;
        }
        Class<?> superClass = m.getDeclaringClass();
        T ac = superClass.getAnnotation(annotation);
        if (ac != null) {
            return ac;
        }
        return null;
    }
}

