/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.binders;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.Binder;

@Singleton
public class TagToJson
implements Binder {
    private final Json json;

    @Inject
    public TagToJson(Json json) {
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof Set));
        Set tags = (Set)Set.class.cast(Preconditions.checkNotNull((Object)input, (Object)"input"));
        request.setPayload(this.buildJson(tags));
        return request;
    }

    String buildJson(Set<String> tags) {
        return this.json.toJson((Object)ImmutableMap.of((Object)"parameters", (Object)ImmutableSet.of((Object)Joiner.on((String)",").join(tags))));
    }
}

