/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import org.apache.commons.validator.routines.ISINValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ISINValidatorTest {
    private static final ISINValidator VALIDATOR_TRUE = ISINValidator.getInstance((boolean)true);
    private static final ISINValidator VALIDATOR_FALSE = ISINValidator.getInstance((boolean)false);
    private final String[] validFormat = new String[]{"US0378331005", "BMG8571G1096", "AU0000XVGZA3", "GB0002634946", "FR0004026250", "DK0009763344", "GB00B03MLX29", "US7562071065", "US56845T3059", "LU0327357389", "US032511BN64", "INE112A01023", "EZ0000000003", "EU000A0VUCF1", "XA2053913989", "XB0000000008", "XC0009698371", "XD0000000006", "XF0000000004", "QS0000000008", "QT0000000007", "QW0000000002", "XS0000000009", "EU0009652783", "XAC8614YAB92", "XC0001458477", "XD0209061296", "AN8068571086"};
    private final String[] invalidFormat = new String[]{null, "", "   ", "US037833100O", "BMG8571G109D", "AU0000XVGZAD", "GB000263494I", "FR000402625C", "DK000976334H", "3133EHHF3", "AU0000xvgzA3", "gb0002634946"};
    private final String[] invalidFormatTrue = new String[]{"AB0000000006"};

    ISINValidatorTest() {
    }

    @Test
    void testInvalidFalse() {
        for (String f : this.invalidFormat) {
            Assertions.assertFalse((boolean)VALIDATOR_FALSE.isValid(f), (String)f);
        }
    }

    @Test
    void testInvalidTrue() {
        for (String f : this.invalidFormat) {
            Assertions.assertFalse((boolean)VALIDATOR_TRUE.isValid(f), (String)f);
        }
        for (String f : this.invalidFormatTrue) {
            Assertions.assertFalse((boolean)VALIDATOR_TRUE.isValid(f), (String)f);
        }
    }

    @Test
    void testIsValidFalse() {
        for (String f : this.validFormat) {
            Assertions.assertTrue((boolean)VALIDATOR_FALSE.isValid(f), (String)f);
        }
    }

    @Test
    void testIsValidTrue() {
        for (String f : this.validFormat) {
            Assertions.assertTrue((boolean)VALIDATOR_TRUE.isValid(f), (String)f);
        }
    }
}

