/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient;

import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.x509.TrustedNamesCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientSecuritySupport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientSecuritySupport.class);

    private HttpClientSecuritySupport() {
    }

    public static HttpClientSecurityConfiguration getGlobalHttpClientSecurityConfiguration() {
        return (HttpClientSecurityConfiguration)ConfigurationService.get(HttpClientSecurityConfiguration.class);
    }

    public static void addDefaultTLSTrustEngineCriteria(@Nonnull HttpClientContext context, @Nonnull HttpUriRequest request) {
        if ("https".equalsIgnoreCase(request.getURI().getScheme()) && context.getAttribute("opensaml.TrustEngine") != null) {
            CriteriaSet criteria = (CriteriaSet)context.getAttribute("opensaml.CriteriaSet");
            if (criteria == null) {
                criteria = new CriteriaSet();
                context.setAttribute("opensaml.CriteriaSet", (Object)criteria);
            }
            if (!criteria.contains(UsageCriterion.class)) {
                criteria.add((Object)new UsageCriterion(UsageType.SIGNING));
            }
            if (!criteria.contains(TrustedNamesCriterion.class)) {
                criteria.add((Object)new TrustedNamesCriterion(Collections.singleton(request.getURI().getHost())));
            }
        }
    }

    public static void checkTLSCredentialEvaluated(@Nonnull HttpClientContext context, @Nonnull String scheme) throws SSLPeerUnverifiedException {
        if (context.getAttribute("opensaml.TrustEngine") != null && "https".equalsIgnoreCase(scheme) && context.getAttribute("opensaml.ServerTLSCredentialTrusted") == null) {
            LOG.warn("Configured TLS trust engine was not used to verify server TLS credential, the appropriate socket factory was likely not configured");
            throw new SSLPeerUnverifiedException("Evaluation of server TLS credential with configured TrustEngine was not performed");
        }
    }

    public static void marshalSecurityParameters(@Nonnull HttpClientContext context, @Nullable HttpClientSecurityParameters securityParameters) {
        HttpClientSecuritySupport.marshalSecurityParameters(context, securityParameters, false);
    }

    public static void marshalSecurityParameters(@Nonnull HttpClientContext context, @Nullable HttpClientSecurityParameters securityParameters, boolean replace) {
        if (securityParameters == null) {
            return;
        }
        Constraint.isNotNull((Object)context, (String)"HttpClientContext was null");
        if (securityParameters.getCredentialsProvider() != null && (replace || context.getCredentialsProvider() == null)) {
            context.setCredentialsProvider(securityParameters.getCredentialsProvider());
        }
        if (securityParameters.getAuthCache() != null && (replace || context.getAuthCache() == null)) {
            context.setAuthCache(securityParameters.getAuthCache());
        }
        HttpClientSecuritySupport.setContextValue(context, "opensaml.TrustEngine", securityParameters.getTLSTrustEngine(), replace);
        HttpClientSecuritySupport.setContextValue(context, "opensaml.CriteriaSet", securityParameters.getTLSCriteriaSet(), replace);
        HttpClientSecuritySupport.setContextValue(context, "javasupport.TLSProtocols", securityParameters.getTLSProtocols(), replace);
        HttpClientSecuritySupport.setContextValue(context, "javasupport.TLSCipherSuites", securityParameters.getTLSCipherSuites(), replace);
        HttpClientSecuritySupport.setContextValue(context, "javasupport.HostnameVerifier", securityParameters.getHostnameVerifier(), replace);
        HttpClientSecuritySupport.setContextValue(context, "opensaml.ClientTLSCredential", securityParameters.getClientTLSCredential(), replace);
        HttpClientSecuritySupport.setContextValue(context, "opensaml.ServerTLSFailureIsFatal", securityParameters.isServerTLSFailureFatal(), replace);
    }

    public static void setContextValue(@Nonnull HttpClientContext context, @Nonnull String attributeName, @Nullable Object attributeValue, boolean replace) {
        if (attributeValue == null) {
            return;
        }
        Constraint.isNotNull((Object)context, (String)"HttpClientContext was null");
        Constraint.isNotNull((Object)attributeName, (String)"Context attribute name was null");
        if (replace || context.getAttribute(attributeName) == null) {
            context.setAttribute(attributeName, attributeValue);
        }
    }
}

