/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStream;

public class RewindableInputStream
extends FilterInputStream {
    private static final Logger LOG = LogUtils.getL7dLogger(RewindableInputStream.class);
    private static final long MEMORY_SIZE_LIMIT = 65536L;
    private static final int COPY_BLOCK_SIZE = 16384;
    private final CachedOutputStream cachedStream;

    public RewindableInputStream(InputStream is) {
        super(is);
        this.mark(0);
        this.cachedStream = null;
    }

    private RewindableInputStream(CachedOutputStream os) throws IOException {
        super(os.getInputStream());
        this.cachedStream = os;
    }

    public static RewindableInputStream makeRewindable(InputStream is) throws IOException {
        if (is.markSupported()) {
            return new RewindableInputStream(is);
        }
        CachedOutputStream os = new CachedOutputStream(65536L);
        CachedOutputStream.copyStream((InputStream)is, (OutputStream)os, (int)16384);
        return new RewindableInputStream(os);
    }

    public void rewind() {
        try {
            this.reset();
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Error resetting stream", e);
        }
        this.mark(0);
    }

    public void release() {
        if (this.cachedStream != null) {
            this.cachedStream.releaseTempFileHold();
        }
    }
}

