/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.apache.cxf.binding.corba.types.AbstractStartEndEventProducer;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaObjectReferenceHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeEventProducer;
import org.apache.cxf.binding.corba.utils.CorbaObjectReferenceHelper;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.apache.cxf.binding.corba.utils.EprMetaData;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.omg.CORBA.ORB;

public final class CorbaObjectReferenceEventProducer
extends AbstractStartEndEventProducer {
    static final String WSDLI_NAMESPACE_URI = "http://www.w3.org/2006/01/wsdl-instance";
    static final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    static final QName WSA_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address");
    static final List<Attribute> IS_NIL_OBJ_REF_ATTRS;
    private static final String INFER_FROM_TYPE_ID = "InferFromTypeId";
    private static final Logger LOG;
    List<Attribute> refAttrs;

    public CorbaObjectReferenceEventProducer(CorbaObjectHandler h, ServiceInfo service, ORB orbRef) {
        CorbaObjectReferenceHandler handler = (CorbaObjectReferenceHandler)h;
        this.name = CorbaUtils.processQName(handler.getName(), service);
        this.orb = orbRef;
        this.serviceInfo = service;
        this.refAttrs = null;
        if (handler.getReference() == null) {
            this.refAttrs = IS_NIL_OBJ_REF_ATTRS;
            return;
        }
        ArrayList<CorbaTypeEventProducer> objRefProducers = new ArrayList<CorbaTypeEventProducer>();
        String address = this.orb.object_to_string(handler.getReference());
        objRefProducers.add(new CorbaAddressEventProducer(address));
        Definition wsdlDef = (Definition)this.serviceInfo.getProperty(WSDLServiceBuilder.WSDL_DEFINITION);
        org.apache.cxf.binding.corba.wsdl.Object objType = (org.apache.cxf.binding.corba.wsdl.Object)handler.getType();
        QName bindingName = objType.getBinding();
        if (bindingName != null) {
            EprMetaData eprInfo = null;
            if (INFER_FROM_TYPE_ID.equalsIgnoreCase(bindingName.getLocalPart())) {
                String typeId = CorbaObjectReferenceHelper.extractTypeIdFromIOR(address);
                if (!StringUtils.isEmpty((String)typeId)) {
                    eprInfo = this.getEprMetadataForTypeId(wsdlDef, typeId);
                } else {
                    LOG.log(Level.SEVERE, "For binding with value \"InferFromTypeId\" the type_id of the object reference IOR must be set to its most derived type. It is currently null indicating CORBA:Object. Address Url=" + address);
                }
            } else {
                eprInfo = this.getEprMetadataForBindingName(wsdlDef, bindingName);
            }
            if (eprInfo.isValid()) {
                LOG.log(Level.FINE, "Epr metadata " + String.valueOf(eprInfo));
                String wsdlLoc = CorbaObjectReferenceHelper.getWSDLLocation(eprInfo.getCandidateWsdlDef());
                CorbaServiceNameEventProducer nameProducer = new CorbaServiceNameEventProducer(eprInfo.getServiceQName(), eprInfo.getPortName());
                QName interfaceName = eprInfo.getBinding().getPortType().getQName();
                CorbaInterfaceNameEventProducer interfaceProducer = new CorbaInterfaceNameEventProducer(interfaceName);
                CorbaMetaDataEventProducer metaProducer = new CorbaMetaDataEventProducer(wsdlLoc, nameProducer, interfaceProducer);
                objRefProducers.add(metaProducer);
            }
        }
        this.producers = objRefProducers.iterator();
    }

    private EprMetaData getEprMetadataForBindingName(Definition wsdlDef, QName bindingName) {
        EprMetaData info = this.getObjectReferenceBinding(wsdlDef, bindingName);
        CorbaObjectReferenceHelper.populateEprInfo(info);
        return info;
    }

    private EprMetaData getEprMetadataForTypeId(Definition wsdlDef, String typeId) {
        EprMetaData info = CorbaObjectReferenceHelper.getBindingForTypeId(typeId, wsdlDef);
        CorbaObjectReferenceHelper.populateEprInfo(info);
        return info;
    }

    @Override
    public List<Attribute> getAttributes() {
        if (this.currentEventProducer != null) {
            return this.currentEventProducer.getAttributes();
        }
        return this.refAttrs;
    }

    protected EprMetaData getObjectReferenceBinding(Definition wsdlDef, QName bindingName) {
        EprMetaData info = new EprMetaData();
        Binding wsdlBinding = wsdlDef.getBinding(bindingName);
        if (wsdlBinding == null && bindingName.getNamespaceURI().isEmpty() && !bindingName.getLocalPart().isEmpty()) {
            Collection bindingsCollection = CastUtils.cast(wsdlDef.getBindings().values());
            for (Binding b : bindingsCollection) {
                if (!b.getQName().getLocalPart().equals(bindingName.getLocalPart())) continue;
                wsdlBinding = b;
                break;
            }
        }
        if (wsdlBinding != null) {
            info.setBinding(wsdlBinding);
            info.setCandidateWsdlDef(wsdlDef);
        }
        return info;
    }

    static {
        XMLEventFactory factory = XMLEventFactory.newInstance();
        IS_NIL_OBJ_REF_ATTRS = new ArrayList<Attribute>();
        IS_NIL_OBJ_REF_ATTRS.add(factory.createAttribute(new QName(XSI_NAMESPACE_URI, "nil", "xsi"), "true"));
        LOG = LogUtils.getL7dLogger(CorbaObjectReferenceEventProducer.class);
    }

    class CorbaInterfaceNameEventProducer
    implements CorbaTypeEventProducer {
        int state;
        int[] states = new int[]{1, 4, 2};
        QName interfaceName;
        QName name;
        List<Namespace> namespaces;

        CorbaInterfaceNameEventProducer(QName intf) {
            this.interfaceName = intf;
            this.name = new QName("http://www.w3.org/2006/05/addressing/wsdl", "InterfaceName");
            XMLEventFactory factory = XMLEventFactory.newInstance();
            this.namespaces = new ArrayList<Namespace>();
            this.namespaces.add(factory.createNamespace("objrefns2", intf.getNamespaceURI()));
        }

        @Override
        public String getLocalName() {
            return this.name.getLocalPart();
        }

        @Override
        public String getText() {
            return this.namespaces.get(0).getPrefix() + ":" + this.interfaceName.getLocalPart();
        }

        @Override
        public int next() {
            return this.states[this.state++];
        }

        @Override
        public boolean hasNext() {
            return this.state < this.states.length;
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public List<Attribute> getAttributes() {
            return null;
        }

        @Override
        public List<Namespace> getNamespaces() {
            return this.namespaces;
        }
    }

    class CorbaServiceNameEventProducer
    implements CorbaTypeEventProducer {
        int state;
        int[] states = new int[]{1, 4, 2};
        QName serviceName;
        QName name;
        List<Attribute> attributes;
        List<Namespace> namespaces;

        CorbaServiceNameEventProducer(QName svc, String ep) {
            this.serviceName = svc;
            this.name = new QName("http://www.w3.org/2006/05/addressing/wsdl", "ServiceName");
            XMLEventFactory factory = XMLEventFactory.newInstance();
            this.attributes = new ArrayList<Attribute>();
            this.attributes.add(factory.createAttribute("EndpointName", ep));
            this.namespaces = new ArrayList<Namespace>();
            this.namespaces.add(factory.createNamespace("objrefns2", svc.getNamespaceURI()));
        }

        @Override
        public String getLocalName() {
            return this.name.getLocalPart();
        }

        @Override
        public String getText() {
            return this.namespaces.get(0).getPrefix() + ":" + this.serviceName.getLocalPart();
        }

        @Override
        public int next() {
            return this.states[this.state++];
        }

        @Override
        public boolean hasNext() {
            return this.state < this.states.length;
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public List<Namespace> getNamespaces() {
            return this.namespaces;
        }
    }

    class CorbaMetaDataEventProducer
    extends AbstractStartEndEventProducer {
        CorbaServiceNameEventProducer svcProducer;
        CorbaInterfaceNameEventProducer intfProducer;
        List<Attribute> metaAttrs;

        CorbaMetaDataEventProducer(CorbaServiceNameEventProducer svc) {
            this(null, svc, null);
        }

        CorbaMetaDataEventProducer(String location, CorbaServiceNameEventProducer svc, CorbaInterfaceNameEventProducer intf) {
            this.name = new QName("http://www.w3.org/2005/08/addressing", "Metadata");
            ArrayList<CorbaTypeEventProducer> metaDataProducers = new ArrayList<CorbaTypeEventProducer>();
            metaDataProducers.add(svc);
            if (intf != null) {
                metaDataProducers.add(intf);
            }
            this.producers = metaDataProducers.iterator();
            if (location != null) {
                XMLEventFactory factory = XMLEventFactory.newInstance();
                this.metaAttrs = new ArrayList<Attribute>();
                this.metaAttrs.add(factory.createAttribute(new QName(CorbaObjectReferenceEventProducer.WSDLI_NAMESPACE_URI, "wsdlLocation", "objrefns1"), location));
            }
        }

        @Override
        public List<Attribute> getAttributes() {
            if (this.currentEventProducer != null) {
                return this.currentEventProducer.getAttributes();
            }
            return this.metaAttrs;
        }
    }

    class CorbaAddressEventProducer
    implements CorbaTypeEventProducer {
        int state;
        int[] states = new int[]{1, 4, 2};
        final String address;

        CorbaAddressEventProducer(String value) {
            this.address = value;
        }

        @Override
        public String getLocalName() {
            return WSA_ADDRESS.getLocalPart();
        }

        @Override
        public String getText() {
            return this.address;
        }

        @Override
        public int next() {
            return this.states[this.state++];
        }

        @Override
        public QName getName() {
            return WSA_ADDRESS;
        }

        @Override
        public boolean hasNext() {
            return this.state < this.states.length;
        }

        @Override
        public List<Attribute> getAttributes() {
            return null;
        }

        @Override
        public List<Namespace> getNamespaces() {
            return null;
        }
    }
}

