/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class AbstractJwsWriterProvider {
    private JwsSignatureProvider sigProvider;

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.sigProvider = signatureProvider;
    }

    protected JwsSignatureProvider getInitializedSigProvider(JwsHeaders headers) {
        this.setRequestContextProperty((JoseHeaders)headers);
        if (this.sigProvider != null) {
            return this.sigProvider;
        }
        return JwsUtils.loadSignatureProvider((JwsHeaders)headers, (boolean)true);
    }

    protected void setRequestContextProperty(JoseHeaders headers) {
        JoseUtils.setJoseContextProperty((JoseHeaders)headers);
    }

    protected void writeJws(JwsCompactProducer p, JwsSignatureProvider theSigProvider, OutputStream os) throws IOException {
        p.signWith(theSigProvider);
        JoseUtils.traceHeaders((JoseHeaders)p.getJwsHeaders());
        byte[] bytes = StringUtils.toBytesUTF8((String)p.getSignedEncodedJws());
        IOUtils.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)os);
    }
}

