/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption.keys.content.derivedKey;

import java.util.StringJoiner;
import org.apache.xml.security.encryption.KeyDerivationMethod;
import org.apache.xml.security.encryption.keys.content.derivedKey.ConcatKDFParamsImpl;
import org.apache.xml.security.encryption.keys.content.derivedKey.HKDFParamsImpl;
import org.apache.xml.security.encryption.keys.content.derivedKey.KDFParams;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.Encryption11ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyDerivationMethodImpl
extends Encryption11ElementProxy
implements KeyDerivationMethod {
    protected static final System.Logger LOG = System.getLogger(KeyDerivationMethodImpl.class.getName());
    private KDFParams kdfParams;

    public KeyDerivationMethodImpl(Document doc) {
        super(doc);
    }

    public KeyDerivationMethodImpl(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
    }

    public void setAlgorithm(String algorithm) {
        if (algorithm != null) {
            this.setLocalIdAttribute("Algorithm", algorithm);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.getLocalAttribute("Algorithm");
    }

    @Override
    public KDFParams getKDFParams() throws XMLSecurityException {
        if (this.kdfParams != null) {
            LOG.log(System.Logger.Level.DEBUG, "Returning cached KDFParams");
            return this.kdfParams;
        }
        String kdfAlgorithm = this.getAlgorithm();
        if ("http://www.w3.org/2009/xmlenc11#ConcatKDF".equals(kdfAlgorithm)) {
            Element concatKDFParamsElement = XMLUtils.selectXenc11Node(this.getElement().getFirstChild(), "ConcatKDFParams", 0);
            this.kdfParams = new ConcatKDFParamsImpl(concatKDFParamsElement, this.getBaseURI());
        } else if ("http://www.w3.org/2021/04/xmldsig-more#hkdf".equals(kdfAlgorithm)) {
            Element hkdfParamsElement = XMLUtils.selectNode(this.getElement().getFirstChild(), "http://www.w3.org/2021/04/xmldsig-more#", "HKDFParams", 0);
            this.kdfParams = new HKDFParamsImpl(hkdfParamsElement, "http://www.w3.org/2007/05/xmldsig-more#");
        } else {
            throw new XMLSecurityException("KeyDerivation.NotSupportedParameter", new Object[]{kdfAlgorithm});
        }
        return this.kdfParams;
    }

    public void setKDFParams(KDFParams kdfParams) {
        this.kdfParams = kdfParams;
        if (kdfParams instanceof ElementProxy) {
            this.appendSelf((ElementProxy)((Object)kdfParams));
            this.addReturnToSelf();
        } else {
            LOG.log(System.Logger.Level.DEBUG, "Could not append KDFParams because it does not implement ElementProxy");
        }
    }

    @Override
    public String getBaseLocalName() {
        return "KeyDerivationMethod";
    }

    public String toString() {
        return new StringJoiner(", ", KeyDerivationMethodImpl.class.getSimpleName() + "[", "]").add("kdfParams=" + this.kdfParams).toString();
    }
}

