/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieSameSiteMode;
import io.undertow.util.DateUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class CookieImpl
implements Cookie {
    private static final Integer DEFAULT_MAX_AGE = -1;
    private static final boolean DEFAULT_HTTP_ONLY = false;
    private static final boolean DEFAULT_SECURE = false;
    private static final boolean DEFAULT_DISCARD = false;
    private final String name;
    private String value;
    private String path;
    private String domain;
    private Integer maxAge = DEFAULT_MAX_AGE;
    private Date expires;
    private boolean discard;
    private boolean secure = false;
    private boolean httpOnly = false;
    private int version = 0;
    private String comment;
    private String sameSiteMode;
    private final Map<String, String> attributes;

    public CookieImpl(String name, String value) {
        this(name, value, null);
    }

    public CookieImpl(String name) {
        this(name, null);
    }

    public CookieImpl(String name, String value, Cookie cookiePrimer) {
        this.name = name;
        this.value = value;
        this.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (cookiePrimer != null) {
            for (Map.Entry<String, String> primers : cookiePrimer.getAttributes().entrySet()) {
                this.setAttribute(primers.getKey(), primers.getValue());
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public CookieImpl setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public CookieImpl setPath(String path) {
        this.path = path;
        this.setAttribute("Path", path, path == null);
        return this;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public CookieImpl setDomain(String domain) {
        this.domain = domain;
        this.setAttribute("Domain", domain, domain == null);
        return this;
    }

    @Override
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @Override
    public CookieImpl setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        this.setAttribute("Max-Age", String.valueOf(maxAge), maxAge == null);
        return this;
    }

    @Override
    public boolean isDiscard() {
        return this.discard;
    }

    @Override
    public CookieImpl setDiscard(boolean discard) {
        this.discard = discard;
        this.setAttribute("Discard", String.valueOf(discard), false);
        return this;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public CookieImpl setSecure(boolean secure) {
        this.secure = secure;
        this.setAttribute("Secure", String.valueOf(secure), false);
        return this;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public CookieImpl setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public CookieImpl setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        this.setAttribute("HttpOnly", String.valueOf(httpOnly), false);
        return this;
    }

    @Override
    public Date getExpires() {
        return this.expires;
    }

    @Override
    public CookieImpl setExpires(Date expires) {
        this.expires = expires;
        if (expires != null) {
            this.setAttribute("Expires", DateUtils.toDateString(expires), false);
        } else {
            this.setAttribute("Expires", null, false);
        }
        return this;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Cookie setComment(String comment) {
        this.setAttribute("Comment", comment, false);
        this.comment = comment;
        return this;
    }

    @Override
    public boolean isSameSite() {
        return this.sameSiteMode != null;
    }

    @Override
    public Cookie setSameSite(boolean sameSite) {
        return this;
    }

    @Override
    public String getSameSiteMode() {
        return this.sameSiteMode;
    }

    @Override
    public Cookie setSameSiteMode(String mode) {
        String m = CookieSameSiteMode.lookupModeString(mode);
        if (m != null) {
            UndertowLogger.REQUEST_LOGGER.tracef("Setting SameSite mode to [%s] for cookie [%s]", m, this.name);
            this.sameSiteMode = m;
            this.setAttribute("SameSite", mode, false);
        } else {
            UndertowLogger.REQUEST_LOGGER.warnf(UndertowMessages.MESSAGES.invalidSameSiteMode(mode, Arrays.toString((Object[])CookieSameSiteMode.values())), "Ignoring specified SameSite mode [%s] for cookie [%s]", mode, this.name);
        }
        return this;
    }

    @Override
    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Cookie setAttribute(String name, String value) {
        return this.setAttribute(name, value, true);
    }

    protected Cookie setAttribute(String name, String value, boolean performSync) {
        if (value != null) {
            if (performSync) {
                switch (name) {
                    case "Comment": {
                        this.comment = value;
                        break;
                    }
                    case "Domain": {
                        this.domain = value;
                        break;
                    }
                    case "HttpOnly": {
                        this.httpOnly = Boolean.parseBoolean(value);
                        break;
                    }
                    case "Max-Age": {
                        this.maxAge = Integer.parseInt(value);
                        break;
                    }
                    case "Path": {
                        this.path = value;
                        break;
                    }
                    case "SameSite": {
                        this.sameSiteMode = CookieSameSiteMode.valueOf(value.toUpperCase()).toString();
                        break;
                    }
                    case "Secure": {
                        this.secure = Boolean.valueOf(value);
                        break;
                    }
                    case "Discard": {
                        this.discard = Boolean.valueOf(value);
                        break;
                    }
                    case "Expires": {
                        this.expires = DateUtils.parseDate(value);
                    }
                }
            }
            this.attributes.put(name, value);
        } else {
            switch (name) {
                case "Comment": {
                    this.comment = null;
                    break;
                }
                case "Domain": {
                    this.domain = null;
                    break;
                }
                case "HttpOnly": {
                    this.httpOnly = false;
                    break;
                }
                case "Max-Age": {
                    this.maxAge = DEFAULT_MAX_AGE;
                    break;
                }
                case "Path": {
                    this.path = null;
                    break;
                }
                case "SameSite": {
                    this.sameSiteMode = null;
                    break;
                }
                case "Secure": {
                    this.secure = false;
                    break;
                }
                case "Discard": {
                    this.discard = false;
                    break;
                }
                case "Expires": {
                    this.expires = null;
                }
            }
            this.attributes.remove(name);
        }
        return this;
    }

    @Override
    public Map<String, String> getAttributes() {
        return Map.copyOf(this.attributes);
    }

    public final int hashCode() {
        int result = 17;
        result = 37 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 37 * result + (this.getPath() == null ? 0 : this.getPath().hashCode());
        result = 37 * result + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        return result;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Cookie)) {
            return false;
        }
        Cookie o = (Cookie)other;
        if (this.getName() == null && o.getName() != null) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(o.getName())) {
            return false;
        }
        if (this.getPath() == null && o.getPath() != null) {
            return false;
        }
        if (this.getPath() != null && !this.getPath().equals(o.getPath())) {
            return false;
        }
        if (this.getDomain() == null && o.getDomain() != null) {
            return false;
        }
        return this.getDomain() == null || this.getDomain().equals(o.getDomain());
    }

    @Override
    public final int compareTo(Object other) {
        return Cookie.super.compareTo(other);
    }

    public final String toString() {
        return "{CookieImpl@" + System.identityHashCode(this) + " name=" + this.getName() + " path=" + this.getPath() + " domain=" + this.getDomain() + "}";
    }
}

