/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.ext.RuntimeDelegate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Duration;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.common.logging.LogUtils;

public class RetryAfterHeaderProvider
implements RuntimeDelegate.HeaderDelegate<Duration> {
    private static final Logger LOG = LogUtils.getL7dLogger(RetryAfterHeaderProvider.class);
    private static final Pattern DELTA_SECONDS_PATTERN = Pattern.compile("^(\\d+)$");
    private static final Pattern RFC_PATTERN = Pattern.compile("^\\s*([^,\\s]+)\\s*[,].+$");
    private final Clock clock;

    public RetryAfterHeaderProvider() {
        this(Clock.systemUTC());
    }

    public RetryAfterHeaderProvider(Clock clock) {
        this.clock = clock;
    }

    public Duration fromString(String value) {
        if (value == null) {
            return Duration.ZERO;
        }
        Matcher matcher = DELTA_SECONDS_PATTERN.matcher(value);
        if (matcher.matches()) {
            return Duration.ofSeconds(Long.parseLong(matcher.group(0)));
        }
        DateFormat formatter = this.tryFormatter(value);
        if (formatter != null) {
            try {
                Date date = formatter.parse(value);
                long retryAfter = date.getTime() - this.clock.millis();
                if (retryAfter > 0L) {
                    return Duration.ofMillis(retryAfter);
                }
            }
            catch (ParseException ex) {
                LOG.fine("The format of '" + value + "' is not recognizable date: " + String.valueOf(ex));
            }
        }
        return Duration.ZERO;
    }

    private DateFormat tryFormatter(String value) {
        Matcher matcher = RFC_PATTERN.matcher(value);
        if (matcher.matches()) {
            String dayOfWeek = matcher.group(1);
            if (dayOfWeek.length() == 3) {
                return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            }
            return new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss z", Locale.US);
        }
        return new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
    }

    public String toString(Duration value) {
        if (value == null) {
            return null;
        }
        return Long.toString(value.getSeconds());
    }

    public static Duration valueOf(String value) {
        return new RetryAfterHeaderProvider().fromString(value);
    }

    public static Duration valueOf(Clock clock, String value) {
        return new RetryAfterHeaderProvider(clock).fromString(value);
    }
}

