/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncDone.SyncDoneValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncDone.SyncDoneValueImpl;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueContainer;
import org.apache.directory.api.ldap.model.message.Control;

public class SyncDoneValueFactory
extends AbstractControlFactory<SyncDoneValue> {
    public SyncDoneValueFactory(LdapApiService codec) {
        super(codec, "1.3.6.1.4.1.4203.1.9.1.3");
    }

    @Override
    public SyncDoneValue newControl() {
        return new SyncDoneValueImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        int pos = buffer.getPos();
        SyncDoneValue syncDoneValue = (SyncDoneValue)control;
        if (syncDoneValue.isRefreshDeletes()) {
            BerValue.encodeBoolean(buffer, true);
        }
        if (syncDoneValue.getCookie() != null) {
            BerValue.encodeOctetString(buffer, syncDoneValue.getCookie());
        }
        BerValue.encodeSequence(buffer, pos);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new SyncDoneValueContainer(control), control, controlBytes);
    }
}

