/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package grails.plugin.formfields.taglib

import grails.plugin.formfields.mock.Person
import grails.testing.web.taglib.TagLibUnitTest
import spock.lang.Issue
import grails.plugin.formfields.*

@Issue('https://github.com/grails/fields/pull/51')
class FieldNamePrefixSpec extends AbstractFormFieldsTagLibSpec implements TagLibUnitTest<FormFieldsTagLib> {

	def mockFormFieldsTemplateService = Mock(FormFieldsTemplateService)

	def setupSpec() {
		mockDomain(Person)
	}

	def setup() {
		mockFormFieldsTemplateService.findTemplate(_, 'wrapper', null, null) >> [path: '/_fields/default/wrapper']
        mockFormFieldsTemplateService.getTemplateFor('wrapper') >> "wrapper"
        mockFormFieldsTemplateService.getTemplateFor('widget') >> "widget"
        mockFormFieldsTemplateService.getTemplateFor('displayWrapper') >> "displayWrapper"
        mockFormFieldsTemplateService.getTemplateFor('displayWidget') >> "displayWidget"
		mockFormFieldsTemplateService.getWidgetPrefix() >> 'input-'
		tagLib.formFieldsTemplateService = mockFormFieldsTemplateService

		mockEmbeddedGrailsLayout(tagLib)
	}

	void 'a prefix can be added to the field names generated by f:field'() {
		given:
		views["/_fields/default/_wrapper.gsp"] = '${widget}'
		views["/_fields/person/name/_widget.gsp"] = '${prefix}${property}'

		and:
		mockFormFieldsTemplateService.findTemplate(_, 'widget', null, null) >> [path: '/_fields/person/name/widget']

		expect:
		applyTemplate('<f:field bean="personInstance" property="name" prefix="foo"/>', [personInstance: personInstance]) == 'foo.name'
	}

	void 'a prefix can be added to the field names generated by f:all'() {
		given:
		views["/_fields/default/_wrapper.gsp"] = '${prefix}${property} '

		expect:
		applyTemplate('<f:all bean="personInstance" prefix="foo"/>', [personInstance: personInstance]).startsWith('foo.salutation foo.name foo.dateOfBirth')
	}

	void 'a prefix is added to any embedded field names by f:all'() {
		given:
		views["/_fields/default/_wrapper.gsp"] = '${prefix}${property} '

		expect:
		applyTemplate('<f:all bean="personInstance" prefix="foo"/>', [personInstance: personInstance]).contains('foo.address.city foo.address.country foo.address.street')
	}

	void 'a prefix can be added to the field names generated by fields rendered inside f:with'() {
		given:
		views["/_fields/default/_wrapper.gsp"] = '${prefix}${property}'

		expect:
		applyTemplate('<f:with bean="personInstance" prefix="foo"><f:field property="name"/></f:with>', [personInstance: personInstance]) == 'foo.name'
	}

	void 'a prefix attribute on f:field overrides one inherited from f:with'() {
		given:
		views["/_fields/default/_wrapper.gsp"] = '${prefix}${property}'

		expect:
		applyTemplate('<f:with bean="personInstance" prefix="foo"><f:field property="name" prefix="bar"/></f:with>', [personInstance: personInstance]) == 'bar.name'
	}

}