/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import grails.util.GrailsStringUtils;
import grails.web.mapping.UrlMappingInfo;
import grails.web.servlet.mvc.GrailsParameterMap;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.util.UriUtils;

public abstract class AbstractUrlMappingInfo
implements UrlMappingInfo {
    private Map<String, Object> params = Collections.emptyMap();

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(final Map newParams) {
        Collection keys = newParams.keySet();
        keys = new ArrayList(keys);
        Collections.sort((List)keys, new Comparator(){

            public int compare(Object leftKey, Object rightKey) {
                Object leftValue = newParams.get(leftKey);
                Object rightValue = newParams.get(rightKey);
                boolean leftIsClosure = leftValue instanceof Closure;
                boolean rightIsClosure = rightValue instanceof Closure;
                if (leftIsClosure && rightIsClosure) {
                    return 0;
                }
                if (leftIsClosure && !rightIsClosure) {
                    return 1;
                }
                if (rightIsClosure && !leftIsClosure) {
                    return -1;
                }
                return 0;
            }
        });
        LinkedHashMap sortedParams = new LinkedHashMap();
        for (Object key : keys) {
            sortedParams.put(String.valueOf(key), newParams.get(key));
        }
        this.params = Collections.unmodifiableMap(sortedParams);
    }

    @Override
    public void configure(GrailsWebRequest webRequest) {
        this.populateParamsForMapping(webRequest);
    }

    protected void populateParamsForMapping(GrailsWebRequest webRequest) {
        String id;
        GrailsParameterMap dispatchParams = webRequest.getParams();
        String encoding = webRequest.getRequest().getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            String name = entry.getKey();
            Object param = entry.getValue();
            if (param instanceof Closure) {
                param = this.evaluateNameForValue(param);
            }
            if (param instanceof CharSequence) {
                param = param.toString();
            }
            dispatchParams.put(name, param);
        }
        String viewName = this.getViewName();
        if (viewName == null && this.getURI() == null) {
            webRequest.setControllerNamespace(this.getNamespace());
            webRequest.setControllerName(this.getControllerName());
            webRequest.setActionName(this.getActionName());
        }
        if (!GrailsStringUtils.isBlank(id = this.getId())) {
            try {
                dispatchParams.put("id", UriUtils.decode(id, encoding));
            }
            catch (IllegalArgumentException e) {
                dispatchParams.put("id", id);
            }
        }
    }

    protected String evaluateNameForValue(Object value) {
        if (value instanceof CharSequence) {
            return value.toString().trim();
        }
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
        return this.evaluateNameForValue(value, webRequest);
    }

    protected String evaluateNameForValue(Object value, GrailsWebRequest webRequest) {
        String name;
        if (value == null) {
            return null;
        }
        if (value instanceof Closure) {
            Closure callable = (Closure)value;
            Closure cloned = (Closure)callable.clone();
            cloned.setDelegate(webRequest);
            cloned.setResolveStrategy(1);
            Object result = cloned.call();
            name = result != null ? result.toString() : null;
        } else if (value instanceof Map) {
            Map httpMethods = (Map)value;
            name = (String)httpMethods.get(webRequest.getCurrentRequest().getMethod());
        } else {
            name = value.toString();
        }
        return name != null ? name.trim() : null;
    }

    @Override
    public Object getRedirectInfo() {
        return null;
    }
}

