/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.TempFile;
import org.apache.tools.ant.taskdefs.XSLTProcess;
import org.apache.tools.ant.taskdefs.optional.junit.XMLResultAggregator;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.w3c.dom.Document;

public class AggregateTransformer {
    public static final String FRAMES = "frames";
    public static final String NOFRAMES = "noframes";
    private static final String JDK_INTERNAL_FACTORY = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private static DocumentBuilderFactory privateDBFactory;
    protected static DocumentBuilderFactory dbfactory;
    protected Task task;
    protected Document document;
    protected File styleDir;
    protected File toDir;
    private XSLTProcess xsltTask;
    private XSLTProcess.Factory xsltFactory;
    private static final FileUtils FILE_UTILS;
    private static volatile int counter;
    protected String format = "frames";

    public AggregateTransformer(Task task) {
        this.task = task;
        this.xsltTask = new XSLTProcess();
        this.xsltTask.bindToOwner(task);
    }

    protected static DocumentBuilderFactory getDocumentBuilderFactory() {
        return privateDBFactory;
    }

    public void setFormat(Format format) {
        this.format = format.getValue();
    }

    public void setXmlDocument(Document doc) {
        this.document = doc;
    }

    protected void setXmlfile(File xmlfile) throws BuildException {
        try {
            DocumentBuilder builder = privateDBFactory.newDocumentBuilder();
            try (InputStream in = Files.newInputStream(xmlfile.toPath(), new OpenOption[0]);){
                Document doc = builder.parse(in);
                this.setXmlDocument(doc);
            }
        }
        catch (Exception e) {
            throw new BuildException("Error while parsing document: " + xmlfile, e);
        }
    }

    public void setStyledir(File styledir) {
        this.styleDir = styledir;
    }

    public void setTodir(File todir) {
        this.toDir = todir;
    }

    public void setExtension(String ext) {
        this.task.log("extension is not used anymore", 1);
    }

    public XSLTProcess.Param createParam() {
        return this.xsltTask.createParam();
    }

    public Path createClasspath() {
        return this.xsltTask.createClasspath();
    }

    public XSLTProcess.Factory createFactory() {
        if (this.xsltFactory == null) {
            this.xsltFactory = this.xsltTask.createFactory();
        }
        return this.xsltFactory;
    }

    public void transform() throws BuildException {
        File outputFile;
        this.checkOptions();
        Project project = this.task.getProject();
        TempFile tempFileTask = new TempFile();
        tempFileTask.bindToOwner(this.task);
        this.xsltTask.setXslResource(this.getStylesheet());
        this.xsltTask.setIn(((XMLResultAggregator)this.task).getDestinationFile());
        if (FRAMES.equals(this.format)) {
            String tempFileProperty = this.getClass().getName() + counter++;
            File tmp = FILE_UTILS.resolveFile(project.getBaseDir(), project.getProperty("java.io.tmpdir"));
            tempFileTask.setDestDir(tmp);
            tempFileTask.setProperty(tempFileProperty);
            tempFileTask.execute();
            outputFile = new File(project.getProperty(tempFileProperty));
        } else {
            outputFile = new File(this.toDir, "junit-noframes.html");
        }
        this.xsltTask.setOut(outputFile);
        XSLTProcess.Param paramx = this.xsltTask.createParam();
        paramx.setProject(this.task.getProject());
        paramx.setName("output.dir");
        paramx.setExpression(this.toDir.getAbsolutePath());
        this.configureForRedirectExtension();
        long t0 = System.currentTimeMillis();
        try {
            this.xsltTask.execute();
        }
        catch (Exception e) {
            throw new BuildException("Errors while applying transformations: " + e.getMessage(), e);
        }
        long dt = System.currentTimeMillis() - t0;
        this.task.log("Transform time: " + dt + "ms");
        if (this.format.equals(FRAMES)) {
            Delete delete = new Delete();
            delete.bindToOwner(this.task);
            delete.setFile(outputFile);
            delete.execute();
        }
    }

    protected Resource getStylesheet() {
        String xslname = this.getXslName();
        if (this.styleDir == null) {
            URL stylesheetURL = this.getClass().getClassLoader().getResource("org/apache/tools/ant/taskdefs/optional/junit/xsl/" + xslname);
            return new URLResource(stylesheetURL);
        }
        return new FileResource(new File(this.styleDir, xslname));
    }

    private String getXslName() {
        String xsltFactoryName = this.xsltFactory == null ? null : this.xsltFactory.getName();
        String suffix = "net.sf.saxon.TransformerFactoryImpl".equals(xsltFactoryName) ? "-saxon.xsl" : ".xsl";
        String xslname = NOFRAMES.equals(this.format) ? "junit-noframes" + suffix : "junit-frames" + suffix;
        return xslname;
    }

    protected void checkOptions() throws BuildException {
        if (this.toDir == null) {
            this.toDir = this.task.getProject().resolveFile(".");
        } else if (!this.toDir.isAbsolute()) {
            this.toDir = this.task.getProject().resolveFile(this.toDir.getPath());
        }
    }

    protected String getStylesheetSystemId() throws IOException {
        String xslname = this.getXslName();
        if (this.styleDir == null) {
            URL url = this.getClass().getResource("xsl/" + xslname);
            if (url == null) {
                throw new FileNotFoundException("Could not find jar resource " + xslname);
            }
            return url.toExternalForm();
        }
        File file = new File(this.styleDir, xslname);
        if (!file.exists()) {
            throw new FileNotFoundException("Could not find file '" + file + "'");
        }
        return JAXPUtils.getSystemId(file);
    }

    protected void configureForRedirectExtension() {
        XSLTProcess.Factory factory = this.createFactory();
        String factoryName = factory.getName();
        if (factoryName == null) {
            try {
                factoryName = TransformerFactory.newInstance().getClass().getName();
            }
            catch (TransformerFactoryConfigurationError exc) {
                throw new BuildException(exc);
            }
        }
        if (JDK_INTERNAL_FACTORY.equals(factoryName) && JavaEnvUtils.isAtLeastJavaVersion("9")) {
            factory.addFeature(new XSLTProcess.Factory.Feature("http://www.oracle.com/xml/jaxp/properties/enableExtensionFunctions", true));
        }
    }

    static {
        dbfactory = privateDBFactory = DocumentBuilderFactory.newInstance();
        FILE_UTILS = FileUtils.getFileUtils();
        counter = 0;
    }

    public static class Format
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{AggregateTransformer.FRAMES, AggregateTransformer.NOFRAMES};
        }
    }
}

