/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm;

import grails.gorm.MultiTenant;
import grails.gorm.multitenancy.Tenants;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.metaclass.MethodSelectionException;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.grails.datastore.gorm.AbstractGormApi;
import org.grails.datastore.gorm.GormInstanceApi;
import org.grails.datastore.gorm.GormStaticApi;
import org.grails.datastore.gorm.GormValidationApi;
import org.grails.datastore.gorm.finders.CountByFinder;
import org.grails.datastore.gorm.finders.FindAllByBooleanFinder;
import org.grails.datastore.gorm.finders.FindAllByFinder;
import org.grails.datastore.gorm.finders.FindByBooleanFinder;
import org.grails.datastore.gorm.finders.FindByFinder;
import org.grails.datastore.gorm.finders.FindOrCreateByFinder;
import org.grails.datastore.gorm.finders.FindOrSaveByFinder;
import org.grails.datastore.gorm.finders.FinderMethod;
import org.grails.datastore.gorm.finders.ListOrderByFinder;
import org.grails.datastore.gorm.internal.InstanceMethodInvokingClosure;
import org.grails.datastore.gorm.internal.StaticMethodInvokingClosure;
import org.grails.datastore.gorm.query.GormQueryOperations;
import org.grails.datastore.gorm.query.NamedCriteriaProxy;
import org.grails.datastore.gorm.query.NamedQueriesBuilder;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesProvider;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesSupport;
import org.grails.datastore.mapping.core.connections.MultipleConnectionSourceCapableDatastore;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.config.GormProperties;
import org.grails.datastore.mapping.multitenancy.MultiTenancySettings;
import org.grails.datastore.mapping.multitenancy.MultiTenantCapableDatastore;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.grails.datastore.mapping.reflect.MetaClassUtils;
import org.grails.datastore.mapping.reflect.NameUtils;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionSystemException;

public class GormEnhancer
implements Closeable,
GroovyObject {
    private static final Map<String, Map<String, Closure>> NAMED_QUERIES;
    private static final Map<String, Map<String, GormStaticApi>> STATIC_APIS;
    private static final Map<String, Map<String, GormInstanceApi>> INSTANCE_APIS;
    private static final Map<String, Map<String, GormValidationApi>> VALIDATION_APIS;
    private static final Map<String, Map<String, Datastore>> DATASTORES;
    private static final Map<Class, Datastore> DATASTORES_BY_TYPE;
    private final Datastore datastore;
    private PlatformTransactionManager transactionManager;
    private List<FinderMethod> finders;
    private boolean failOnError;
    private boolean markDirty;
    private boolean includeExternal;
    private final boolean dynamicEnhance;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public GormEnhancer(Datastore datastore) {
        this(datastore, null);
    }

    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager, boolean failOnError, boolean dynamicEnhance, boolean markDirty) {
        this(datastore, transactionManager, new ConnectionSourceSettings().failOnError(failOnError).markDirty(markDirty));
    }

    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager, ConnectionSourceSettings settings) {
        boolean bl;
        PlatformTransactionManager platformTransactionManager;
        boolean bl2;
        Datastore datastore2;
        MetaClass metaClass;
        boolean bl3;
        this.includeExternal = bl3 = true;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.datastore = datastore2 = datastore;
        this.failOnError = bl2 = settings.isFailOnError();
        Boolean markDirty = settings.getMarkDirty();
        Boolean bl4 = markDirty == null ? Boolean.valueOf(true) : markDirty;
        this.markDirty = DefaultTypeTransformation.booleanUnbox(bl4);
        this.transactionManager = platformTransactionManager = transactionManager;
        this.dynamicEnhance = bl = false;
        if (datastore != null) {
            this.registerConstraints(datastore);
        }
        NAMED_QUERIES.clear();
        DATASTORES_BY_TYPE.put(datastore.getClass(), datastore);
        Collection<PersistentEntity> collection = datastore.getMappingContext().getPersistentEntities();
        PersistentEntity entity = null;
        Iterator<PersistentEntity> iterator = collection != null ? collection.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                entity = iterator.next();
                this.registerEntity((PersistentEntity)((Object)IndyInterface.bootstrap("cast", "()", 0, entity)));
            }
        }
    }

    @Generated
    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager, boolean failOnError, boolean dynamicEnhance) {
        this(datastore, transactionManager, failOnError, dynamicEnhance, true);
    }

    @Generated
    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager, boolean failOnError) {
        this(datastore, transactionManager, failOnError, false, true);
    }

    @Generated
    public GormEnhancer(Datastore datastore, PlatformTransactionManager transactionManager) {
        this(datastore, transactionManager, false, false, true);
    }

    public void registerEntity(PersistentEntity entity) {
        Datastore datastore = this.datastore;
        if (this.appliesToDatastore(datastore, entity)) {
            List<String> list;
            Class cls = entity.getJavaClass();
            List<String> qualifiers = this.allQualifiers(this.datastore, entity);
            if (!qualifiers.contains(ConnectionSource.DEFAULT)) {
                CallSite firstQualifier = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.first(qualifiers));
                GormStaticApi staticApi = this.getStaticApi(cls, (String)((Object)firstQualifier));
                String name = entity.getName();
                STATIC_APIS.get(ConnectionSource.DEFAULT).put(name, staticApi);
                GormInstanceApi instanceApi = this.getInstanceApi(cls, (String)((Object)firstQualifier));
                INSTANCE_APIS.get(ConnectionSource.DEFAULT).put(name, instanceApi);
                GormValidationApi validationApi = this.getValidationApi(cls, (String)((Object)firstQualifier));
                VALIDATION_APIS.get(ConnectionSource.DEFAULT).put(name, validationApi);
                DATASTORES.get(ConnectionSource.DEFAULT).put(name, this.datastore);
            }
            Iterator<String> iterator = (list = qualifiers) != null ? list.iterator() : null;
            String qualifier = null;
            Iterator<String> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    qualifier = iterator2.next();
                    GormStaticApi staticApi = this.getStaticApi(cls, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, qualifier)));
                    String name = entity.getName();
                    STATIC_APIS.get(qualifier).put(name, staticApi);
                    GormInstanceApi instanceApi = this.getInstanceApi(cls, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, qualifier)));
                    INSTANCE_APIS.get(qualifier).put(name, instanceApi);
                    GormValidationApi validationApi = this.getValidationApi(cls, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, qualifier)));
                    VALIDATION_APIS.get(qualifier).put(name, validationApi);
                    DATASTORES.get(qualifier).put(name, this.datastore);
                }
            }
        }
    }

    public List<String> allQualifiers(Datastore datastore, PersistentEntity entity) {
        ArrayList<String> qualifiers = new ArrayList<String>();
        qualifiers.addAll(ConnectionSourcesSupport.getConnectionSourceNames(entity));
        if ((MultiTenant.class.isAssignableFrom(entity.getJavaClass()) || qualifiers.contains(ConnectionSource.ALL)) && datastore instanceof ConnectionSourcesProvider) {
            qualifiers.clear();
            qualifiers.add(ConnectionSource.DEFAULT);
            Iterable allConnectionSources = IndyInterface.bootstrap("cast", "()", 0, datastore).getConnectionSources().getAllConnectionSources();
            public final class _allQualifiers_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _allQualifiers_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Boolean doCall(ConnectionSource connectionSource) {
                    return ScriptBytecodeAdapter.compareNotEqual(connectionSource.getName(), ConnectionSource.DEFAULT);
                }

                @Generated
                public Boolean call(ConnectionSource connectionSource) {
                    return this.doCall(connectionSource);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _allQualifiers_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            public final class _allQualifiers_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _allQualifiers_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public String doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, it).getName();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Override
                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public String doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _allQualifiers_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            List allConnectionSourceNames = DefaultGroovyMethods.collect(DefaultGroovyMethods.findAll(allConnectionSources, (Closure)new _allQualifiers_closure1(this, this)), new _allQualifiers_closure2(this, this));
            qualifiers.addAll(allConnectionSourceNames);
        }
        return qualifiers;
    }

    @Deprecated
    public static GormQueryOperations findNamedQuery(Class entity, String queryName) {
        return GormEnhancer.createNamedQuery(entity, queryName);
    }

    public static GormQueryOperations createNamedQuery(Class entity, String queryName) {
        return GormEnhancer.createNamedQuery(entity, queryName, new Object[]{null});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GormQueryOperations createNamedQuery(Class entity, String queryName, Object ... args) {
        className = entity.getName();
        namedQueries = IndyInterface.bootstrap("cast", "()", 0, GormEnhancer.NAMED_QUERIES.get(className));
        if (namedQueries == null == false) return GormEnhancer.buildNamedCriteriaProxy(entity, (Map<String, Closure>)namedQueries, queryName, args);
        var5_5 = GormEnhancer.NAMED_QUERIES;
        synchronized (var5_5) {
            block4: {
                namedQueries = IndyInterface.bootstrap("cast", "()", 0, GormEnhancer.NAMED_QUERIES.get(className));
                if (namedQueries == null == false) return GormEnhancer.buildNamedCriteriaProxy(entity, (Map<String, Closure>)namedQueries, queryName, args);
                cpf = ClassPropertyFetcher.forClass(entity);
                closure = IndyInterface.bootstrap("cast", "()", 0, cpf.getStaticPropertyValue(GormProperties.NAMED_QUERIES, Closure.class));
                if (!(closure != null)) break block4;
                closure = IndyInterface.bootstrap("cast", "()", 0, closure.clone());
                evaluator = new NamedQueriesBuilder();
                namedQueries = evaluator.evaluate((Closure)closure);
                GormEnhancer.NAMED_QUERIES.put(className, (Map<String, Closure>)namedQueries);
                ** GOTO lbl33
            }
            GormEnhancer.NAMED_QUERIES.put(className, Collections.emptyMap());
            return IndyInterface.bootstrap("cast", "()", 0, null);
lbl33:
            // 1 sources

            return GormEnhancer.buildNamedCriteriaProxy(entity, (Map<String, Closure>)namedQueries, queryName, args);
        }
    }

    private static NamedCriteriaProxy buildNamedCriteriaProxy(Class entity, Map<String, Closure> namedQueries, String queryName, Object ... args) {
        NamedCriteriaProxy namedCriteriaProxy = null;
        GormStaticApi staticApi = GormEnhancer.findStaticApi(entity);
        CallSite namedQueryClosure = IndyInterface.bootstrap("cast", "()", 0, namedQueries.get(queryName));
        if (namedQueryClosure != null) {
            namedCriteriaProxy = new NamedCriteriaProxy((Closure)((Object)IndyInterface.bootstrap("cast", "()", 0, ((Closure)((Object)namedQueryClosure)).clone())), staticApi.getGormPersistentEntity(), staticApi.getGormDynamicFinders());
            if (args != null) {
                namedCriteriaProxy.call(args);
            }
        }
        return namedCriteriaProxy;
    }

    protected static String findTenantId(Class entity) {
        if (MultiTenant.class.isAssignableFrom(entity)) {
            Datastore defaultDatastore = GormEnhancer.findDatastore(entity, ConnectionSource.DEFAULT);
            if (defaultDatastore instanceof MultiTenantCapableDatastore) {
                CallSite multiTenantCapableDatastore = IndyInterface.bootstrap("cast", "()", 0, defaultDatastore);
                if (ScriptBytecodeAdapter.compareEqual(multiTenantCapableDatastore.getMultiTenancyMode(), MultiTenancySettings.MultiTenancyMode.DATABASE)) {
                    return IndyInterface.bootstrap("cast", "()", 0, Tenants.currentId((MultiTenantCapableDatastore)((Object)multiTenantCapableDatastore)));
                }
                return ConnectionSource.DEFAULT;
            }
            log.debug("Return default tenant id for non-multitenant capable datastore");
            return ConnectionSource.DEFAULT;
        }
        log.debug("Returning default tenant id for non-multitenant class [{}]", (Object)entity);
        return ConnectionSource.DEFAULT;
    }

    public static <D> GormStaticApi<D> findStaticApi(Class<D> entity, String qualifier) {
        String className = NameUtils.getClassName(entity);
        Map<String, GormStaticApi> map = STATIC_APIS.get(qualifier);
        CallSite staticApi = IndyInterface.bootstrap("cast", "()", 0, map != null ? map.get(className) : null);
        if (staticApi == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return staticApi;
    }

    public static <D> GormInstanceApi<D> findInstanceApi(Class<D> entity, String qualifier) {
        Map<String, GormInstanceApi> map = INSTANCE_APIS.get(qualifier);
        CallSite instanceApi = IndyInterface.bootstrap("cast", "()", 0, map != null ? map.get(NameUtils.getClassName(entity)) : null);
        if (instanceApi == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return instanceApi;
    }

    public static <D> GormValidationApi<D> findValidationApi(Class<D> entity, String qualifier) {
        Map<String, GormValidationApi> map = VALIDATION_APIS.get(qualifier);
        CallSite instanceApi = IndyInterface.bootstrap("cast", "()", 0, map != null ? map.get(NameUtils.getClassName(entity)) : null);
        if (instanceApi == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return instanceApi;
    }

    public static Datastore findDatastore(Class entity, String qualifier) {
        Map<String, Datastore> map = DATASTORES.get(qualifier);
        CallSite datastore = IndyInterface.bootstrap("cast", "()", 0, map != null ? map.get(entity.getName()) : null);
        if (datastore == null) {
            throw (Throwable)GormEnhancer.stateException(entity);
        }
        return datastore;
    }

    public static Datastore findDatastoreByType(Class<? extends Datastore> datastoreType) {
        CallSite datastore = IndyInterface.bootstrap("cast", "()", 0, DATASTORES_BY_TYPE.get(datastoreType));
        if (datastore == null) {
            throw (Throwable)new IllegalStateException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{datastoreType}, new String[]{"No GORM implementation configured for type [", "]. Ensure GORM has been initialized correctly"}))));
        }
        return datastore;
    }

    public static Datastore findSingleDatastore() {
        Collection<Datastore> allDatastores = DATASTORES_BY_TYPE.values();
        if (allDatastores.isEmpty()) {
            throw (Throwable)new IllegalStateException("No GORM implementations configured. Ensure GORM has been initialized correctly");
        }
        if (allDatastores.size() > 1) {
            throw (Throwable)new IllegalStateException("More than one GORM implementation is configured. Specific the datastore type!");
        }
        return IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.first(allDatastores));
    }

    public static PlatformTransactionManager findSingleTransactionManager(String connectionName) {
        Datastore datastore = GormEnhancer.findSingleDatastore();
        return GormEnhancer.getTransactionManagerForConnection(datastore, connectionName);
    }

    public static PlatformTransactionManager findTransactionManager(Class<? extends Datastore> datastoreType, String connectionName) {
        Datastore datastore = GormEnhancer.findDatastoreByType(datastoreType);
        return GormEnhancer.getTransactionManagerForConnection(datastore, connectionName);
    }

    public static PersistentEntity findEntity(Class entity, String qualifier) {
        return GormEnhancer.findDatastore(entity, qualifier).getMappingContext().getPersistentEntity(entity.getName());
    }

    @Override
    public void close() throws IOException {
        this.removeConstraints();
        DATASTORES_BY_TYPE.clear();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        Collection<PersistentEntity> collection = this.datastore.getMappingContext().getPersistentEntities();
        PersistentEntity entity = null;
        Iterator<PersistentEntity> iterator = collection != null ? collection.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                entity = iterator.next();
                List<String> qualifiers = this.allQualifiers(this.datastore, (PersistentEntity)((Object)IndyInterface.bootstrap("cast", "()", 0, entity)));
                Class cls = entity.getJavaClass();
                String className = cls.getName();
                String q = null;
                List<String> list = qualifiers;
                Iterator<String> iterator2 = list != null ? list.iterator() : null;
                if (iterator2 != null) {
                    while (iterator2.hasNext()) {
                        q = iterator2.next();
                        NAMED_QUERIES.remove(className);
                        Map<String, GormStaticApi> map = STATIC_APIS.get(q);
                        GormStaticApi gormStaticApi = map != null ? map.remove(className) : null;
                        Map<String, GormInstanceApi> map2 = INSTANCE_APIS.get(q);
                        GormInstanceApi gormInstanceApi = map2 != null ? map2.remove(className) : null;
                        Map<String, GormValidationApi> map3 = VALIDATION_APIS.get(q);
                        GormValidationApi gormValidationApi = map3 != null ? map3.remove(className) : null;
                        Map<String, Datastore> map4 = DATASTORES.get(q);
                        Datastore datastore = map4 != null ? map4.remove(this.datastore) : null;
                    }
                }
                registry.removeMetaClass(cls);
            }
        }
    }

    private static PlatformTransactionManager getTransactionManagerForConnection(Datastore datastore, String connectionName) {
        if (datastore instanceof TransactionCapableDatastore && ConnectionSource.DEFAULT.equals(connectionName)) {
            return IndyInterface.bootstrap("cast", "()", 0, datastore).getTransactionManager();
        }
        if (datastore instanceof MultipleConnectionSourceCapableDatastore) {
            Datastore datastoreForConnection = IndyInterface.bootstrap("cast", "()", 0, datastore).getDatastoreForConnection(connectionName);
            if (datastoreForConnection instanceof TransactionCapableDatastore) {
                return IndyInterface.bootstrap("cast", "()", 0, datastoreForConnection).getTransactionManager();
            }
        }
        throw (Throwable)new TransactionSystemException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{datastore.getClass().getName()}, new String[]{"Datastore implementation ", " does not support transactions!"}))));
    }

    private static IllegalStateException stateException(Class entity) {
        return new IllegalStateException((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{entity.getName()}, new String[]{"Either class [", "] is not a domain class or GORM has not been initialized correctly or has already been shutdown. Ensure GORM is loaded and configured correctly before calling any methods on a GORM entity."}))));
    }

    protected void removeConstraints() {
        try {
            String className = "org.apache.groovy.grails.validation.ConstrainedProperty";
            CallSite classLoader = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getClassLoader", 0, IndyInterface.bootstrap("invoke", "getClass", 2, this)));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isPresent", 0, ClassUtils.class, className, classLoader)) != false) {
                IndyInterface.bootstrap("invoke", "removeConstraint", 0, IndyInterface.bootstrap("invoke", "loadClass", 0, classLoader, className), "unique");
            }
        }
        catch (Throwable e) {
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Not running in Grails 2 environment, cannot de-register constraints. This exception can be safely ignored if you are not using Grails 2. ", ""}), e) : null;
        }
    }

    protected void registerConstraints(Datastore datastore) {
        block6: {
            try {
                String className = "org.grails.datastore.gorm.support.ConstraintRegistrar";
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (ClassUtils.isPresent(className, classLoader)) {
                    DefaultGroovyMethods.newInstance(classLoader.loadClass(className), new Object[]{datastore});
                }
            }
            catch (Throwable e) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Unable to register GORM constraints. Not running a Grails environment. This can be safely ignored if you are not running Grails: ", ""}))), e);
                    v0 = null;
                    break block6;
                }
                v0 = null;
            }
        }
    }

    public List<FinderMethod> getFinders() {
        if (this.finders == null) {
            List<FinderMethod> list = Collections.unmodifiableList(this.createDynamicFinders());
            this.finders = list;
        }
        return this.finders;
    }

    public void enhance(boolean onlyExtendedMethods) {
        if (this.dynamicEnhance) {
            Collection<PersistentEntity> collection = this.datastore.getMappingContext().getPersistentEntities();
            Iterator<PersistentEntity> iterator = collection != null ? collection.iterator() : null;
            CallSite e = null;
            Iterator<PersistentEntity> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    e = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                    if (e.isExternal() && !this.includeExternal) continue;
                    this.enhance((PersistentEntity)((Object)e), onlyExtendedMethods);
                }
            }
        }
    }

    public void enhance(PersistentEntity e, boolean onlyExtendedMethods) {
        this.registerEntity(e);
        if (!GroovyObject.class.isAssignableFrom(e.getJavaClass()) || this.dynamicEnhance) {
            this.addInstanceMethods(e, onlyExtendedMethods);
            this.addStaticMethods(e, onlyExtendedMethods);
        }
    }

    protected void addStaticMethods(PersistentEntity e, boolean onlyExtendedMethods) {
        Class cls = e.getJavaClass();
        ExpandoMetaClass mc = MetaClassUtils.getExpandoMetaClass(cls);
        GormStaticApi staticApiProvider = this.getStaticApi(cls);
        List<Method> list = onlyExtendedMethods ? staticApiProvider.getExtendedMethods() : staticApiProvider.getMethods();
        CallSite m = null;
        Iterator<Method> iterator = list != null ? list.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                CallSite method = m = IndyInterface.bootstrap("cast", "()", 0, iterator.next());
                if (!(method != null)) continue;
                String methodName = ((Method)((Object)method)).getName();
                Class[] parameterTypes = ((Method)((Object)method)).getParameterTypes();
                if (!(parameterTypes != null)) continue;
                boolean realMethodExists = GormEnhancer.doesRealMethodExist(mc, methodName, parameterTypes, true);
                if (!(!realMethodExists)) continue;
                this.registerStaticMethod(mc, methodName, parameterTypes, staticApiProvider);
            }
        }
    }

    protected void registerStaticMethod(ExpandoMetaClass mc, String methodName, Class<?>[] parameterTypes, GormStaticApi staticApiProvider) {
        CallSite callable = IndyInterface.bootstrap("init", "<init>", 0, StaticMethodInvokingClosure.class, staticApiProvider, methodName, parameterTypes);
        CallSite callSite = callable;
        ScriptBytecodeAdapter.setProperty(callSite, null, IndyInterface.bootstrap("getProperty", "static", 4, mc), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{methodName}, new String[]{"", ""}))));
    }

    protected boolean appliesToDatastore(Datastore datastore, PersistentEntity entity) {
        return !entity.isExternal();
    }

    protected <D> List<AbstractGormApi<D>> getInstanceMethodApiProviders(Class<D> cls) {
        return ScriptBytecodeAdapter.createList(new Object[]{IndyInterface.bootstrap("invoke", "getInstanceApi", 2, this, cls), IndyInterface.bootstrap("invoke", "getValidationApi", 2, this, cls)});
    }

    protected void addInstanceMethods(PersistentEntity e, boolean onlyExtendedMethods) {
        Class cls = e.getJavaClass();
        ExpandoMetaClass mc = MetaClassUtils.getExpandoMetaClass(cls);
        List list = this.getInstanceMethodApiProviders(cls);
        Iterator iterator = list != null ? list.iterator() : null;
        CallSite apiProvider = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                apiProvider = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                List<Method> list2 = onlyExtendedMethods ? ((AbstractGormApi)((Object)apiProvider)).getExtendedMethods() : ((AbstractGormApi)((Object)apiProvider)).getMethods();
                CallSite method = null;
                Iterator<Method> iterator3 = list2 != null ? list2.iterator() : null;
                if (iterator3 == null) continue;
                while (iterator3.hasNext()) {
                    method = IndyInterface.bootstrap("cast", "()", 0, iterator3.next());
                    String methodName = ((Method)((Object)method)).getName();
                    Class[] parameterTypes = ((Method)((Object)method)).getParameterTypes();
                    if ((parameterTypes == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, parameterTypes)) == false) continue;
                    parameterTypes = (Class[])IndyInterface.bootstrap("invoke", "asType", 0, parameterTypes.length == 1 ? ScriptBytecodeAdapter.createList(new Object[0]) : DefaultGroovyMethods.getAt(parameterTypes, new IntRange(true, true, 1, -1)), Class[].class);
                    boolean realMethodExists = GormEnhancer.doesRealMethodExist(mc, methodName, parameterTypes, false);
                    if (!(!realMethodExists)) continue;
                    this.registerInstanceMethod(cls, mc, (AbstractGormApi)((Object)apiProvider), methodName, parameterTypes);
                }
            }
        }
    }

    protected Object registerInstanceMethod(Class cls, ExpandoMetaClass mc, AbstractGormApi apiProvider, String methodName, Class ... parameterTypes) {
        InstanceMethodInvokingClosure tooCall = new InstanceMethodInvokingClosure((Object)apiProvider, cls, methodName, parameterTypes);
        Class[] pt = parameterTypes;
        GroovyObject closureMethod = new GroovyObject(this, methodName, cls, tooCall, pt){
            final /* synthetic */ GormEnhancer this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                GormEnhancer gormEnhancer;
                this.this$0 = gormEnhancer = p0;
                super((String)((Object)IndyInterface.bootstrap("cast", "()", 0, p10)), (Class)((Object)IndyInterface.bootstrap("cast", "()", 0, p11)), (Closure)((Object)IndyInterface.bootstrap("cast", "()", 0, p12)), (Class[])IndyInterface.bootstrap("cast", "()", 0, p13));
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public int getModifiers() {
                return Modifier.PUBLIC;
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                try {
                    return this.this$0.this$dist$invoke$1(name, args);
                }
                catch (MissingMethodException notFound2) {
                    throw (Throwable)new MissingMethodException(notFound2.getMethod(), this.getClass(), notFound2.getArguments());
                }
            }

            /*
             * Unable to fully structure code
             */
            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[] == false)) ** GOTO lbl8
                var2_2 = ScriptBytecodeAdapter.invokeMethodN(1.class, GormEnhancer.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), new Object[]{args});
                return var2_2;
lbl8:
                // 1 sources

                if (!(((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1)) ** GOTO lbl14
                var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, GormEnhancer.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), 0)});
                return var3_3;
lbl14:
                // 1 sources

                var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, GormEnhancer.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
                try {
                    return var4_4;
                }
                catch (MissingMethodException notFound) {
                    throw (Throwable)new MissingMethodException(notFound.getMethod(), 1.class, notFound.getArguments());
                }
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                try {
                    this.this$0.this$dist$set$1(name, value);
                    return;
                }
                catch (MissingPropertyException notFound2) {
                    throw (Throwable)new MissingPropertyException(notFound2.getProperty(), this.getClass(), notFound2.getCause());
                }
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                try {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty(object, null, GormEnhancer.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                }
                catch (MissingPropertyException notFound2) {
                    throw (Throwable)new MissingPropertyException(notFound2.getProperty(), 1.class, notFound2.getCause());
                }
            }

            public /* synthetic */ Object propertyMissing(String name) {
                try {
                    return this.this$0.this$dist$get$1(name);
                }
                catch (MissingPropertyException notFound2) {
                    throw (Throwable)new MissingPropertyException(notFound2.getProperty(), this.getClass(), notFound2.getCause());
                }
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                Object object = ScriptBytecodeAdapter.getProperty(1.class, GormEnhancer.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                try {
                    return object;
                }
                catch (MissingPropertyException notFound2) {
                    throw (Throwable)new MissingPropertyException(notFound2.getProperty(), 1.class, notFound2.getCause());
                }
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Override
            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Override
            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        };
        mc.registerInstanceMethod((MetaMethod)((Object)closureMethod));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean doesRealMethodExist(MetaClass mc, String methodName, Class[] parameterTypes, boolean staticScope) {
        void var2_2;
        Reference<String> methodName2 = new Reference<String>(methodName);
        Reference<void> parameterTypes2 = new Reference<void>(var2_2);
        Reference<Boolean> staticScope2 = new Reference<Boolean>(staticScope);
        boolean realMethodExists = false;
        try {
            MetaMethod existingMethod = mc.pickMethod(methodName2.get(), (Class[])parameterTypes2.get());
            if (DefaultTypeTransformation.booleanUnbox(existingMethod) && ScriptBytecodeAdapter.compareEqual(existingMethod.isStatic(), DefaultTypeTransformation.booleanUnbox(staticScope2.get())) && GormEnhancer.isRealMethod(existingMethod) && ((Class[])parameterTypes2.get()).length == existingMethod.getParameterTypes().length) {
                realMethodExists = true;
            }
        }
        catch (MethodSelectionException mse) {
            public final class _doesRealMethodExist_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference methodName;
                private /* synthetic */ Reference staticScope;
                private /* synthetic */ Reference parameterTypes;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _doesRealMethodExist_closure3(Object _outerInstance, Object _thisObject, Reference methodName, Reference staticScope, Reference parameterTypes) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.methodName = reference3 = methodName;
                    this.staticScope = reference2 = staticScope;
                    this.parameterTypes = reference = parameterTypes;
                }

                /*
                 * Unable to fully structure code
                 */
                public Boolean doCall(MetaMethod existingMethod) {
                    if (!((ScriptBytecodeAdapter.compareEqual(existingMethod.getName(), IndyInterface.bootstrap("cast", "()", 0, this.methodName.get())) != false && ScriptBytecodeAdapter.compareEqual(existingMethod.isStatic(), IndyInterface.bootstrap("cast", "()", 0, this.staticScope.get())) != false) != false && DefaultTypeTransformation.booleanUnbox(InvokerHelper.invokeStaticMethod(GormEnhancer.class, "isRealMethod", (Object)new Object[]{existingMethod})) != false)) ** GOTO lbl-1000
                    v0 = IndyInterface.bootstrap("cast", "()", 0, this.parameterTypes.get());
                    if (!((v0 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v0)) == false)) ** GOTO lbl-1000
                    v1 = existingMethod.getParameterTypes();
                    if ((v1 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, v1)) == false) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (v2 != false || ScriptBytecodeAdapter.compareEqual(IndyInterface.bootstrap("cast", "()", 0, this.parameterTypes.get()), existingMethod.getParameterTypes()) != false) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    return v3;
                }

                @Generated
                public Boolean call(MetaMethod existingMethod) {
                    return this.doCall(existingMethod);
                }

                @Generated
                public String getMethodName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.methodName.get());
                }

                @Generated
                public boolean getStaticScope() {
                    return DefaultTypeTransformation.booleanUnbox(IndyInterface.bootstrap("cast", "()", 0, this.staticScope.get()));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _doesRealMethodExist_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            realMethodExists = mc.getMethods().contains(new _doesRealMethodExist_closure3(GormEnhancer.class, GormEnhancer.class, methodName2, staticScope2, parameterTypes2));
        }
        return realMethodExists;
    }

    protected static boolean isRealMethod(MetaMethod existingMethod) {
        return existingMethod instanceof CachedMethod;
    }

    protected <D> GormStaticApi<D> getStaticApi(Class<D> cls, String qualifier) {
        return new GormStaticApi<D>(cls, this.datastore, this.getFinders(), this.transactionManager);
    }

    protected <D> GormInstanceApi<D> getInstanceApi(Class<D> cls, String qualifier) {
        GormInstanceApi<D> instanceApi = new GormInstanceApi<D>(cls, this.datastore);
        boolean bl = this.failOnError;
        instanceApi.setFailOnError(bl);
        boolean bl2 = this.markDirty;
        instanceApi.setMarkDirty(bl2);
        return instanceApi;
    }

    protected <D> GormValidationApi<D> getValidationApi(Class<D> cls, String qualifier) {
        return new GormValidationApi<D>(cls, this.datastore);
    }

    protected List<FinderMethod> createDynamicFinders() {
        Datastore targetDatastore = this.datastore;
        return this.createDynamicFinders(targetDatastore);
    }

    protected List<FinderMethod> createDynamicFinders(Datastore targetDatastore) {
        return ScriptBytecodeAdapter.createList(new Object[]{new FindOrCreateByFinder(targetDatastore), new FindOrSaveByFinder(targetDatastore), new FindByFinder(targetDatastore), new FindAllByFinder(targetDatastore), new FindAllByBooleanFinder(targetDatastore), new FindByBooleanFinder(targetDatastore), new CountByFinder(targetDatastore), new ListOrderByFinder(targetDatastore)});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GormEnhancer.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GormEnhancer.class, this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), new Object[]{args});
        }
        if (((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GormEnhancer.class, this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), 0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GormEnhancer.class, this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, GormEnhancer.class, this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GormEnhancer.class, this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    public static <D> GormStaticApi<D> findStaticApi(Class<D> entity) {
        return GormEnhancer.findStaticApi(entity, GormEnhancer.findTenantId(entity));
    }

    @Generated
    public static <D> GormInstanceApi<D> findInstanceApi(Class<D> entity) {
        return GormEnhancer.findInstanceApi(entity, GormEnhancer.findTenantId(entity));
    }

    @Generated
    public static <D> GormValidationApi<D> findValidationApi(Class<D> entity) {
        return GormEnhancer.findValidationApi(entity, GormEnhancer.findTenantId(entity));
    }

    @Generated
    public static Datastore findDatastore(Class entity) {
        return GormEnhancer.findDatastore(entity, GormEnhancer.findTenantId(entity));
    }

    @Generated
    public static PlatformTransactionManager findSingleTransactionManager() {
        return GormEnhancer.findSingleTransactionManager((String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "DEFAULT", 0, ConnectionSource.class))));
    }

    @Generated
    public static PlatformTransactionManager findTransactionManager(Class<? extends Datastore> datastoreType) {
        return GormEnhancer.findTransactionManager(datastoreType, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "DEFAULT", 0, ConnectionSource.class))));
    }

    @Generated
    public static PersistentEntity findEntity(Class entity) {
        return GormEnhancer.findEntity(entity, GormEnhancer.findTenantId(entity));
    }

    @Generated
    public void enhance() {
        this.enhance(false);
    }

    @Generated
    public void enhance(PersistentEntity e) {
        this.enhance(e, false);
    }

    @Generated
    protected <D> GormStaticApi<D> getStaticApi(Class<D> cls) {
        return this.getStaticApi(cls, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "DEFAULT", 0, ConnectionSource.class))));
    }

    @Generated
    protected <D> GormInstanceApi<D> getInstanceApi(Class<D> cls) {
        return this.getInstanceApi(cls, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "DEFAULT", 0, ConnectionSource.class))));
    }

    @Generated
    protected <D> GormValidationApi<D> getValidationApi(Class<D> cls) {
        return this.getValidationApi(cls, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "DEFAULT", 0, ConnectionSource.class))));
    }

    @Override
    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        ConcurrentHashMap<String, Map<String, Closure>> concurrentHashMap = new ConcurrentHashMap<String, Map<String, Closure>>();
        NAMED_QUERIES = concurrentHashMap;
        public final class __clinit__closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Map<String, GormStaticApi> doCall(String key) {
                return new ConcurrentHashMap();
            }

            @Generated
            public Map<String, GormStaticApi> call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != __clinit__closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Map map = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), new __clinit__closure4(GormEnhancer.class, GormEnhancer.class));
        STATIC_APIS = map;
        public final class __clinit__closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Map<String, GormInstanceApi> doCall(String key) {
                return new ConcurrentHashMap();
            }

            @Generated
            public Map<String, GormInstanceApi> call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != __clinit__closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Map map2 = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), new __clinit__closure5(GormEnhancer.class, GormEnhancer.class));
        INSTANCE_APIS = map2;
        public final class __clinit__closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Map<String, GormValidationApi> doCall(String key) {
                return new ConcurrentHashMap();
            }

            @Generated
            public Map<String, GormValidationApi> call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != __clinit__closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Map map3 = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), new __clinit__closure6(GormEnhancer.class, GormEnhancer.class));
        VALIDATION_APIS = map3;
        public final class __clinit__closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Map<String, Datastore> doCall(String key) {
                return new ConcurrentHashMap();
            }

            @Generated
            public Map<String, Datastore> call(String key) {
                return this.doCall(key);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != __clinit__closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Map map4 = DefaultGroovyMethods.withDefault(new ConcurrentHashMap(), new __clinit__closure7(GormEnhancer.class, GormEnhancer.class));
        DATASTORES = map4;
        ConcurrentHashMap<Class, Datastore> concurrentHashMap2 = new ConcurrentHashMap<Class, Datastore>();
        DATASTORES_BY_TYPE = concurrentHashMap2;
        log = logger = LoggerFactory.getLogger("org.grails.datastore.gorm.GormEnhancer");
    }

    @Generated
    public Datastore getDatastore() {
        return this.datastore;
    }

    @Generated
    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Generated
    public void setTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.transactionManager = platformTransactionManager;
    }

    @Generated
    public void setFinders(List<FinderMethod> list) {
        this.finders = list;
    }

    @Generated
    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    @Generated
    public boolean getMarkDirty() {
        return this.markDirty;
    }

    @Generated
    public boolean isMarkDirty() {
        return this.markDirty;
    }

    @Generated
    public void setMarkDirty(boolean bl) {
        this.markDirty = bl;
    }

    @Generated
    public boolean getIncludeExternal() {
        return this.includeExternal;
    }

    @Generated
    public boolean isIncludeExternal() {
        return this.includeExternal;
    }

    @Generated
    public void setIncludeExternal(boolean bl) {
        this.includeExternal = bl;
    }

    @Generated
    public boolean getDynamicEnhance() {
        return this.dynamicEnhance;
    }

    @Generated
    public boolean isDynamicEnhance() {
        return this.dynamicEnhance;
    }
}

