/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.lang.Nullable;
import org.springframework.transaction.interceptor.TransactionAttributeSourcePointcut;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

public class TransactionAttributeSourceAdvisor
extends AbstractPointcutAdvisor {
    @Nullable
    private TransactionInterceptor transactionInterceptor;
    private final TransactionAttributeSourcePointcut pointcut = new TransactionAttributeSourcePointcut();

    public TransactionAttributeSourceAdvisor() {
    }

    public TransactionAttributeSourceAdvisor(TransactionInterceptor interceptor2) {
        this.setTransactionInterceptor(interceptor2);
    }

    public void setTransactionInterceptor(TransactionInterceptor interceptor2) {
        Assert.notNull((Object)interceptor2, "TransactionInterceptor must not be null");
        this.transactionInterceptor = interceptor2;
        this.pointcut.setTransactionAttributeSource(interceptor2.getTransactionAttributeSource());
    }

    public void setClassFilter(ClassFilter classFilter) {
        this.pointcut.setClassFilter(classFilter);
    }

    @Override
    public Advice getAdvice() {
        Assert.state(this.transactionInterceptor != null, "No TransactionInterceptor set");
        return this.transactionInterceptor;
    }

    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }
}

