/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.helix.controller.stages.ClusterEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterEvent {
    private static final Logger logger = LoggerFactory.getLogger((String)ClusterEvent.class.getName());
    private final ClusterEventType _eventType;
    private final Map<String, Object> _eventAttributeMap;
    private long _creationTime;
    private String _clusterName;
    private String _eventId;

    @Deprecated
    public ClusterEvent(ClusterEventType eventType) {
        this._eventType = eventType;
        this._eventAttributeMap = new HashMap<String, Object>();
        this._creationTime = System.currentTimeMillis();
        this._eventId = UUID.randomUUID().toString();
    }

    public ClusterEvent(String clusterName, ClusterEventType eventType) {
        this(clusterName, eventType, UUID.randomUUID().toString());
    }

    public ClusterEvent(String clusterName, ClusterEventType eventType, String eventId) {
        this._clusterName = clusterName;
        this._eventType = eventType;
        this._eventAttributeMap = new HashMap<String, Object>();
        this._creationTime = System.currentTimeMillis();
        this._eventId = eventId;
    }

    public void addAttribute(String attrName, Object attrValue) {
        if (logger.isTraceEnabled()) {
            logger.trace("Adding attribute:" + attrName);
            logger.trace(" attribute value:" + attrValue);
        }
        this._eventAttributeMap.put(attrName, attrValue);
    }

    public ClusterEventType getEventType() {
        return this._eventType;
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public void setCreationTime(long creationTime) {
        this._creationTime = creationTime;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public void setClusterName(String clusterName) {
        this._clusterName = clusterName;
    }

    public void setEventId(String eventId) {
        this._eventId = eventId;
    }

    public String getEventId() {
        return this._eventId;
    }

    public <T> T getAttribute(String attrName) {
        return this.getAttributeWithDefault(attrName, null);
    }

    public <T> T getAttributeWithDefault(String attrName, T defaultVal) {
        Object ret = this._eventAttributeMap.get(attrName);
        return (T)(ret == null ? defaultVal : ret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Event id : %s", this._eventId));
        sb.append("name:" + this._eventType.name()).append("\n");
        for (String key : this._eventAttributeMap.keySet()) {
            sb.append(key).append(":").append(this._eventAttributeMap.get(key)).append("\n");
        }
        return sb.toString();
    }

    public ClusterEvent clone(String eventId) {
        ClusterEvent newEvent = new ClusterEvent(this._clusterName, this._eventType, eventId);
        newEvent.setCreationTime(this._creationTime);
        for (String attributeName : this._eventAttributeMap.keySet()) {
            newEvent.addAttribute(attributeName, this._eventAttributeMap.get(attributeName));
        }
        return newEvent;
    }
}

