/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadClusterDataStage
extends AbstractBaseStage {
    private static final Logger logger = LoggerFactory.getLogger((String)ReadClusterDataStage.class.getName());

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        if (manager == null) {
            throw new StageException("HelixManager attribute value is null");
        }
        final BaseControllerDataProvider dataProvider = (BaseControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        HelixDataAccessor dataAccessor = manager.getHelixDataAccessor();
        dataProvider.refresh(dataAccessor);
        final ClusterConfig clusterConfig = dataProvider.getClusterConfig();
        final ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
        if (dataProvider instanceof ResourceControllerDataProvider) {
            ReadClusterDataStage.asyncExecute(dataProvider.getAsyncTasksThreadPool(), new Callable<Object>(){

                @Override
                public Object call() {
                    if (clusterStatusMonitor != null) {
                        LogUtil.logDebug(logger, ReadClusterDataStage.this._eventId, "Update cluster status monitors");
                        HashSet instanceSet = Sets.newHashSet();
                        HashSet liveInstanceSet = Sets.newHashSet();
                        HashSet disabledInstanceSet = Sets.newHashSet();
                        HashMap disabledPartitions = Maps.newHashMap();
                        HashMap oldDisabledPartitions = Maps.newHashMap();
                        HashMap tags = Maps.newHashMap();
                        Map<String, LiveInstance> liveInstanceMap = dataProvider.getLiveInstances();
                        for (Map.Entry<String, InstanceConfig> e : dataProvider.getInstanceConfigMap().entrySet()) {
                            String instanceName = e.getKey();
                            InstanceConfig config = e.getValue();
                            instanceSet.add(instanceName);
                            if (liveInstanceMap.containsKey(instanceName)) {
                                liveInstanceSet.add(instanceName);
                            }
                            if (!config.getInstanceEnabled() || clusterConfig.getDisabledInstances() != null && clusterConfig.getDisabledInstances().containsKey(instanceName)) {
                                disabledInstanceSet.add(instanceName);
                            }
                            oldDisabledPartitions.put(instanceName, config.getDisabledPartitions());
                            disabledPartitions.put(instanceName, config.getDisabledPartitionsMap());
                            HashSet instanceTags = Sets.newHashSet(config.getTags());
                            tags.put(instanceName, instanceTags);
                        }
                        clusterStatusMonitor.setClusterInstanceStatus(liveInstanceSet, instanceSet, disabledInstanceSet, disabledPartitions, oldDisabledPartitions, tags);
                        LogUtil.logDebug(logger, ReadClusterDataStage.this._eventId, "Complete cluster status monitors update.");
                    }
                    return null;
                }
            });
        } else {
            ReadClusterDataStage.asyncExecute(dataProvider.getAsyncTasksThreadPool(), new Callable<Object>(){

                @Override
                public Object call() {
                    clusterStatusMonitor.refreshWorkflowsStatus((WorkflowControllerDataProvider)dataProvider);
                    clusterStatusMonitor.refreshJobsStatus((WorkflowControllerDataProvider)dataProvider);
                    LogUtil.logDebug(logger, ReadClusterDataStage.this._eventId, "Workflow/Job gauge status successfully refreshed");
                    return null;
                }
            });
        }
    }
}

