/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.monitoring.mbeans.InstanceMonitorMBean;

public class InstanceMonitor
implements InstanceMonitorMBean {
    private final String _clusterName;
    private final String _participantName;
    private List<String> _tags;
    private long _disabledPartitions;
    private boolean _isUp;
    private boolean _isEnabled;
    private long _totalMessageReceived;

    public InstanceMonitor(String clusterName, String participantName) {
        this._clusterName = clusterName;
        this._participantName = participantName;
        this._tags = ImmutableList.of((Object)"DEFAULT");
        this._disabledPartitions = 0L;
        this._isUp = false;
        this._isEnabled = false;
        this._totalMessageReceived = 0L;
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s.%s", "ParticipantStatus", this._clusterName, this.serializedTags(), this._participantName);
    }

    @Override
    public long getOnline() {
        return this._isUp ? 1L : 0L;
    }

    @Override
    public long getEnabled() {
        return this._isEnabled ? 1L : 0L;
    }

    @Override
    public long getTotalMessageReceived() {
        return this._totalMessageReceived;
    }

    @Override
    public long getDisabledPartitions() {
        return this._disabledPartitions;
    }

    public List<String> getTags() {
        return this._tags;
    }

    public String getInstanceName() {
        return this._participantName;
    }

    private String serializedTags() {
        return Joiner.on((char)'|').skipNulls().join(this._tags).toString();
    }

    public synchronized void updateInstance(Set<String> tags, Map<String, List<String>> disabledPartitions, List<String> oldDisabledPartitions, boolean isLive, boolean isEnabled) {
        if (tags == null || tags.isEmpty()) {
            this._tags = ImmutableList.of((Object)"DEFAULT");
        } else {
            this._tags = Lists.newArrayList(tags);
            Collections.sort(this._tags);
        }
        this._disabledPartitions = 0L;
        if (disabledPartitions != null) {
            for (List<String> partitions : disabledPartitions.values()) {
                if (partitions == null) continue;
                this._disabledPartitions += (long)partitions.size();
            }
        }
        if (oldDisabledPartitions != null) {
            this._disabledPartitions += (long)oldDisabledPartitions.size();
        }
        this._isUp = isLive;
        this._isEnabled = isEnabled;
    }

    public synchronized void increaseMessageCount(long messageReceived) {
        this._totalMessageReceived += messageReceived;
    }
}

