/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancesResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(InstancesResource.class);

    public InstancesResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            presentation = this.getInstancesRepresentation(clusterName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getInstancesRepresentation(String clusterName) throws JsonGenerationException, JsonMappingException, IOException {
        ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
        HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
        Map liveInstancesMap = accessor.getChildValuesMap(accessor.keyBuilder().liveInstances());
        Map instanceConfigsMap = accessor.getChildValuesMap(accessor.keyBuilder().instanceConfigs());
        TreeMap<String, List<String>> tagInstanceLists = new TreeMap<String, List<String>>();
        for (Object instanceName : instanceConfigsMap.keySet()) {
            boolean isAlive = liveInstancesMap.containsKey(instanceName);
            ((InstanceConfig)instanceConfigsMap.get(instanceName)).getRecord().setSimpleField("Alive", isAlive + "");
            InstanceConfig config = (InstanceConfig)instanceConfigsMap.get(instanceName);
            for (String tag : config.getTags()) {
                if (!tagInstanceLists.containsKey(tag)) {
                    tagInstanceLists.put(tag, new LinkedList());
                }
                if (((List)tagInstanceLists.get(tag)).contains(instanceName)) continue;
                ((List)tagInstanceLists.get(tag)).add(instanceName);
            }
        }
        ArrayList recordList = Lists.newArrayList();
        for (InstanceConfig instanceConfig : instanceConfigsMap.values()) {
            recordList.add(instanceConfig.getRecord());
        }
        ListInstancesWrapper wrapper = new ListInstancesWrapper();
        wrapper.instanceInfo = recordList;
        wrapper.tagInfo = tagInstanceLists;
        StringRepresentation representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ObjectToJson(wrapper), MediaType.APPLICATION_JSON);
        return representation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Representation post(Representation entity) {
        try {
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            JsonParameters jsonParameters = new JsonParameters(entity);
            String command = jsonParameters.getCommand();
            ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
            ClusterSetup setupTool = new ClusterSetup((HelixZkClient)zkClient);
            if (command.equalsIgnoreCase("addNode") || JsonParameters.CLUSTERSETUP_COMMAND_ALIASES.get("addNode").contains(command)) {
                if (jsonParameters.getParameter("instanceName") != null) {
                    setupTool.addInstanceToCluster(clusterName, jsonParameters.getParameter("instanceName"));
                } else {
                    if (jsonParameters.getParameter("instanceNames") == null) throw new HelixException("Missing Json paramaters: 'instanceName' or 'instanceNames' ");
                    setupTool.addInstancesToCluster(clusterName, jsonParameters.getParameter("instanceNames").split(";"));
                }
            } else {
                if (!command.equalsIgnoreCase("swapInstance")) throw new HelixException("Unsupported command: " + command + ". Should be one of [" + "addNode" + ", " + "swapInstance" + "]");
                if (jsonParameters.getParameter("newInstance") == null || jsonParameters.getParameter("oldInstance") == null) {
                    throw new HelixException("Missing Json paramaters: 'newInstance' or 'oldInstance' ");
                }
                setupTool.swapInstance(clusterName, jsonParameters.getParameter("oldInstance"), jsonParameters.getParameter("newInstance"));
            }
            this.getResponse().setEntity((Representation)this.getInstancesRepresentation(clusterName));
            this.getResponse().setStatus(Status.SUCCESS_OK);
            return null;
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("", (Throwable)e);
        }
        return null;
    }

    public static class ListInstancesWrapper {
        public List<ZNRecord> instanceInfo;
        public Map<String, List<String>> tagInfo;
    }
}

