/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.io.IOException;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateModelResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(StateModelResource.class);

    public StateModelResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            String modelName = (String)this.getRequest().getAttributes().get("modelName");
            presentation = this.getStateModelRepresentation(clusterName, modelName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getStateModelRepresentation(String clusterName, String modelName) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
        String message = ClusterRepresentationUtil.getClusterPropertyAsString(zkClient, clusterName, keyBuilder.stateModelDef(modelName), MediaType.APPLICATION_JSON);
        StringRepresentation representation = new StringRepresentation((CharSequence)message, MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation post(Representation entity) {
        try {
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            String modelName = (String)this.getRequest().getAttributes().get("modelName");
            ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
            JsonParameters jsonParameters = new JsonParameters(entity);
            String command = jsonParameters.getCommand();
            if (!command.equalsIgnoreCase("addStateModelDef")) {
                throw new HelixException("Unsupported command: " + command + ". Should be one of [" + "addStateModelDef" + "]");
            }
            ZNRecord newStateModel = jsonParameters.getExtraParameter("newStateModelDef");
            HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
            accessor.setProperty(accessor.keyBuilder().stateModelDef(newStateModel.getId()), (HelixProperty)new StateModelDefinition(newStateModel));
            this.getResponse().setEntity((Representation)this.getStateModelRepresentation(clusterName, modelName));
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in posting " + entity, (Throwable)e);
        }
        return null;
    }
}

