/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.data.Form;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtil.class);
    private static final String EMPTY_ZNRECORD_STRING = ResourceUtil.objectToJson(ClusterRepresentationUtil.EMPTY_ZNRECORD);
    private static ObjectMapper mapper = new ObjectMapper();

    private static String objectToJson(Object object) {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue((Writer)sw, object);
        }
        catch (JsonGenerationException jsonGenerationException) {
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    public static String getAttributeFromRequest(Request r, RequestKey key) {
        return (String)r.getAttributes().get(key.toString());
    }

    public static ZkClient getAttributeFromCtx(Context ctx, ContextKey key) {
        return (ZkClient)ctx.getAttributes().get(key.toString());
    }

    public static String getYamlParameters(Form form, YamlParamKey key) {
        return form.getFirstValue(key.toString());
    }

    public static String readZkAsBytes(ZkClient zkclient, PropertyKey propertyKey) {
        try {
            byte[] bytes = (byte[])zkclient.readData(propertyKey.getPath());
            return new String(bytes);
        }
        catch (Exception e) {
            String errorMessage = "Exception occurred when reading data from path: " + propertyKey.getPath();
            LOG.error(errorMessage, (Throwable)e);
            throw new HelixException(errorMessage, (Throwable)e);
        }
    }

    static String extractSimpleFieldFromZNRecord(String recordStr, String key) {
        int idx2;
        int idx = recordStr.indexOf(key);
        if (idx != -1 && (idx = recordStr.indexOf(34, idx + key.length() + 1)) != -1 && (idx2 = recordStr.indexOf(34, idx + 1)) != -1) {
            return recordStr.substring(idx + 1, idx2);
        }
        return null;
    }

    public static Map<String, String> readZkChildrenAsBytesMap(ZkClient zkclient, PropertyKey propertyKey) {
        ZkBaseDataAccessor baseAccessor = new ZkBaseDataAccessor((RealmAwareZkClient)zkclient);
        String parentPath = propertyKey.getPath();
        List childNames = baseAccessor.getChildNames(parentPath, 0);
        if (childNames == null) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String childName : childNames) {
            paths.add(parentPath + "/" + childName);
        }
        List values = baseAccessor.get(paths, null, 0);
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < childNames.size(); ++i) {
            ret.put((String)childNames.get(i), new String((byte[])values.get(i)));
        }
        return ret;
    }

    public static enum YamlParamKey {
        NEW_JOB("newJob");

        private final String _key;

        private YamlParamKey(String key) {
            this._key = key;
        }

        public String toString() {
            return this._key;
        }
    }

    public static enum ContextKey {
        ZK_ADDR("zkSvr"),
        ZKCLIENT("zkClient"),
        RAW_ZKCLIENT("rawZkClient");

        private final String _key;

        private ContextKey(String key) {
            this._key = key;
        }

        public String toString() {
            return this._key;
        }
    }

    public static enum RequestKey {
        CLUSTER_NAME("clusterName"),
        JOB_QUEUE("jobQueue"),
        JOB("job"),
        CONSTRAINT_TYPE("constraintType"),
        CONSTRAINT_ID("constraintId"),
        RESOURCE_NAME("resourceName"),
        INSTANCE_NAME("instanceName");

        private final String _key;

        private RequestKey(String key) {
            this._key = key;
        }

        public String toString() {
            return this._key;
        }
    }
}

