"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.app = void 0;
const bodyParser = require("body-parser");
const dotenv = require("dotenv");
const express = require("express");
const morgan = require("morgan");
const path = require("path");
const fs = require("fs");
const http = require("http");
const https = require("https");
const session = require("express-session");
const config_1 = require("./config");
const routes_1 = require("./routes");
const app = express();
exports.app = app;
const server = http.createServer(app);
dotenv.load({ path: '.env' });
app.set('port', (process.env.PORT || 3000));
app.use('/', express.static(path.join(__dirname, '../public')));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));
app.use(session({
    store: config_1.SESSION_STORE,
    secret: 'helix',
    resave: true,
    saveUninitialized: true,
    cookie: { expires: new Date(2147483647000) }
}));
app.use(morgan('dev'));
(0, routes_1.default)(app);
app.get('/*', function (req, res) {
    res.sendFile(path.join(__dirname, '../public/index.html'));
});
server.listen(app.get('port'), () => {
    console.log(`App is listening on port ${app.get('port')} as HTTP`);
});
process.on('uncaughtException', function (err) {
    console.error('uncaughtException: ' + err.message);
    console.error(err.stack);
});
// setup SSL
if (config_1.SSL.port > 0 && fs.existsSync(config_1.SSL.keyfile) && fs.existsSync(config_1.SSL.certfile)) {
    const credentials = {
        key: fs.readFileSync(config_1.SSL.keyfile, 'ascii'),
        cert: fs.readFileSync(config_1.SSL.certfile, 'ascii'),
        ca: []
    };
    if (fs.existsSync(config_1.SSL.passfile)) {
        credentials.passphrase = fs.readFileSync(config_1.SSL.passfile, 'ascii').trim();
    }
    if (config_1.SSL.cafiles) {
        config_1.SSL.cafiles.forEach(cafile => {
            if (fs.existsSync(cafile)) {
                credentials.ca.push(fs.readFileSync(cafile, 'ascii'));
            }
        });
    }
    const httpsServer = https.createServer(credentials, app);
    httpsServer.listen(config_1.SSL.port, () => {
        console.log(`App is listening on port ${config_1.SSL.port} as HTTPS`);
    });
}
//# sourceMappingURL=app.js.map