"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCtrl = void 0;
const LdapClient = require("ldapjs");
const config_1 = require("../config");
class UserCtrl {
    constructor(router) {
        router.route('/user/authorize').get(this.authorize);
        router.route('/user/login').post(this.login.bind(this));
        router.route('/user/current').get(this.current);
        router.route('/user/can').get(this.can);
    }
    authorize(req, res) {
        // you can rewrite this function to support your own authorization logic
        // by default, doing nothing but redirection
        if (req.query.url) {
            res.redirect(req.query.url);
        }
        else {
            res.redirect('/');
        }
    }
    current(req, res) {
        res.json(req.session.username || 'Sign In');
    }
    can(req, res) {
        try {
            return res.json(req.session.isAdmin ? true : false);
        }
        catch (err) {
            // console.log('error from can', err)
            return false;
        }
    }
    login(request, response) {
        const credential = request.body;
        if (!credential.username || !credential.password) {
            response.status(401).json(false);
            return;
        }
        // check LDAP
        const ldap = LdapClient.createClient({ url: config_1.LDAP.uri });
        ldap.bind(credential.username + config_1.LDAP.principalSuffix, credential.password, err => {
            if (err) {
                response.status(401).json(false);
            }
            else {
                // login success
                const opts = {
                    filter: '(&(sAMAccountName=' + credential.username + ')(objectcategory=person))',
                    scope: 'sub'
                };
                ldap.search(config_1.LDAP.base, opts, function (err, result) {
                    let isInAdminGroup = false;
                    result.on('searchEntry', function (entry) {
                        if (entry.object && !err) {
                            const groups = entry.object['memberOf'];
                            for (const group of groups) {
                                const groupName = group.split(',', 1)[0].split('=')[1];
                                if (groupName == config_1.LDAP.adminGroup) {
                                    isInAdminGroup = true;
                                    break;
                                }
                            }
                        }
                        request.session.username = credential.username;
                        request.session.isAdmin = isInAdminGroup;
                        response.json(isInAdminGroup);
                    });
                });
            }
        });
    }
}
exports.UserCtrl = UserCtrl;
//# sourceMappingURL=user.js.map