/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.helix.zookeeper.zkclient.exception.ZkInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkCacheEventThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ZkCacheEventThread.class);
    private final BlockingQueue<ZkCacheEvent> _events = new LinkedBlockingQueue<ZkCacheEvent>();
    private static AtomicInteger _eventId = new AtomicInteger(0);

    ZkCacheEventThread(String name) {
        this.setDaemon(true);
        this.setName("ZkCache-EventThread-" + this.getId() + "-" + name);
    }

    @Override
    public void run() {
        LOG.info("Starting ZkCache event thread.");
        try {
            while (!this.isInterrupted()) {
                ZkCacheEvent zkEvent = this._events.take();
                int eventId = _eventId.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Delivering event #" + eventId + " " + zkEvent);
                }
                try {
                    zkEvent.run();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                catch (ZkInterruptedException e) {
                    this.interrupt();
                }
                catch (ThreadDeath death) {
                    throw death;
                }
                catch (Throwable e) {
                    LOG.error("Error handling event " + zkEvent, e);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Delivering event #" + eventId + " done");
            }
        }
        catch (InterruptedException e) {
            LOG.info("Terminate ZkClient event thread.");
        }
    }

    public void send(ZkCacheEvent event) {
        if (!this.isInterrupted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("New event: " + event);
            }
            this._events.add(event);
        }
    }

    static abstract class ZkCacheEvent {
        private final String _description;

        public ZkCacheEvent(String description) {
            this._description = description;
        }

        public abstract void run() throws Exception;

        public String toString() {
            return "ZkCacheEvent[" + this._description + "]";
        }
    }
}

