/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.helix.model.IdealState;
import org.apache.helix.tools.RUSHrHash;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class IdealStateCalculatorByRush {
    static HashMap<String, Object> buildRushConfig(int numClusters, List<List<String>> instancesPerCluster, int replicationDegree, List<Integer> clusterWeights) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("replicationDegree", replicationDegree);
        HashMap[] clusterList = new HashMap[numClusters];
        config.put("subClusters", clusterList);
        for (int n = 0; n < numClusters; ++n) {
            int numNodes = instancesPerCluster.get(n).size();
            HashMap[] nodes = new HashMap[numNodes];
            for (int i = 0; i < numNodes; ++i) {
                HashMap<String, String> node = new HashMap<String, String>();
                node.put("partition", instancesPerCluster.get(n).get(i));
                nodes[i] = node;
            }
            HashMap<String, Object> clusterData = new HashMap<String, Object>();
            clusterData.put("weight", clusterWeights.get(n));
            clusterData.put("nodes", nodes);
            clusterList[n] = clusterData;
        }
        return config;
    }

    public static ZNRecord calculateIdealState(List<List<String>> instanceClusters, List<Integer> instanceClusterWeights, int partitions, int replicas, String resourceName) throws Exception {
        ZNRecord result = new ZNRecord(resourceName);
        int numberOfClusters = instanceClusters.size();
        List<List<String>> nodesInClusters = instanceClusters;
        List<Integer> clusterWeights = instanceClusterWeights;
        HashMap<String, Object> rushConfig = IdealStateCalculatorByRush.buildRushConfig(numberOfClusters, nodesInClusters, replicas + 1, clusterWeights);
        RUSHrHash rushHash = new RUSHrHash(rushConfig);
        Random r = new Random(0L);
        for (int i = 0; i < partitions; ++i) {
            int partitionId = i;
            String partitionName = resourceName + ".partition-" + partitionId;
            ArrayList<HashMap> partitionAssignmentResult = rushHash.findNode(i);
            ArrayList<String> nodeNames = new ArrayList<String>();
            for (HashMap p : partitionAssignmentResult) {
                for (Object key : p.keySet()) {
                    if (!(p.get(key) instanceof String)) continue;
                    nodeNames.add(p.get(key).toString());
                }
            }
            TreeMap<String, String> partitionAssignment = new TreeMap<String, String>();
            for (int j = 0; j < nodeNames.size(); ++j) {
                partitionAssignment.put((String)nodeNames.get(j), "SLAVE");
            }
            int master = r.nextInt(nodeNames.size());
            partitionAssignment.put((String)nodeNames.get(master), "MASTER");
            result.setMapField(partitionName, partitionAssignment);
        }
        result.setSimpleField(IdealState.IdealStateProperty.NUM_PARTITIONS.toString(), String.valueOf(partitions));
        return result;
    }

    public static ZNRecord calculateIdealState(List<String> instanceClusters, int instanceClusterWeight, int partitions, int replicas, String resourceName) throws Exception {
        ArrayList<List<String>> instanceClustersList = new ArrayList<List<String>>();
        instanceClustersList.add(instanceClusters);
        ArrayList<Integer> instanceClusterWeightList = new ArrayList<Integer>();
        instanceClusterWeightList.add(instanceClusterWeight);
        return IdealStateCalculatorByRush.calculateIdealState(instanceClustersList, instanceClusterWeightList, partitions, replicas, resourceName);
    }

    public static void printDiff(ZNRecord record1, ZNRecord record2) {
        int diffCount = 0;
        int diffCountMaster = 0;
        for (String key : record1.getMapFields().keySet()) {
            Map<String, String> map1 = record1.getMapField(key);
            Map<String, String> map2 = record2.getMapField(key);
            for (String k : map1.keySet()) {
                if (!map2.containsKey(k)) {
                    ++diffCount;
                    continue;
                }
                if (map1.get(k).equalsIgnoreCase(map2.get(k))) continue;
                ++diffCountMaster;
            }
        }
        System.out.println("\ndiff count = " + diffCount);
        System.out.println("\nmaster diff count:" + diffCountMaster);
    }

    public static void printIdealStateStats(ZNRecord record) {
        TreeMap<String, Integer> countsMap = new TreeMap<String, Integer>();
        TreeMap<String, Integer> masterCountsMap = new TreeMap<String, Integer>();
        for (String key : record.getMapFields().keySet()) {
            Map<String, String> map1 = record.getMapField(key);
            for (String string : map1.keySet()) {
                if (!countsMap.containsKey(string)) {
                    countsMap.put(string, new Integer(0));
                } else {
                    countsMap.put(string, (Integer)countsMap.get(string) + 1);
                }
                if (!masterCountsMap.containsKey(string)) {
                    masterCountsMap.put(string, new Integer(0));
                    continue;
                }
                if (!map1.get(string).equalsIgnoreCase("MASTER")) continue;
                masterCountsMap.put(string, (Integer)masterCountsMap.get(string) + 1);
            }
        }
        double sum = 0.0;
        int maxCount = 0;
        int minCount = Integer.MAX_VALUE;
        for (String k : countsMap.keySet()) {
            int count = (Integer)countsMap.get(k);
            sum += (double)count;
            if (maxCount < count) {
                maxCount = count;
            }
            if (minCount > count) {
                minCount = count;
            }
            System.out.print(count + " ");
        }
        System.out.println("\nMax count: " + maxCount + " min count:" + minCount);
        System.out.println("\n master:");
        double d = 0.0;
        int maxCountMaster = 0;
        int minCountMaster = Integer.MAX_VALUE;
        for (String k : masterCountsMap.keySet()) {
            int count = (Integer)masterCountsMap.get(k);
            d += (double)count;
            if (maxCountMaster < count) {
                maxCountMaster = count;
            }
            if (minCountMaster > count) {
                minCountMaster = count;
            }
            System.out.print(count + " ");
        }
        System.out.println("\nMean master: " + 1.0 * d / (double)countsMap.size());
        System.out.println("Max master count: " + maxCountMaster + " min count:" + minCountMaster);
        double mean = sum / (double)countsMap.size();
        double deviation = 0.0;
        for (String k : countsMap.keySet()) {
            double count = ((Integer)countsMap.get(k)).intValue();
            deviation += (count - mean) * (count - mean);
        }
        System.out.println("Mean: " + mean + " normal deviation:" + Math.sqrt(deviation / (double)countsMap.size()) / mean);
        int steps = 10;
        int stepLen = (maxCount - minCount) / steps;
        if (stepLen == 0) {
            return;
        }
        ArrayList<Integer> histogram = new ArrayList<Integer>((maxCount - minCount) / stepLen + 1);
        for (int i = 0; i < (maxCount - minCount) / stepLen + 1; ++i) {
            histogram.add(0);
        }
        for (String k : countsMap.keySet()) {
            int count = (Integer)countsMap.get(k);
            int stepNo = (count - minCount) / stepLen;
            histogram.set(stepNo, (Integer)histogram.get(stepNo) + 1);
        }
        System.out.println("histogram:");
        for (Integer x : histogram) {
            System.out.print(x + " ");
        }
    }

    public static void main(String[] args) throws Exception {
        int partitions = 4096;
        int replicas = 2;
        String resourceName = "espressoDB1";
        ArrayList<String> instanceNames = new ArrayList<String>();
        ArrayList<List<String>> instanceCluster1 = new ArrayList<List<String>>();
        for (int i = 0; i < 20; ++i) {
            instanceNames.add("local" + i + "host_123" + i);
        }
        instanceCluster1.add(instanceNames);
        ArrayList<Integer> weights1 = new ArrayList<Integer>();
        weights1.add(1);
        ZNRecord result = IdealStateCalculatorByRush.calculateIdealState(instanceCluster1, weights1, partitions, replicas, resourceName);
        IdealStateCalculatorByRush.printIdealStateStats(result);
        ArrayList<String> instanceNames2 = new ArrayList<String>();
        for (int i = 400; i < 405; ++i) {
            instanceNames2.add("localhost_123" + i);
        }
        instanceCluster1.add(instanceNames2);
        weights1.add(1);
        ZNRecord result2 = IdealStateCalculatorByRush.calculateIdealState(instanceCluster1, weights1, partitions, replicas, resourceName);
        IdealStateCalculatorByRush.printDiff(result, result2);
        IdealStateCalculatorByRush.printIdealStateStats(result2);
    }
}

