ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(m,E,U){"use strict";var R=m("./lib/dom"),_=m("./lib/oop"),M=m("./lib/event_emitter").EventEmitter,C=m("./lib/lang"),b=m("./range").Range,T=m("./range_list").RangeList,S=m("./keyboard/hash_handler").HashHandler,L=m("./tokenizer").Tokenizer,O=m("./clipboard"),N={CURRENT_WORD:function(o){return o.session.getTextRange(o.session.getWordRange())},SELECTION:function(o,t,e){var n=o.session.getTextRange();return e?n.replace(/\n\r?([ \t]*\S)/g,"\n"+e+"$1"):n},CURRENT_LINE:function(o){return o.session.getLine(o.getCursorPosition().row)},PREV_LINE:function(o){return o.session.getLine(o.getCursorPosition().row-1)},LINE_INDEX:function(o){return o.getCursorPosition().row},LINE_NUMBER:function(o){return o.getCursorPosition().row+1},SOFT_TABS:function(o){return o.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(o){return o.session.getTabSize()},CLIPBOARD:function(o){return O.getText&&O.getText()},FILENAME:function(o){return/[^/\\]*$/.exec(this.FILEPATH(o))[0]},FILENAME_BASE:function(o){return/[^/\\]*$/.exec(this.FILEPATH(o))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(o){return this.FILEPATH(o).replace(/[^/\\]*$/,"")},FILEPATH:function(o){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(o){var t=o.session.$mode||{};return t.blockComment&&t.blockComment.start||""},BLOCK_COMMENT_END:function(o){var t=o.session.$mode||{};return t.blockComment&&t.blockComment.end||""},LINE_COMMENT:function(o){return(o.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:x.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:x.bind(null,{year:"2-digit"}),CURRENT_MONTH:x.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:x.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:x.bind(null,{month:"short"}),CURRENT_DATE:x.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:x.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:x.bind(null,{weekday:"short"}),CURRENT_HOUR:x.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:x.bind(null,{minute:"2-digit"}),CURRENT_SECOND:x.bind(null,{second:"2-digit"})};function x(o){var t=(new Date).toLocaleString("en-us",o);return 1==t.length?"0"+t:t}N.SELECTED_TEXT=N.SELECTION;var $=function(){function o(){this.snippetMap={},this.snippetNameMap={},this.variables=N}return o.prototype.getTokenizer=function(){return o.$tokenizer||this.createTokenizer()},o.prototype.createTokenizer=function(){function t(i){return i=i.substr(1),/^\d+$/.test(i)?[{tabstopId:parseInt(i,10)}]:[{text:i}]}function e(i){return"(?:[^\\\\"+i+"]|\\\\.)"}var n={regex:"/("+e("/")+"+)/",onMatch:function(i,a,l){var s=l[0];return s.fmtString=!0,s.guard=i.slice(1,-1),s.flag="",""},next:"formatString"};return o.$tokenizer=new L({start:[{regex:/\\./,onMatch:function(i,a,l){var s=i[1];return("}"==s&&l.length||-1!="`$\\".indexOf(s))&&(i=s),[i]}},{regex:/}/,onMatch:function(i,a,l){return[l.length?l.shift():i]}},{regex:/\$(?:\d+|\w+)/,onMatch:t},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(i,a,l){var s=t(i.substr(1));return l.unshift(s[0]),s},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+e("\\|")+"*\\|",onMatch:function(i,a,l){var s=i.slice(1,-1).replace(/\\[,|\\]|,/g,function(d){return 2==d.length?d[1]:"\0"}).split("\0").map(function(d){return{value:d}});return l[0].choices=s,[s[0]]},next:"start"},n,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(i,a,l){return l.length&&l[0].expectElse?(l[0].expectElse=!1,l[0].ifEnd={elseEnd:l[0]},[l[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(i,a,l){var s=i[1];return"}"==s&&l.length||-1!="`$\\".indexOf(s)?i=s:"n"==s?i="\n":"t"==s?i="\t":-1!="ulULE".indexOf(s)&&(i={changeCase:s,local:s>"a"}),[i]}},{regex:"/\\w*}",onMatch:function(i,a,l){var s=l.shift();return s&&(s.flag=i.slice(1,-1)),this.next=s&&s.tabstopId?"start":"",[s||i]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(i,a,l){return[{text:i.slice(1)}]}},{regex:/\${\w+/,onMatch:function(i,a,l){var s={text:i.slice(2)};return l.unshift(s),[s]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(i,a,l){var s=l.shift();return this.next=s&&s.tabstopId?"start":"",[s||i]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(i,a,l){return l[0].formatFunction=i.slice(2,-1),[l.shift()]},next:"formatString"},n,{regex:/:[\?\-+]?/,onMatch:function(i,a,l){"+"==i[1]&&(l[0].ifEnd=l[0]),"?"==i[1]&&(l[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},o.prototype.tokenizeTmSnippet=function(t,e){return this.getTokenizer().getLineTokens(t,e).tokens.map(function(n){return n.value||n})},o.prototype.getVariableValue=function(t,e,n){if(/^\d+$/.test(e))return(this.variables.__||{})[e]||"";if(/^[A-Z]\d+$/.test(e))return(this.variables[e[0]+"__"]||{})[e.substr(1)]||"";if(e=e.replace(/^TM_/,""),!this.variables.hasOwnProperty(e))return"";var i=this.variables[e];return"function"==typeof i&&(i=this.variables[e](t,e,n)),null==i?"":i},o.prototype.tmStrFormat=function(t,e,n){if(!e.fmt)return t;var a=e.guard;a=new RegExp(a,(e.flag||"").replace(/[^gim]/g,""));var l="string"==typeof e.fmt?this.tokenizeTmSnippet(e.fmt,"formatString"):e.fmt,s=this,d=t.replace(a,function(){var u=s.variables.__;s.variables.__=[].slice.call(arguments);for(var g=s.resolveVariables(l,n),f="E",y=0;y<g.length;y++){var v=g[y];if("object"==typeof v)if(g[y]="",v.changeCase&&v.local){var w=g[y+1];w&&"string"==typeof w&&(g[y]="u"==v.changeCase?w[0].toUpperCase():w[0].toLowerCase(),g[y+1]=w.substr(1))}else v.changeCase&&(f=v.changeCase);else"U"==f?g[y]=v.toUpperCase():"L"==f&&(g[y]=v.toLowerCase())}return s.variables.__=u,g.join("")});return d},o.prototype.tmFormatFunction=function(t,e,n){return"upcase"==e.formatFunction?t.toUpperCase():"downcase"==e.formatFunction?t.toLowerCase():t},o.prototype.resolveVariables=function(t,e){for(var n=[],i="",a=!0,l=0;l<t.length;l++){var s=t[l];if("string"!=typeof s){if(s){if(a=!1,s.fmtString){var d=t.indexOf(s,l+1);-1==d&&(d=t.length),s.fmt=t.slice(l+1,d),l=d}if(s.text){var u=this.getVariableValue(e,s.text,i)+"";s.fmtString&&(u=this.tmStrFormat(u,s,e)),s.formatFunction&&(u=this.tmFormatFunction(u,s,e)),u&&!s.ifEnd?(n.push(u),g(s)):!u&&s.ifEnd&&g(s.ifEnd)}else s.elseEnd?g(s.elseEnd):(null!=s.tabstopId||null!=s.changeCase)&&n.push(s)}}else n.push(s),"\n"==s?(a=!0,i=""):a&&(i=/^\t*/.exec(s)[0],a=/\S/.test(s))}function g(f){var y=t.indexOf(f,l+1);-1!=y&&(l=y)}return n},o.prototype.getDisplayTextForSnippet=function(t,e){return A.call(this,t,e).text},o.prototype.insertSnippetForSelection=function(t,e,n){void 0===n&&(n={});var i=A.call(this,t,e,n),a=t.getSelectionRange();n.range&&0===n.range.compareRange(a)&&(a=n.range);var l=t.session.replace(a,i.text);new r(t).addTabstops(i.tabstops,a.start,l,t.inVirtualSelectionMode&&t.selection.index)},o.prototype.insertSnippet=function(t,e,n){void 0===n&&(n={});var i=this;if(n.range&&!(n.range instanceof b)&&(n.range=b.fromPoints(n.range.start,n.range.end)),t.inVirtualSelectionMode)return i.insertSnippetForSelection(t,e,n);t.forEachSelection(function(){i.insertSnippetForSelection(t,e,n)},null,{keepOrder:!0}),t.tabstopManager&&t.tabstopManager.tabNext()},o.prototype.$getScope=function(t){var e=t.session.$mode.$id||"";if("html"===(e=e.split("/").pop())||"php"===e){"php"===e&&!t.session.$mode.inlinePhp&&(e="html");var n=t.getCursorPosition(),i=t.session.getState(n.row);"object"==typeof i&&(i=i[0]),i.substring&&("js-"==i.substring(0,3)?e="javascript":"css-"==i.substring(0,4)?e="css":"php-"==i.substring(0,4)&&(e="php"))}return e},o.prototype.getActiveScopes=function(t){var e=this.$getScope(t),n=[e],i=this.snippetMap;return i[e]&&i[e].includeScopes&&n.push.apply(n,i[e].includeScopes),n.push("_"),n},o.prototype.expandWithTab=function(t,e){var n=this,i=t.forEachSelection(function(){return n.expandSnippetForSelection(t,e)},null,{keepOrder:!0});return i&&t.tabstopManager&&t.tabstopManager.tabNext(),i},o.prototype.expandSnippetForSelection=function(t,e){var d,n=t.getCursorPosition(),i=t.session.getLine(n.row),a=i.substring(0,n.column),l=i.substr(n.column),s=this.snippetMap;return this.getActiveScopes(t).some(function(u){var g=s[u];return g&&(d=this.findMatchingSnippet(g,a,l)),!!d},this),!!d&&(e&&e.dryRun||(t.session.doc.removeInLine(n.row,n.column-d.replaceBefore.length,n.column+d.replaceAfter.length),this.variables.M__=d.matchBefore,this.variables.T__=d.matchAfter,this.insertSnippetForSelection(t,d.content),this.variables.M__=this.variables.T__=null),!0)},o.prototype.findMatchingSnippet=function(t,e,n){for(var i=t.length;i--;){var a=t[i];if((!a.startRe||a.startRe.test(e))&&(!a.endRe||a.endRe.test(n))&&(a.startRe||a.endRe))return a.matchBefore=a.startRe?a.startRe.exec(e):[""],a.matchAfter=a.endRe?a.endRe.exec(n):[""],a.replaceBefore=a.triggerRe?a.triggerRe.exec(e)[0]:"",a.replaceAfter=a.endTriggerRe?a.endTriggerRe.exec(n)[0]:"",a}},o.prototype.register=function(t,e){var n=this.snippetMap,i=this.snippetNameMap,a=this;function l(u){return u&&!/^\^?\(.*\)\$?$|^\\b$/.test(u)&&(u="(?:"+u+")"),u||""}function s(u,g,f){return u=l(u),g=l(g),f?(u=g+u)&&"$"!=u[u.length-1]&&(u+="$"):(u+=g)&&"^"!=u[0]&&(u="^"+u),new RegExp(u)}function d(u){u.scope||(u.scope=e||"_"),n[e=u.scope]||(n[e]=[],i[e]={});var g=i[e];if(u.name){var f=g[u.name];f&&a.unregister(f),g[u.name]=u}n[e].push(u),u.prefix&&(u.tabTrigger=u.prefix),!u.content&&u.body&&(u.content=Array.isArray(u.body)?u.body.join("\n"):u.body),u.tabTrigger&&!u.trigger&&(!u.guard&&/^\w/.test(u.tabTrigger)&&(u.guard="\\b"),u.trigger=C.escapeRegExp(u.tabTrigger)),(u.trigger||u.guard||u.endTrigger||u.endGuard)&&(u.startRe=s(u.trigger,u.guard,!0),u.triggerRe=new RegExp(u.trigger),u.endRe=s(u.endTrigger,u.endGuard,!0),u.endTriggerRe=new RegExp(u.endTrigger))}t||(t=[]),Array.isArray(t)?t.forEach(d):Object.keys(t).forEach(function(u){d(t[u])}),this._signal("registerSnippets",{scope:e})},o.prototype.unregister=function(t,e){var n=this.snippetMap,i=this.snippetNameMap;function a(l){var s=i[l.scope||e];if(s&&s[l.name]){delete s[l.name];var d=n[l.scope||e],u=d&&d.indexOf(l);u>=0&&d.splice(u,1)}}t.content?a(t):Array.isArray(t)&&t.forEach(a)},o.prototype.parseSnippetFile=function(t){t=t.replace(/\r/g,"");for(var a,e=[],n={},i=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;a=i.exec(t);){if(a[1])try{n=JSON.parse(a[1]),e.push(n)}catch(u){}if(a[4])n.content=a[4].replace(/^\t/gm,""),e.push(n),n={};else{var l=a[2],s=a[3];if("regex"==l){var d=/\/((?:[^\/\\]|\\.)*)|$/g;n.guard=d.exec(s)[1],n.trigger=d.exec(s)[1],n.endTrigger=d.exec(s)[1],n.endGuard=d.exec(s)[1]}else"snippet"==l?(n.tabTrigger=s.match(/^\S*/)[0],n.name||(n.name=s)):l&&(n[l]=s)}}return e},o.prototype.getSnippetByName=function(t,e){var i,n=this.snippetNameMap;return this.getActiveScopes(e).some(function(a){var l=n[a];return l&&(i=l[t]),!!i},this),i},o}();_.implement($.prototype,M);var A=function(o,t,e){void 0===e&&(e={});var n=o.getCursorPosition(),i=o.session.getLine(n.row),a=o.session.getTabString(),l=i.match(/^\s*/)[0];n.column<l.length&&(l=l.slice(0,n.column)),t=t.replace(/\r/g,"");var s=this.tokenizeTmSnippet(t);s=(s=this.resolveVariables(s,o)).map(function(k){return"\n"!=k||e.excludeExtraIndent?"string"==typeof k?k.replace(/\t/g,a):k:k+l});var d=[];s.forEach(function(k,D){if("object"==typeof k){var z=k.tabstopId,P=d[z];if(P||((P=d[z]=[]).index=z,P.value="",P.parents={}),-1===P.indexOf(k)){k.choices&&!P.choices&&(P.choices=k.choices),P.push(k);var V=s.indexOf(k,D+1);if(-1!==V){var W=s.slice(D+1,V);W.some(function(Z){return"object"==typeof Z})&&!P.value?P.value=W:W.length&&(!P.value||"string"!=typeof P.value)&&(P.value=W.join(""))}}}}),d.forEach(function(k){k.length=0});var u={};function g(k){for(var D=[],z=0;z<k.length;z++){var P=k[z];if("object"==typeof P){if(u[P.tabstopId])continue;P=D[k.lastIndexOf(P,z-1)]||{tabstopId:P.tabstopId}}D[z]=P}return D}for(var f=0;f<s.length;f++){var y=s[f];if("object"==typeof y){var v=y.tabstopId,w=d[v],H=s.indexOf(y,f+1);if(u[v]){u[v]===y&&(delete u[v],Object.keys(u).forEach(function(k){w.parents[k]=!0}));continue}u[v]=y;var I=w.value;"string"!=typeof I?I=g(I):y.fmt&&(I=this.tmStrFormat(I,y,o)),s.splice.apply(s,[f+1,Math.max(0,H-f)].concat(I,y)),-1===w.indexOf(y)&&w.push(y)}}var F=0,B=0,j="";return s.forEach(function(k){if("string"==typeof k){var D=k.split("\n");D.length>1?(B=D[D.length-1].length,F+=D.length-1):B+=k.length,j+=k}else k&&(k.start?k.end={row:F,column:B}:k.start={row:F,column:B})}),{text:j,tabstops:d,tokens:s}},r=function(){function o(t){if(this.index=0,this.ranges=[],this.tabstops=[],t.tabstopManager)return t.tabstopManager;t.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=C.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(t)}return o.prototype.attach=function(t){this.$openTabstops=null,this.selectedTabstop=null,this.editor=t,this.session=t.session,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},o.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges.length=0,this.tabstops.length=0,this.selectedTabstop=null,this.editor.off("change",this.$onChange),this.editor.off("changeSelection",this.$onChangeSelection),this.editor.off("changeSession",this.$onChangeSession),this.editor.commands.off("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.session=null,this.editor=null},o.prototype.onChange=function(t){for(var e="r"==t.action[0],n=this.selectedTabstop||{},i=n.parents||{},a=this.tabstops.slice(),l=0;l<a.length;l++){var s=a[l];if(s.rangeList.$bias=s==n||i[s.index]?0:1,"remove"==t.action&&s!==n){var u=s.parents&&s.parents[n.index],g=s.rangeList.pointIndex(t.start,u);g=g<0?-g-1:g+1;for(var f=s.rangeList.pointIndex(t.end,u),y=s.rangeList.ranges.slice(g,f=f<0?-f-1:f-1),v=0;v<y.length;v++)this.removeRange(y[v])}s.rangeList.$onChange(t)}var w=this.session;!this.$inChange&&e&&1==w.getLength()&&!w.getValue()&&this.detach()},o.prototype.updateLinkedFields=function(){var t=this.selectedTabstop;if(t&&t.hasLinkedRanges&&t.firstNonLinked){this.$inChange=!0;for(var e=this.session,n=e.getTextRange(t.firstNonLinked),i=0;i<t.length;i++){var a=t[i];if(a.linked){var s=E.snippetManager.tmStrFormat(n,a.original,this.editor);e.replace(a,s)}}this.$inChange=!1}},o.prototype.onAfterExec=function(t){t.command&&!t.command.readOnly&&this.updateLinkedFields()},o.prototype.onChangeSelection=function(){if(this.editor){for(var t=this.editor.selection.lead,e=this.editor.selection.anchor,n=this.editor.selection.isEmpty(),i=0;i<this.ranges.length;i++)if(!this.ranges[i].linked){var a=this.ranges[i].contains(t.row,t.column),l=n||this.ranges[i].contains(e.row,e.column);if(a&&l)return}this.detach()}},o.prototype.onChangeSession=function(){this.detach()},o.prototype.tabNext=function(t){var e=this.tabstops.length,n=this.index+(t||1);(n=Math.min(Math.max(n,1),e))==e&&(n=0),this.selectTabstop(n),0===n&&this.detach()},o.prototype.selectTabstop=function(t){this.$openTabstops=null;var e=this.tabstops[this.index];if(e&&this.addTabstopMarkers(e),this.index=t,(e=this.tabstops[this.index])&&e.length){this.selectedTabstop=e;var n=e.firstNonLinked||e;if(e.choices&&(n.cursor=n.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(n);else{var i=this.editor.multiSelect;i.toSingleRange(n);for(var a=0;a<e.length;a++)e.hasLinkedRanges&&e[a].linked||i.addRange(e[a].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},o.prototype.addTabstops=function(t,e,n){var i=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!t[0]){var a=b.fromPoints(n,n);h(a.start,e),h(a.end,e),t[0]=[a],t[0].index=0}var s=[this.index+1,0],d=this.ranges;t.forEach(function(u,g){for(var f=this.$openTabstops[g]||u,y=0;y<u.length;y++){var v=u[y],w=b.fromPoints(v.start,v.end||v.start);c(w.start,e),c(w.end,e),w.original=v,w.tabstop=f,d.push(w),f!=u?f.unshift(w):f[y]=w,v.fmtString||f.firstNonLinked&&i?(w.linked=!0,f.hasLinkedRanges=!0):f.firstNonLinked||(f.firstNonLinked=w)}f.firstNonLinked||(f.hasLinkedRanges=!1),f===u&&(s.push(f),this.$openTabstops[g]=f),this.addTabstopMarkers(f),f.rangeList=f.rangeList||new T,f.rangeList.$bias=0,f.rangeList.addList(f)},this),s.length>2&&(this.tabstops.length&&s.push(s.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,s))},o.prototype.addTabstopMarkers=function(t){var e=this.session;t.forEach(function(n){n.markerId||(n.markerId=e.addMarker(n,"ace_snippet-marker","text"))})},o.prototype.removeTabstopMarkers=function(t){var e=this.session;t.forEach(function(n){e.removeMarker(n.markerId),n.markerId=null})},o.prototype.removeRange=function(t){var e=t.tabstop.indexOf(t);-1!=e&&t.tabstop.splice(e,1),-1!=(e=this.ranges.indexOf(t))&&this.ranges.splice(e,1),-1!=(e=t.tabstop.rangeList.ranges.indexOf(t))&&t.tabstop.splice(e,1),this.session.removeMarker(t.markerId),t.tabstop.length||(-1!=(e=this.tabstops.indexOf(t.tabstop))&&this.tabstops.splice(e,1),this.tabstops.length||this.detach())},o}();r.prototype.keyboardHandler=new S,r.prototype.keyboardHandler.bindKeys({Tab:function(o){E.snippetManager&&E.snippetManager.expandWithTab(o)||(o.tabstopManager.tabNext(1),o.renderer.scrollCursorIntoView())},"Shift-Tab":function(o){o.tabstopManager.tabNext(-1),o.renderer.scrollCursorIntoView()},Esc:function(o){o.tabstopManager.detach()}});var c=function(o,t){0==o.row&&(o.column+=t.column),o.row+=t.row},h=function(o,t){o.row==t.row&&(o.column-=t.column),o.row-=t.row};R.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),E.snippetManager=new $;var p=m("./editor").Editor;(function(){this.insertSnippet=function(o,t){return E.snippetManager.insertSnippet(this,o,t)},this.expandSnippet=function(o){return E.snippetManager.expandWithTab(this,o)}}).call(p.prototype)}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets"],function(m,E,U){"use strict";var R=m("../snippets").snippetManager,_=function(){function M(){this.editor=null}return M.prototype.show=function(C,b,T){if(T=T||"",C&&this.editor&&this.editor!==C&&(this.hide(),this.editor=null),!C||!b)return!1;var S=b.snippet?R.getDisplayTextForSnippet(C,b.snippet):b.value;return!(!S||!S.startsWith(T)||(this.editor=C,""===(S=S.slice(T.length))?C.removeGhostText():C.setGhostText(S),0))},M.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},M.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},M.prototype.destroy=function(){this.hide(),this.editor=null},M}();E.AceInline=_}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config"],function(m,E,U){"use strict";var R=m("../virtual_renderer").VirtualRenderer,_=m("../editor").Editor,M=m("../range").Range,C=m("../lib/event"),b=m("../lib/lang"),T=m("../lib/dom"),S=m("../config").nls,L=function(x){return"suggest-aria-id:".concat(x)},O=function(x){var $=new R(x);$.$maxLines=4;var A=new _($);return A.setHighlightActiveLine(!1),A.setShowPrintMargin(!1),A.renderer.setShowGutter(!1),A.renderer.setHighlightGutterLine(!1),A.$mouseHandler.$focusTimeout=0,A.$highlightTagPending=!0,A};T.importCssString("\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin-left: 0.9em;\n}\n.ace_completion-message {\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete .ace_line {\n    display: flex;\n    align-items: center;\n}\n.ace_autocomplete .ace_line > * {\n    min-width: 0;\n    flex: 0 0 auto;\n}\n.ace_autocomplete .ace_line .ace_ {\n    flex: 0 1 auto;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n.ace_autocomplete .ace_completion-spacer {\n    flex: 1;\n}\n","autocompletion.css",!1),E.AcePopup=function x($){var A=T.createElement("div"),r=new O(A);$&&$.appendChild(A),A.style.display="none",r.renderer.content.style.cursor="default",r.renderer.setStyle("ace_autocomplete"),r.renderer.$textLayer.element.setAttribute("role","listbox"),r.renderer.$textLayer.element.setAttribute("aria-label",S("Autocomplete suggestions")),r.renderer.textarea.setAttribute("aria-hidden","true"),r.setOption("displayIndentGuides",!1),r.setOption("dragDelay",150);var c=function(){};r.focus=c,r.$isFocused=!0,r.renderer.$cursorLayer.restartTimer=c,r.renderer.$cursorLayer.element.style.opacity=0,r.renderer.$maxLines=8,r.renderer.$keepTextAreaAtCursor=!1,r.setHighlightActiveLine(!1),r.session.highlight(""),r.session.$searchHighlight.clazz="ace_highlight-marker",r.on("mousedown",function(i){var a=i.getDocumentPosition();r.selection.moveToPosition(a),o.start.row=o.end.row=a.row,i.stop()});var h,p=new M(-1,0,-1,1/0),o=new M(-1,0,-1,1/0);o.id=r.session.addMarker(o,"ace_active-line","fullLine"),r.setSelectOnHover=function(i){i?p.id&&(r.session.removeMarker(p.id),p.id=null):p.id=r.session.addMarker(p,"ace_line-hover","fullLine")},r.setSelectOnHover(!1),r.on("mousemove",function(i){if(h){if(h.x!=i.x||h.y!=i.y){(h=i).scrollTop=r.renderer.scrollTop;var a=h.getDocumentPosition().row;p.start.row!=a&&(p.id||r.setRow(a),e(a))}}else h=i}),r.renderer.on("beforeRender",function(){if(h&&-1!=p.start.row){h.$pos=null;var i=h.getDocumentPosition().row;p.id||r.setRow(i),e(i,!0)}}),r.renderer.on("afterRender",function(){var i=r.getRow(),a=r.renderer.$textLayer,l=a.element.childNodes[i-a.config.firstRow],s=document.activeElement;if(l!==a.selectedNode&&a.selectedNode&&(T.removeCssClass(a.selectedNode,"ace_selected"),s.removeAttribute("aria-activedescendant"),a.selectedNode.removeAttribute("id")),a.selectedNode=l,l){T.addCssClass(l,"ace_selected");var d=L(i);l.id=d,a.element.setAttribute("aria-activedescendant",d),s.setAttribute("aria-activedescendant",d),l.setAttribute("role","option"),l.setAttribute("aria-label",r.getData(i).value),l.setAttribute("aria-setsize",r.data.length),l.setAttribute("aria-posinset",i+1),l.setAttribute("aria-describedby","doc-tooltip")}});var t=function(){e(-1)},e=function(i,a){i!==p.start.row&&(p.start.row=p.end.row=i,a||r.session._emit("changeBackMarker"),r._emit("changeHoverMarker"))};r.getHoveredRow=function(){return p.start.row},C.addListener(r.container,"mouseout",t),r.on("hide",t),r.on("changeSelection",t),r.session.doc.getLength=function(){return r.data.length},r.session.doc.getLine=function(i){var a=r.data[i];return"string"==typeof a?a:a&&a.value||""};var n=r.session.bgTokenizer;return n.$tokenizeRow=function(i){var a=r.data[i],l=[];if(!a)return l;"string"==typeof a&&(a={value:a});var s=a.caption||a.value||a.name;function d(I,F){I&&l.push({type:(a.className||"")+(F||""),value:I})}for(var u=s.toLowerCase(),g=(r.filterText||"").toLowerCase(),f=0,y=0,v=0;v<=g.length;v++)if(v!=y&&(a.matchMask&1<<v||v==g.length)){var w=g.slice(y,v);y=v;var H=u.indexOf(w,f);if(-1==H)continue;d(s.slice(f,H),""),d(s.slice(H,f=H+w.length),"completion-highlight")}return d(s.slice(f,s.length),""),l.push({type:"completion-spacer",value:" "}),a.meta&&l.push({type:"completion-meta",value:a.meta}),a.message&&l.push({type:"completion-message",value:a.message}),l},n.$updateOnChange=c,n.start=c,r.session.$computeWidth=function(){return this.screenWidth=0},r.isOpen=!1,r.isTopdown=!1,r.autoSelect=!0,r.filterText="",r.data=[],r.setData=function(i,a){r.filterText=a||"",r.setValue(b.stringRepeat("\n",i.length),-1),r.data=i||[],r.setRow(0)},r.getData=function(i){return r.data[i]},r.getRow=function(){return o.start.row},r.setRow=function(i){i=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,i)),o.start.row!=i&&(r.selection.clearSelection(),o.start.row=o.end.row=i||0,r.session._emit("changeBackMarker"),r.moveCursorTo(i||0,0),r.isOpen&&r._signal("select"))},r.on("changeSelection",function(){r.isOpen&&r.setRow(r.selection.lead.row),r.renderer.scrollCursorIntoView()}),r.hide=function(){this.container.style.display="none",r.anchorPos=null,r.anchor=null,r.isOpen&&(r.isOpen=!1,this._signal("hide"))},r.tryShow=function(i,a,l,s){if(!s&&r.isOpen&&r.anchorPos&&r.anchor&&r.anchorPos.top===i.top&&r.anchorPos.left===i.left&&r.anchor===l)return!0;var d=this.container,u=window.innerHeight,g=window.innerWidth,f=this.renderer,y=f.$maxLines*a*1.4,v={top:0,bottom:0,left:0},w=u-i.top-3*this.$borderSize-a,H=i.top-3*this.$borderSize;l||(l=H<=w||w>=y?"bottom":"top"),"top"===l?(v.bottom=i.top-this.$borderSize,v.top=v.bottom-y):"bottom"===l&&(v.top=i.top+a+this.$borderSize,v.bottom=v.top+y);var I=v.top>=0&&v.bottom<=u;if(!s&&!I)return!1;f.$maxPixelHeight=I?null:"top"===l?H:w,"top"===l?(d.style.top="",d.style.bottom=u-v.bottom+"px",r.isTopdown=!1):(d.style.top=v.top+"px",d.style.bottom="",r.isTopdown=!0),d.style.display="";var F=i.left;return F+d.offsetWidth>g&&(F=g-d.offsetWidth),d.style.left=F+"px",d.style.right="",r.isOpen||(r.isOpen=!0,this._signal("show"),h=null),r.anchorPos=i,r.anchor=l,!0},r.show=function(i,a,l){this.tryShow(i,a,l?"bottom":void 0,!0)},r.goTo=function(i){var a=this.getRow(),l=this.session.getLength()-1;switch(i){case"up":a=a<=0?l:a-1;break;case"down":a=a>=l?-1:a+1;break;case"start":a=0;break;case"end":a=l}this.setRow(a)},r.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},r.$imageSize=0,r.$borderSize=1,r},E.$singleLineEditor=O,E.getAriaId=L}),ace.define("ace/autocomplete/util",["require","exports","module"],function(m,E,U){"use strict";E.parForEach=function(_,M,C){var b=0,T=_.length;0===T&&C();for(var S=0;S<T;S++)M(_[S],function(L,O){++b===T&&C(L,O)})};var R=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;E.retrievePrecedingIdentifier=function(_,M,C){C=C||R;for(var b=[],T=M-1;T>=0&&C.test(_[T]);T--)b.push(_[T]);return b.reverse().join("")},E.retrieveFollowingIdentifier=function(_,M,C){C=C||R;for(var b=[],T=M;T<_.length&&C.test(_[T]);T++)b.push(_[T]);return b},E.getCompletionPrefix=function(_){var b,M=_.getCursorPosition(),C=_.session.getLine(M.row);return _.completers.forEach(function(T){T.identifierRegexps&&T.identifierRegexps.forEach(function(S){!b&&S&&(b=this.retrievePrecedingIdentifier(C,M.column,S))}.bind(this))}.bind(this)),b||this.retrievePrecedingIdentifier(C,M.column)},E.triggerAutocomplete=function(_){var M=_.getCursorPosition(),T=_.session.getLine(M.row)[0===M.column?0:M.column-1];return _.completers.some(function(S){if(S.triggerCharacters&&Array.isArray(S.triggerCharacters))return S.triggerCharacters.includes(T)})}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config"],function(m,E,U){"use strict";var R=m("./keyboard/hash_handler").HashHandler,_=m("./autocomplete/popup").AcePopup,M=m("./autocomplete/inline").AceInline,C=m("./autocomplete/popup").getAriaId,b=m("./autocomplete/util"),T=m("./lib/lang"),S=m("./lib/dom"),L=m("./snippets").snippetManager,O=m("./config"),N=function(r,c){c.completer&&c.completer.destroy()},x=function(){function r(){this.autoInsert=!1,this.autoSelect=!0,this.autoShown=!1,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new R,this.keyboardHandler.bindKeys(this.commands),this.parentNode=null,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.onLayoutChange=this.onLayoutChange.bind(this),this.changeTimer=T.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=T.delayedCall(this.updateDocTooltip.bind(this),50)}return r.prototype.$init=function(){return this.popup=new _(this.parentNode||document.body||document.documentElement),this.popup.on("click",function(c){this.insertMatch(),c.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupChange.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup},r.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new M,this.inlineRenderer},r.prototype.getPopup=function(){return this.popup||this.$init()},r.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip()},r.prototype.$onPopupChange=function(c){if(this.inlineRenderer&&this.inlineEnabled){var h=c?null:this.popup.getData(this.popup.getRow()),p=b.getCompletionPrefix(this.editor);this.inlineRenderer.show(this.editor,h,p)||this.inlineRenderer.hide(),this.$updatePopupPosition()}this.tooltipTimer.call(null,null)},r.prototype.observeLayoutChanges=function(){if(!this.$elements&&this.editor){window.addEventListener("resize",this.onLayoutChange,{passive:!0}),window.addEventListener("wheel",this.mousewheelListener);for(var c=this.editor.container.parentNode,h=[];c;)h.push(c),c.addEventListener("scroll",this.onLayoutChange,{passive:!0}),c=c.parentNode;this.$elements=h}},r.prototype.unObserveLayoutChanges=function(){var c=this;window.removeEventListener("resize",this.onLayoutChange,{passive:!0}),window.removeEventListener("wheel",this.mousewheelListener),this.$elements&&this.$elements.forEach(function(h){h.removeEventListener("scroll",c.onLayoutChange,{passive:!0})}),this.$elements=null},r.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition(),this.updateDocTooltip()},r.prototype.$updatePopupPosition=function(){var c=this.editor,h=c.renderer,p=h.layerConfig.lineHeight,o=h.$cursorLayer.getPixelPosition(this.base,!0);o.left-=this.popup.getTextLeftOffset();var t=c.container.getBoundingClientRect();o.top+=t.top-h.layerConfig.offset,o.left+=t.left-c.renderer.scrollLeft,o.left+=h.gutterWidth;var e={top:o.top,left:o.left};h.$ghostText&&h.$ghostTextWidget&&this.base.row===h.$ghostText.position.row&&(e.top+=h.$ghostTextWidget.el.offsetHeight),!this.popup.tryShow(e,p,"bottom")&&(this.popup.tryShow(o,p,"top")||this.popup.show(o,p))},r.prototype.openPopup=function(c,h,p){this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:C(this.popup.getRow()),inline:this.inlineEnabled}),c.keyBinding.addKeyboardHandler(this.keyboardHandler),this.popup.setRow(this.autoSelect?0:-1),p?p&&!h&&this.detach():(this.popup.setTheme(c.getTheme()),this.popup.setFontSize(c.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel(),this.observeLayoutChanges()},r.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null,this.unObserveLayoutChanges()},r.prototype.changeListener=function(c){var h=this.editor.selection.lead;(h.row!=this.base.row||h.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},r.prototype.blurListener=function(c){var h=document.activeElement,p=this.editor.textInput.getElement(),o=c.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(c.relatedTarget);h!=p&&h.parentNode!=(this.popup&&this.popup.container)&&!o&&h!=this.tooltipNode&&c.relatedTarget!=p&&this.detach()},r.prototype.mousedownListener=function(c){this.detach()},r.prototype.mousewheelListener=function(c){this.detach()},r.prototype.goTo=function(c){this.popup.goTo(c)},r.prototype.insertMatch=function(c,h){if(c||(c=this.popup.getData(this.popup.getRow())),!c)return!1;if(""===c.value)return this.detach();var p=this.completions,o=this.getCompletionProvider().insertMatch(this.editor,c,p.filterText,h);return this.completions==p&&this.detach(),o},r.prototype.showPopup=function(c,h){this.editor&&this.detach(),this.activated=!0,this.editor=c,c.completer!=this&&(c.completer&&c.completer.detach(),c.completer=this),c.on("changeSelection",this.changeListener),c.on("blur",this.blurListener),c.on("mousedown",this.mousedownListener),c.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,h)},r.prototype.getCompletionProvider=function(){return this.completionProvider||(this.completionProvider=new $),this.completionProvider},r.prototype.gatherCompletions=function(c,h){return this.getCompletionProvider().gatherCompletions(c,h)},r.prototype.updateCompletions=function(c,h){if(c&&this.base&&this.completions){var o=this.editor.getCursorPosition();if((t=this.editor.session.getTextRange({start:this.base,end:o}))==this.completions.filterText)return;return this.completions.setFilter(t),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=t||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,t,c):this.detach()}if(h&&h.matches)return o=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(o.row,o.column),this.base.$insertRight=!0,this.completions=new A(h.matches),this.openPopup(this.editor,"",c);var p=this.editor.getSession(),t=(o=this.editor.getCursorPosition(),b.getCompletionPrefix(this.editor));this.base=p.doc.createAnchor(o.row,o.column-t.length),this.base.$insertRight=!0;var e={exactMatch:this.exactMatch};this.getCompletionProvider().provideCompletions(this.editor,e,function(n,i,a){var l=i.filtered,s=b.getCompletionPrefix(this.editor);if(a){if(!l.length){var d=!this.autoShown&&this.emptyMessage;if("function"==typeof d&&(d=this.emptyMessage(s)),d){var u=[{caption:this.emptyMessage(s),value:""}];return this.completions=new A(u),void this.openPopup(this.editor,s,c)}return this.detach()}if(1==l.length&&l[0].value==s&&!l[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&1==l.length)return this.insertMatch(l[0])}this.completions=i,this.openPopup(this.editor,s,c)}.bind(this))},r.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},r.prototype.updateDocTooltip=function(){var c=this.popup,h=c.data,p=h&&(h[c.getHoveredRow()]||h[c.getRow()]),o=null;if(!p||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var t=this.editor.completers.length,e=0;e<t;e++){var n=this.editor.completers[e];if(n.getDocTooltip&&p.completerId===n.id){o=n.getDocTooltip(p);break}}if(!o&&"string"!=typeof p&&(o=p),"string"==typeof o&&(o={docText:o}),!o||!o.docHTML&&!o.docText)return this.hideDocTooltip();this.showDocTooltip(o)},r.prototype.showDocTooltip=function(c){this.tooltipNode||(this.tooltipNode=S.createElement("div"),this.tooltipNode.style.margin=0,this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this),this.tooltipNode.id="doc-tooltip",this.tooltipNode.setAttribute("role","tooltip"));var h=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(h.isDark?"ace_dark ":"")+(h.cssClass||"");var p=this.tooltipNode;c.docHTML?p.innerHTML=c.docHTML:c.docText&&(p.textContent=c.docText),p.parentNode||this.popup.container.appendChild(this.tooltipNode);var o=this.popup,t=o.container.getBoundingClientRect();p.style.top=o.container.style.top,p.style.bottom=o.container.style.bottom,p.style.display="block",window.innerWidth-t.right<320?t.left<320?o.isTopdown?(p.style.top=t.bottom+"px",p.style.left=t.left+"px",p.style.right="",p.style.bottom=""):(p.style.top=o.container.offsetTop-p.offsetHeight+"px",p.style.left=t.left+"px",p.style.right="",p.style.bottom=""):(p.style.right=window.innerWidth-t.left+"px",p.style.left=""):(p.style.left=t.right+1+"px",p.style.right="")},r.prototype.hideDocTooltip=function(){if(this.tooltipTimer.cancel(),this.tooltipNode){var c=this.tooltipNode;!this.editor.isFocused()&&document.activeElement==c&&this.editor.focus(),this.tooltipNode=null,c.parentNode&&c.parentNode.removeChild(c)}},r.prototype.onTooltipClick=function(c){for(var h=c.target;h&&h!=this.tooltipNode;){if("A"==h.nodeName&&h.href){h.rel="noreferrer",h.target="_blank";break}h=h.parentNode}},r.prototype.destroy=function(){if(this.detach(),this.popup){this.popup.destroy();var c=this.popup.container;c&&c.parentNode&&c.parentNode.removeChild(c)}this.editor&&this.editor.completer==this&&(this.editor.off("destroy",N),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},r}();x.prototype.commands={Up:function(r){r.completer.goTo("up")},Down:function(r){r.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(r){r.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(r){r.completer.goTo("end")},Esc:function(r){r.completer.detach()},Return:function(r){return r.completer.insertMatch()},"Shift-Return":function(r){r.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(r){var c=r.completer.insertMatch();if(c||r.tabstopManager)return c;r.completer.goTo("down")},PageUp:function(r){r.completer.popup.gotoPageUp()},PageDown:function(r){r.completer.popup.gotoPageDown()}},x.for=function(r){return r.completer instanceof x||(r.completer&&(r.completer.destroy(),r.completer=null),O.get("sharedPopups")?(x.$sharedInstance||(x.$sharedInstance=new x),r.completer=x.$sharedInstance):(r.completer=new x,r.once("destroy",N))),r.completer},x.startCommand={name:"startAutocomplete",exec:function(r,c){var h=x.for(r);h.autoInsert=!1,h.autoSelect=!0,h.autoShown=!1,h.showPopup(r,c),h.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var $=function(){function r(){this.active=!0}return r.prototype.insertByIndex=function(c,h,p){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(c,this.completions.filtered[h],p)},r.prototype.insertMatch=function(c,h,p){if(!h)return!1;if(c.startOperation({command:{name:"insertMatch"}}),h.completer&&h.completer.insertMatch)h.completer.insertMatch(c,h);else{if(!this.completions)return!1;if(this.completions.filterText&&!h.range){var o;o=c.selection.getAllRanges?c.selection.getAllRanges():[c.getSelectionRange()];for(var e,t=0;e=o[t];t++)e.start.column-=this.completions.filterText.length,c.session.remove(e)}h.snippet?L.insertSnippet(c,h.snippet,{range:h.range}):this.$insertString(c,h),h.command&&"startAutocomplete"===h.command&&c.execCommand(h.command)}return c.endOperation(),!0},r.prototype.$insertString=function(c,h){var p=h.value||h;if(h.range){if(c.inVirtualSelectionMode)return c.session.replace(h.range,p);c.forEachSelection(function(){var o=c.getSelectionRange();0===h.range.compareRange(o)?c.session.replace(h.range,p):c.insert(p)},null,{keepOrder:!0})}else c.execCommand("insertstring",p)},r.prototype.gatherCompletions=function(c,h){var p=c.getSession(),o=c.getCursorPosition(),t=b.getCompletionPrefix(c),e=[];this.completers=c.completers;var n=c.completers.length;return c.completers.forEach(function(i,a){i.getCompletions(c,p,o,t,function(l,s){!l&&s&&(e=e.concat(s)),h(null,{prefix:b.getCompletionPrefix(c),matches:e,finished:0==--n})})}),!0},r.prototype.provideCompletions=function(c,h,p){var o=function(i){var a=i.prefix;this.completions=new A(i.matches),h.exactMatch&&(this.completions.exactMatch=!0),h.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(a),(i.finished||this.completions.filtered.length)&&p(null,this.completions,i.finished)}.bind(this),t=!0,e=null;if(this.gatherCompletions(c,function(i,a){if(this.active&&(i&&(p(i,[],!0),this.detach()),0===a.prefix.indexOf(a.prefix))){if(t)return void(e=a);o(a)}}.bind(this)),t=!1,e){var n=e;e=null,o(n)}},r.prototype.detach=function(){this.active=!1,this.completers&&this.completers.forEach(function(c){"function"==typeof c.cancel&&c.cancel()})},r}(),A=function(){function r(c,h){this.all=c,this.filtered=c,this.filterText=h||"",this.exactMatch=!1,this.ignoreCaption=!1}return r.prototype.setFilter=function(c){if(c.length>this.filterText&&0===c.lastIndexOf(this.filterText,0))var h=this.filtered;else h=this.all;this.filterText=c,h=(h=this.filterCompletions(h,this.filterText)).sort(function(o,t){return t.exactMatch-o.exactMatch||t.$score-o.$score||(o.caption||o.value).localeCompare(t.caption||t.value)});var p=null;h=h.filter(function(o){var t=o.snippet||o.caption||o.value;return t!==p&&(p=t,!0)}),this.filtered=h},r.prototype.filterCompletions=function(c,h){var p=[],o=h.toUpperCase(),t=h.toLowerCase();e:for(var n,e=0;n=c[e];e++){var i=!this.ignoreCaption&&n.caption||n.value||n.snippet;if(i){var d,u,a=-1,l=0,s=0;if(this.exactMatch){if(h!==i.substr(0,h.length))continue e}else{var g=i.toLowerCase().indexOf(t);if(g>-1)s=g;else for(var f=0;f<h.length;f++){var y=i.indexOf(t[f],a+1),v=i.indexOf(o[f],a+1);if((d=y>=0&&(v<0||y<v)?y:v)<0)continue e;(u=d-a-1)>0&&(-1===a&&(s+=10),s+=u,l|=1<<f),a=d}}n.matchMask=l,n.exactMatch=s?0:1,n.$score=(n.score||0)-s,p.push(n)}}return p},r}();E.Autocomplete=x,E.CompletionProvider=$,E.FilteredList=A}),ace.define("ace/ext/command_bar",["require","exports","module","ace/tooltip","ace/lib/event_emitter","ace/lib/lang","ace/lib/dom","ace/lib/oop","ace/lib/useragent"],function(m,E,U){var R=this&&this.__values||function(t){var e="function"==typeof Symbol&&Symbol.iterator,n=e&&t[e],i=0;if(n)return n.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&i>=t.length&&(t=void 0),{value:t&&t[i++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")},_=m("../tooltip").Tooltip,M=m("../lib/event_emitter").EventEmitter,C=m("../lib/lang"),b=m("../lib/dom"),T=m("../lib/oop"),S=m("../lib/useragent"),L="command_bar_tooltip_button",O="command_bar_button_value",N="command_bar_button_caption",x="command_bar_keybinding",$="command_bar_tooltip",A="MoreOptionsButton",h=function(t,e){return e.row>t.row||e.row===t.row&&e.column>t.column?t:e},p={Ctrl:{mac:"^"},Option:{mac:"\u2325"},Command:{mac:"\u2318"},Cmd:{mac:"\u2318"},Shift:"\u21e7",Left:"\u2190",Right:"\u2192",Up:"\u2191",Down:"\u2193"},o=function(){function t(e,n){var i,a;n=n||{},this.parentNode=e,this.tooltip=new _(this.parentNode),this.moreOptions=new _(this.parentNode),this.maxElementsOnTooltip=n.maxElementsOnTooltip||4,this.$alwaysShow=n.alwaysShow||!1,this.eventListeners={},this.elements={},this.commands={},this.tooltipEl=b.buildDom(["div",{class:$}],this.tooltip.getElement()),this.moreOptionsEl=b.buildDom(["div",{class:$+" tooltip_more_options"}],this.moreOptions.getElement()),this.$showTooltipTimer=C.delayedCall(this.$showTooltip.bind(this),n.showDelay||100),this.$hideTooltipTimer=C.delayedCall(this.$hideTooltip.bind(this),n.hideDelay||100),this.$tooltipEnter=this.$tooltipEnter.bind(this),this.$onMouseMove=this.$onMouseMove.bind(this),this.$onChangeScroll=this.$onChangeScroll.bind(this),this.$onEditorChangeSession=this.$onEditorChangeSession.bind(this),this.$scheduleTooltipForHide=this.$scheduleTooltipForHide.bind(this),this.$preventMouseEvent=this.$preventMouseEvent.bind(this);try{for(var l=R(["mousedown","mouseup","click"]),s=l.next();!s.done;s=l.next()){var d=s.value;this.tooltip.getElement().addEventListener(d,this.$preventMouseEvent),this.moreOptions.getElement().addEventListener(d,this.$preventMouseEvent)}}catch(u){i={error:u}}finally{try{s&&!s.done&&(a=l.return)&&a.call(l)}finally{if(i)throw i.error}}}return t.prototype.registerCommand=function(e,n){var i=Object.keys(this.commands).length<this.maxElementsOnTooltip;!i&&!this.elements[A]&&this.$createCommand(A,{name:"\xb7\xb7\xb7",exec:function(){this.$shouldHideMoreOptions=!1,this.$setMoreOptionsVisibility(!this.isMoreOptionsShown())}.bind(this),type:"checkbox",getValue:function(){return this.isMoreOptionsShown()}.bind(this),enabled:!0},!0),this.$createCommand(e,n,i),this.isShown()&&this.updatePosition()},t.prototype.isShown=function(){return!!this.tooltip&&this.tooltip.isOpen},t.prototype.isMoreOptionsShown=function(){return!!this.moreOptions&&this.moreOptions.isOpen},t.prototype.getAlwaysShow=function(){return this.$alwaysShow},t.prototype.setAlwaysShow=function(e){this.$alwaysShow=e,this.$updateOnHoverHandlers(!this.$alwaysShow),this._signal("alwaysShow",this.$alwaysShow)},t.prototype.attach=function(e){!e||this.isShown()&&this.editor===e||(this.detach(),this.editor=e,this.editor.on("changeSession",this.$onEditorChangeSession),this.editor.session&&(this.editor.session.on("changeScrollLeft",this.$onChangeScroll),this.editor.session.on("changeScrollTop",this.$onChangeScroll)),this.getAlwaysShow()?this.$showTooltip():this.$updateOnHoverHandlers(!0))},t.prototype.updatePosition=function(){if(this.editor){var n,e=this.editor.renderer;if((n=this.editor.selection.getAllRanges?this.editor.selection.getAllRanges():[this.editor.getSelectionRange()]).length){for(var l,i=h(n[0].start,n[0].end),a=0;l=n[a];a++)i=h(i,h(l.start,l.end));var s=e.$cursorLayer.getPixelPosition(i,!0),d=this.tooltip.getElement(),u=window.innerWidth,g=window.innerHeight,f=this.editor.container.getBoundingClientRect();s.top+=f.top-e.layerConfig.offset,s.left+=f.left+e.gutterWidth-e.scrollLeft;var y=s.top>=f.top&&s.top<=f.bottom&&s.left>=f.left+e.gutterWidth&&s.left<=f.right;if(!y&&this.isShown())return void this.$hideTooltip();if(y&&!this.isShown()&&this.getAlwaysShow())return void this.$showTooltip();var v=s.top-d.offsetHeight,w=Math.min(u-d.offsetWidth,s.left);if(!(v>=0&&v+d.offsetHeight<=g&&w>=0&&w+d.offsetWidth<=u))return void this.$hideTooltip();if(this.tooltip.setPosition(w,v),this.isMoreOptionsShown()){v+=d.offsetHeight,w=this.elements[A].getBoundingClientRect().left;var I=this.moreOptions.getElement();g=window.innerHeight,v+I.offsetHeight>g&&(v-=d.offsetHeight+I.offsetHeight),w+I.offsetWidth>u&&(w=u-I.offsetWidth),this.moreOptions.setPosition(w,v)}}}},t.prototype.update=function(){Object.keys(this.elements).forEach(this.$updateElement.bind(this))},t.prototype.detach=function(){this.tooltip.hide(),this.moreOptions.hide(),this.$updateOnHoverHandlers(!1),this.editor&&(this.editor.off("changeSession",this.$onEditorChangeSession),this.editor.session&&(this.editor.session.off("changeScrollLeft",this.$onChangeScroll),this.editor.session.off("changeScrollTop",this.$onChangeScroll))),this.$mouseInTooltip=!1,this.editor=null},t.prototype.destroy=function(){this.tooltip&&this.moreOptions&&(this.detach(),this.tooltip.destroy(),this.moreOptions.destroy()),this.eventListeners={},this.commands={},this.elements={},this.tooltip=this.moreOptions=this.parentNode=null},t.prototype.$createCommand=function(e,n,i){var d,a=i?this.tooltipEl:this.moreOptionsEl,l=[],s=n.bindKey;s&&("object"==typeof s&&(s=S.isMac?s.mac:s.win),l=(l=(s=s.split("|")[0]).split("-")).map(function(g){if(p[g]){if("string"==typeof p[g])return p[g];if(S.isMac&&p[g].mac)return p[g].mac}return g})),i&&n.iconCssClass?d=["div",{class:["ace_icon_svg",n.iconCssClass].join(" "),"aria-label":n.name+" ("+n.bindKey+")"}]:(d=[["div",{class:O}],["div",{class:N},n.name]],l.length&&d.push(["div",{class:x},l.map(function(g){return["div",g]})])),b.buildDom(["div",{class:[L,n.cssClass||""].join(" "),ref:e},d],a,this.elements),this.commands[e]=n;var u=function(g){this.editor&&this.editor.focus(),this.$shouldHideMoreOptions=this.isMoreOptionsShown(),!this.elements[e].disabled&&n.exec&&n.exec(this.editor),this.$shouldHideMoreOptions&&this.$setMoreOptionsVisibility(!1),this.update(),g.preventDefault()}.bind(this);this.eventListeners[e]=u,this.elements[e].addEventListener("click",u.bind(this)),this.$updateElement(e)},t.prototype.$setMoreOptionsVisibility=function(e){e?(this.moreOptions.setTheme(this.editor.renderer.theme),this.moreOptions.setClassName($+"_wrapper"),this.moreOptions.show(),this.update(),this.updatePosition()):this.moreOptions.hide()},t.prototype.$onEditorChangeSession=function(e){e.oldSession&&(e.oldSession.off("changeScrollTop",this.$onChangeScroll),e.oldSession.off("changeScrollLeft",this.$onChangeScroll)),this.detach()},t.prototype.$onChangeScroll=function(){this.editor.renderer&&(this.isShown()||this.getAlwaysShow())&&this.editor.renderer.once("afterRender",this.updatePosition.bind(this))},t.prototype.$onMouseMove=function(e){if(!this.$mouseInTooltip){var n=this.editor.getCursorPosition(),i=this.editor.renderer.textToScreenCoordinates(n.row,n.column);e.clientY>=i.pageY&&e.clientY<i.pageY+this.editor.renderer.lineHeight?(!this.isShown()&&!this.$showTooltipTimer.isPending()&&this.$showTooltipTimer.delay(),this.$hideTooltipTimer.isPending()&&this.$hideTooltipTimer.cancel()):(this.isShown()&&!this.$hideTooltipTimer.isPending()&&this.$hideTooltipTimer.delay(),this.$showTooltipTimer.isPending()&&this.$showTooltipTimer.cancel())}},t.prototype.$preventMouseEvent=function(e){this.editor&&this.editor.focus(),e.preventDefault()},t.prototype.$scheduleTooltipForHide=function(){this.$mouseInTooltip=!1,this.$showTooltipTimer.cancel(),this.$hideTooltipTimer.delay()},t.prototype.$tooltipEnter=function(){this.$mouseInTooltip=!0,this.$showTooltipTimer.isPending()&&this.$showTooltipTimer.cancel(),this.$hideTooltipTimer.isPending()&&this.$hideTooltipTimer.cancel()},t.prototype.$updateOnHoverHandlers=function(e){var n=this.tooltip.getElement(),i=this.moreOptions.getElement();e?(this.editor&&(this.editor.on("mousemove",this.$onMouseMove),this.editor.renderer.getMouseEventTarget().addEventListener("mouseout",this.$scheduleTooltipForHide,!0)),n.addEventListener("mouseenter",this.$tooltipEnter),n.addEventListener("mouseleave",this.$scheduleTooltipForHide),i.addEventListener("mouseenter",this.$tooltipEnter),i.addEventListener("mouseleave",this.$scheduleTooltipForHide)):(this.editor&&(this.editor.off("mousemove",this.$onMouseMove),this.editor.renderer.getMouseEventTarget().removeEventListener("mouseout",this.$scheduleTooltipForHide,!0)),n.removeEventListener("mouseenter",this.$tooltipEnter),n.removeEventListener("mouseleave",this.$scheduleTooltipForHide),i.removeEventListener("mouseenter",this.$tooltipEnter),i.removeEventListener("mouseleave",this.$scheduleTooltipForHide))},t.prototype.$showTooltip=function(){this.isShown()||(this.tooltip.setTheme(this.editor.renderer.theme),this.tooltip.setClassName($+"_wrapper"),this.tooltip.show(),this.update(),this.updatePosition(),this._signal("show"))},t.prototype.$hideTooltip=function(){this.$mouseInTooltip=!1,this.isShown()&&(this.moreOptions.hide(),this.tooltip.hide(),this._signal("hide"))},t.prototype.$updateElement=function(e){var n=this.commands[e];if(n){var i=this.elements[e],a=n.enabled;if("function"==typeof a&&(a=a(this.editor)),"function"==typeof n.getValue){var l=n.getValue(this.editor);if("text"===n.type)i.textContent=l;else if("checkbox"===n.type){var s=l?b.addCssClass:b.removeCssClass,d=i.parentElement===this.tooltipEl;i.ariaChecked=l,d?s(i,"ace_selected"):s(i=i.querySelector("."+O),"ace_checkmark")}}a&&i.disabled?(b.removeCssClass(i,"ace_disabled"),i.ariaDisabled=i.disabled=!1,i.removeAttribute("disabled")):!a&&!i.disabled&&(b.addCssClass(i,"ace_disabled"),i.ariaDisabled=i.disabled=!0,i.setAttribute("disabled",""))}},t}();T.implement(o.prototype,M),b.importCssString("\n.ace_tooltip.".concat($,"_wrapper {\n    padding: 0;\n}\n\n.ace_tooltip .").concat($," {\n    padding: 1px 5px;\n    display: flex;\n    pointer-events: auto;\n}\n\n.ace_tooltip .").concat($,".tooltip_more_options {\n    padding: 1px;\n    flex-direction: column;\n}\n\ndiv.").concat(L," {\n    display: inline-flex;\n    cursor: pointer;\n    margin: 1px;\n    border-radius: 2px;\n    padding: 2px 5px;\n    align-items: center;\n}\n\ndiv.").concat(L,".ace_selected,\ndiv.").concat(L,":hover:not(.ace_disabled) {\n    background-color: rgba(0, 0, 0, 0.1);\n}\n\ndiv.").concat(L,".ace_disabled {\n    color: #777;\n    pointer-events: none;\n}\n\ndiv.").concat(L," .ace_icon_svg {\n    height: 12px;\n    background-color: #000;\n}\n\ndiv.").concat(L,".ace_disabled .ace_icon_svg {\n    background-color: #777;\n}\n\n.").concat($,".tooltip_more_options .").concat(L," {\n    display: flex;\n}\n\n.").concat($,".").concat(O," {\n    display: none;\n}\n\n.").concat($,".tooltip_more_options .").concat(O," {\n    display: inline-block;\n    width: 12px;\n}\n\n.").concat(N," {\n    display: inline-block;\n}\n\n.").concat(x," {\n    margin: 0 2px;\n    display: inline-block;\n    font-size: 8px;\n}\n\n.").concat($,".tooltip_more_options .").concat(x," {\n    margin-left: auto;\n}\n\n.").concat(x," div {\n    display: inline-block;\n    min-width: 8px;\n    padding: 2px;\n    margin: 0 1px;\n    border-radius: 2px;\n    background-color: #ccc;\n    text-align: center;\n}\n\n.ace_dark.ace_tooltip .").concat($," {\n    background-color: #373737;\n    color: #eee;\n}\n\n.ace_dark div.").concat(L,".ace_disabled {\n    color: #979797;\n}\n\n.ace_dark div.").concat(L,".ace_selected,\n.ace_dark div.").concat(L,":hover:not(.ace_disabled) {\n    background-color: rgba(255, 255, 255, 0.1);\n}\n\n.ace_dark div.").concat(L," .ace_icon_svg {\n    background-color: #eee;\n}\n\n.ace_dark div.").concat(L,".ace_disabled .ace_icon_svg {\n    background-color: #979797;\n}\n\n.ace_dark .").concat(L,".ace_disabled {\n    color: #979797;\n}\n\n.ace_dark .").concat(x," div {\n    background-color: #575757;\n}\n\n.ace_checkmark::before {\n    content: '\u2713';\n}\n"),"commandbar.css",!1),E.CommandBarTooltip=o,E.TOOLTIP_CLASS_NAME=$,E.BUTTON_CLASS_NAME=L}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(m,E,U){var R=m("../range").Range,_=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;E.getCompletions=function(b,T,S,L,O){var N=function C(b,T){var S=function M(b,T){return b.getTextRange(R.fromPoints({row:0,column:0},T)).split(_).length-1}(b,T),L=b.getValue().split(_),O=Object.create(null),N=L[S];return L.forEach(function(x,$){if(x&&x!==N){var A=Math.abs(S-$),r=L.length-A;O[x]=O[x]?Math.max(r,O[x]):r}}),O}(T,S);O(null,Object.keys(N).map(function($){return{caption:$,value:$,score:N[$],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(m,E,U){"use strict";var R=m("../snippets").snippetManager,_=m("../autocomplete").Autocomplete,M=m("../config"),C=m("../lib/lang"),b=m("../autocomplete/util"),T=m("../autocomplete/text_completer"),S={getCompletions:function(e,n,i,a,l){if(n.$mode.completer)return n.$mode.completer.getCompletions(e,n,i,a,l);var s=e.session.getState(i.row),d=n.$mode.getCompletions(s,n,i,a);l(null,d=d.map(function(u){return u.completerId=S.id,u}))},id:"keywordCompleter"},L=function(e){var n={};return e.replace(/\${(\d+)(:(.*?))?}/g,function(i,a,l,s){return n[a]=s||""}).replace(/\$(\d+?)/g,function(i,a){return n[a]})},O={getCompletions:function(e,n,i,a,l){var s=[],d=n.getTokenAt(i.row,i.column);d&&d.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?s.push("html-tag"):s=R.getActiveScopes(e);var u=R.snippetMap,g=[];s.forEach(function(f){for(var y=u[f]||[],v=y.length;v--;){var w=y[v],H=w.name||w.tabTrigger;!H||g.push({caption:H,snippet:w.content,meta:w.tabTrigger&&!w.name?w.tabTrigger+"\u21e5 ":"snippet",completerId:O.id})}},this),l(null,g)},getDocTooltip:function(e){e.snippet&&!e.docHTML&&(e.docHTML=["<b>",C.escapeHTML(e.caption),"</b>","<hr></hr>",C.escapeHTML(L(e.snippet))].join(""))},id:"snippetCompleter"},N=[O,T,S];E.setCompleters=function(e){N.length=0,e&&N.push.apply(N,e)},E.addCompleter=function(e){N.push(e)},E.textCompleter=T,E.keyWordCompleter=S,E.snippetCompleter=O;var h,x={name:"expandSnippet",exec:function(e){return R.expandWithTab(e)},bindKey:"Tab"},$=function(e,n){A(n.session.$mode)},A=function(e){"string"==typeof e&&(e=M.$modes[e]),e&&(R.files||(R.files={}),r(e.$id,e.snippetFileId),e.modes&&e.modes.forEach(A))},r=function(e,n){!n||!e||R.files[e]||(R.files[e]={},M.loadModule(n,function(i){!i||(R.files[e]=i,!i.snippets&&i.snippetText&&(i.snippets=R.parseSnippetFile(i.snippetText)),R.register(i.snippets||[],i.scope),i.includeScopes&&(R.snippetMap[i.scope].includeScopes=i.includeScopes,i.includeScopes.forEach(function(a){A("ace/mode/"+a)})))}))},c=function(e){var n=e.editor,i=n.completer&&n.completer.activated;if("backspace"===e.command.name)i&&!b.getCompletionPrefix(n)&&n.completer.detach();else if("insertstring"===e.command.name&&!i){h=e;var a=e.editor.$liveAutocompletionDelay;a?p.delay(a):o(e)}},p=C.delayedCall(function(){o(h)},0),o=function(e){var n=e.editor,i=b.getCompletionPrefix(n),a=b.triggerAutocomplete(n);if((i||a)&&i.length>=n.$liveAutocompletionThreshold){var l=_.for(n);l.autoShown=!0,l.showPopup(n)}},t=m("../editor").Editor;m("../config").defineOptions(t.prototype,"editor",{enableBasicAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:N),this.commands.addCommand(_.startCommand)):this.commands.removeCommand(_.startCommand)},value:!1},enableLiveAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:N),this.commands.on("afterExec",c)):this.commands.off("afterExec",c)},value:!1},liveAutocompletionDelay:{initialValue:0},liveAutocompletionThreshold:{initialValue:0},enableSnippets:{set:function(e){e?(this.commands.addCommand(x),this.on("changeMode",$),$(0,this)):(this.commands.removeCommand(x),this.off("changeMode",$))},value:!1}})}),ace.define("ace/ext/inline_autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/inline","ace/autocomplete","ace/autocomplete","ace/editor","ace/autocomplete/util","ace/lib/dom","ace/lib/lang","ace/ext/command_bar","ace/ext/command_bar","ace/ext/language_tools","ace/ext/language_tools","ace/ext/language_tools","ace/config"],function(m,E,U){"use strict";var R=m("../keyboard/hash_handler").HashHandler,_=m("../autocomplete/inline").AceInline,M=m("../autocomplete").FilteredList,C=m("../autocomplete").CompletionProvider,b=m("../editor").Editor,T=m("../autocomplete/util"),S=m("../lib/dom"),L=m("../lib/lang"),O=m("./command_bar").CommandBarTooltip,N=m("./command_bar").BUTTON_CLASS_NAME,x=m("./language_tools").snippetCompleter,$=m("./language_tools").textCompleter,A=m("./language_tools").keyWordCompleter,r=function(p,o){o.completer&&o.completer.destroy()},c=function(){function p(o){this.editor=o,this.keyboardHandler=new R(this.commands),this.$index=-1,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.changeTimer=L.delayedCall(function(){this.updateCompletions()}.bind(this))}return p.prototype.getInlineRenderer=function(){return this.inlineRenderer||(this.inlineRenderer=new _),this.inlineRenderer},p.prototype.getInlineTooltip=function(){return this.inlineTooltip||(this.inlineTooltip=p.createInlineTooltip(document.body||document.documentElement)),this.inlineTooltip},p.prototype.show=function(o){this.activated=!0,this.editor.completer!==this&&(this.editor.completer&&this.editor.completer.detach(),this.editor.completer=this),this.editor.on("changeSelection",this.changeListener),this.editor.on("blur",this.blurListener),this.updateCompletions(o)},p.prototype.$open=function(){this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({}),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.getInlineTooltip().attach(this.editor),-1===this.$index?this.setIndex(0):this.$showCompletion(),this.changeTimer.cancel()},p.prototype.insertMatch=function(){var o=this.getCompletionProvider().insertByIndex(this.editor,this.$index);return this.detach(),o},p.prototype.changeListener=function(o){var t=this.editor.selection.lead;(t.row!=this.base.row||t.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},p.prototype.blurListener=function(o){this.detach()},p.prototype.goTo=function(o){if(this.completions&&this.completions.filtered){var t=this.completions.filtered.length;switch(o.toLowerCase()){case"prev":this.setIndex((this.$index-1+t)%t);break;case"next":this.setIndex((this.$index+1+t)%t);break;case"first":this.setIndex(0);break;case"last":this.setIndex(this.completions.filtered.length-1)}}},p.prototype.getLength=function(){return this.completions&&this.completions.filtered?this.completions.filtered.length:0},p.prototype.getData=function(o){return null==o||null===o?this.completions.filtered[this.$index]:this.completions.filtered[o]},p.prototype.getIndex=function(){return this.$index},p.prototype.isOpen=function(){return this.$index>=0},p.prototype.setIndex=function(o){if(this.completions&&this.completions.filtered){var t=Math.max(-1,Math.min(this.completions.filtered.length-1,o));t!==this.$index&&(this.$index=t,this.$showCompletion())}},p.prototype.getCompletionProvider=function(){return this.completionProvider||(this.completionProvider=new C),this.completionProvider},p.prototype.$showCompletion=function(){this.getInlineRenderer().show(this.editor,this.completions.filtered[this.$index],this.completions.filterText)||this.getInlineRenderer().hide(),this.inlineTooltip&&this.inlineTooltip.isShown()&&this.inlineTooltip.update()},p.prototype.$updatePrefix=function(){var o=this.editor.getCursorPosition(),t=this.editor.session.getTextRange({start:this.base,end:o});return this.completions.setFilter(t),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=t||this.completions.filtered[0].snippet)?(this.$open(this.editor,t),t):this.detach()},p.prototype.updateCompletions=function(i){var n="";if(i&&i.matches){var e=this.editor.getSelectionRange().start;return this.base=this.editor.session.doc.createAnchor(e.row,e.column),this.base.$insertRight=!0,this.completions=new M(i.matches),this.$open(this.editor,"")}this.base&&this.completions&&(n=this.$updatePrefix());var t=this.editor.getSession();e=this.editor.getCursorPosition(),n=T.getCompletionPrefix(this.editor),this.base=t.doc.createAnchor(e.row,e.column-n.length),this.base.$insertRight=!0,i={exactMatch:!0,ignoreCaption:!0},this.getCompletionProvider().provideCompletions(this.editor,i,function(a,l,s){var d=l.filtered,u=T.getCompletionPrefix(this.editor);if(s){if(!d.length)return this.detach();if(1==d.length&&d[0].value==u&&!d[0].snippet)return this.detach()}this.completions=l,this.$open(this.editor,u)}.bind(this))},p.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener)),this.changeTimer.cancel(),this.inlineTooltip&&this.inlineTooltip.detach(),this.setIndex(-1),this.completionProvider&&this.completionProvider.detach(),this.inlineRenderer&&this.inlineRenderer.isOpen()&&this.inlineRenderer.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null},p.prototype.destroy=function(){this.detach(),this.inlineRenderer&&this.inlineRenderer.destroy(),this.inlineTooltip&&this.inlineTooltip.destroy(),this.editor&&this.editor.completer==this&&(this.editor.off("destroy",r),this.editor.completer=null),this.inlineTooltip=this.editor=this.inlineRenderer=null},p}();c.prototype.commands={Previous:{bindKey:"Alt-[",name:"Previous",exec:function(p){p.completer.goTo("prev")}},Next:{bindKey:"Alt-]",name:"Next",exec:function(p){p.completer.goTo("next")}},Accept:{bindKey:{win:"Tab|Ctrl-Right",mac:"Tab|Cmd-Right"},name:"Accept",exec:function(p){return p.completer.insertMatch()}},Close:{bindKey:"Esc",name:"Close",exec:function(p){p.completer.detach()}}},c.for=function(p){return p.completer instanceof c||(p.completer&&(p.completer.destroy(),p.completer=null),p.completer=new c(p),p.once("destroy",r)),p.completer},c.startCommand={name:"startInlineAutocomplete",exec:function(p,o){c.for(p).show(o)},bindKey:{win:"Alt-C",mac:"Option-C"}};var h=[x,$,A];m("../config").defineOptions(b.prototype,"editor",{enableInlineAutocompletion:{set:function(p){p?(this.completers||(this.completers=Array.isArray(p)?p:h),this.commands.addCommand(c.startCommand)):this.commands.removeCommand(c.startCommand)},value:!1}}),c.createInlineTooltip=function(p){var o=new O(p);return o.registerCommand("Previous",Object.assign({},c.prototype.commands.Previous,{enabled:!0,type:"button",iconCssClass:"ace_arrow_rotated"})),o.registerCommand("Position",{enabled:!1,getValue:function(t){return t?[t.completer.getIndex()+1,t.completer.getLength()].join("/"):""},type:"text",cssClass:"completion_position"}),o.registerCommand("Next",Object.assign({},c.prototype.commands.Next,{enabled:!0,type:"button",iconCssClass:"ace_arrow"})),o.registerCommand("Accept",Object.assign({},c.prototype.commands.Accept,{enabled:function(t){return!!t&&t.completer.getIndex()>=0},type:"button"})),o.registerCommand("ShowTooltip",{name:"Always Show Tooltip",exec:function(){o.setAlwaysShow(!o.getAlwaysShow())},enabled:!0,getValue:function(){return o.getAlwaysShow()},type:"checkbox"}),o},S.importCssString('\n\n.ace_icon_svg.ace_arrow,\n.ace_icon_svg.ace_arrow_rotated {\n    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTUuODM3MDEgMTVMNC41ODc1MSAxMy43MTU1TDEwLjE0NjggOEw0LjU4NzUxIDIuMjg0NDZMNS44MzcwMSAxTDEyLjY0NjUgOEw1LjgzNzAxIDE1WiIgZmlsbD0iYmxhY2siLz48L3N2Zz4=");\n}\n\n.ace_icon_svg.ace_arrow_rotated {\n    transform: rotate(180deg);\n}\n\ndiv.'.concat(N,".completion_position {\n    padding: 0;\n}\n"),"inlineautocomplete.css",!1),E.InlineAutocomplete=c}),ace.require(["ace/ext/inline_autocomplete"],function(m){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=m)});