/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.helix.Criteria;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.ZNRecordRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriteriaEvaluator {
    private static Logger logger = LoggerFactory.getLogger(CriteriaEvaluator.class);
    public static final String MATCH_ALL_SYM = "%";

    public List<Map<String, String>> evaluateCriteria(Criteria recipientCriteria, HelixManager manager) {
        return this.evaluateCriteria(recipientCriteria, manager.getHelixDataAccessor());
    }

    public List<Map<String, String>> evaluateCriteria(Criteria recipientCriteria, HelixDataAccessor accessor) {
        List<HelixProperty> properties;
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        Criteria.DataSource dataSource = recipientCriteria.getDataSource();
        String resourceName = recipientCriteria.getResource();
        String instanceName = recipientCriteria.getInstanceName();
        switch (dataSource) {
            case EXTERNALVIEW: {
                properties = this.getProperty(accessor, resourceName, keyBuilder.externalViews(), keyBuilder.externalView(resourceName), Criteria.DataSource.EXTERNALVIEW.name());
                break;
            }
            case IDEALSTATES: {
                properties = this.getProperty(accessor, resourceName, keyBuilder.idealStates(), keyBuilder.idealStates(resourceName), Criteria.DataSource.IDEALSTATES.name());
                break;
            }
            case LIVEINSTANCES: {
                properties = this.getProperty(accessor, instanceName, keyBuilder.liveInstances(), keyBuilder.liveInstance(instanceName), Criteria.DataSource.LIVEINSTANCES.name());
                break;
            }
            case INSTANCES: {
                properties = this.getProperty(accessor, instanceName, keyBuilder.instances(), keyBuilder.instance(instanceName), Criteria.DataSource.INSTANCES.name());
                break;
            }
            default: {
                return Lists.newArrayList();
            }
        }
        List<ZNRecordRow> allRows = ZNRecordRow.flatten(HelixProperty.convertToList(properties));
        Set<String> liveParticipants = accessor.getChildValuesMap(keyBuilder.liveInstances(), false).keySet();
        ArrayList result = Lists.newArrayList();
        for (ZNRecordRow row : allRows) {
            if (!this.rowMatches(recipientCriteria, row) || !liveParticipants.contains(row.getRecordId()) && !liveParticipants.contains(row.getMapSubKey())) continue;
            result.add(row);
        }
        HashSet selected = Sets.newHashSet();
        for (ZNRecordRow row : result) {
            HashMap<String, String> resultRow = new HashMap<String, String>();
            resultRow.put("instanceName", !recipientCriteria.getInstanceName().equals("") ? (!Strings.isNullOrEmpty((String)row.getMapSubKey()) ? row.getMapSubKey() : row.getRecordId()) : "");
            resultRow.put("resourceName", !recipientCriteria.getResource().equals("") ? row.getRecordId() : "");
            resultRow.put("partitionName", !recipientCriteria.getPartition().equals("") ? row.getMapKey() : "");
            resultRow.put("partitionState", !recipientCriteria.getPartitionState().equals("") ? row.getMapValue() : "");
            selected.add(resultRow);
        }
        logger.info("Query returned " + selected.size() + " rows");
        return Lists.newArrayList((Iterable)selected);
    }

    private boolean rowMatches(Criteria criteria, ZNRecordRow row) {
        String instanceName = this.normalizePattern(criteria.getInstanceName());
        String resourceName = this.normalizePattern(criteria.getResource());
        String partitionName = this.normalizePattern(criteria.getPartition());
        String partitionState = this.normalizePattern(criteria.getPartitionState());
        return (this.stringMatches(instanceName, Strings.nullToEmpty((String)row.getMapSubKey())) || this.stringMatches(instanceName, Strings.nullToEmpty((String)row.getRecordId()))) && this.stringMatches(resourceName, Strings.nullToEmpty((String)row.getRecordId())) && this.stringMatches(partitionName, Strings.nullToEmpty((String)row.getMapKey())) && this.stringMatches(partitionState, Strings.nullToEmpty((String)row.getMapValue()));
    }

    private String normalizePattern(String pattern) {
        if (pattern == null || pattern.equals("") || pattern.equals("*")) {
            pattern = MATCH_ALL_SYM;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if ("[](){}.*+?$^|#\\".indexOf(ch) != -1) {
                builder.append("\\");
            }
            builder.append(ch);
        }
        pattern = builder.toString().toLowerCase().replace("_", ".").replace(MATCH_ALL_SYM, ".*?");
        return pattern;
    }

    private boolean stringMatches(String pattern, String value) {
        Pattern p = Pattern.compile(pattern, 34);
        return p.matcher(value).matches();
    }

    private List<HelixProperty> getProperty(HelixDataAccessor accessor, String dataSpec, PropertyKey propertyKeys, PropertyKey propertyKey, String dataType) {
        List<HelixProperty> properties;
        if (Strings.isNullOrEmpty((String)dataSpec) || dataSpec.equals(MATCH_ALL_SYM)) {
            properties = accessor.getChildValues(propertyKeys, false);
        } else {
            Object data = accessor.getProperty(propertyKey);
            if (data == null) {
                throw new HelixException(String.format("Specified %s %s is not found!", dataType, dataSpec));
            }
            properties = Collections.singletonList(data);
        }
        return properties;
    }
}

