/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler;

import java.util.List;
import org.apache.ignite3.internal.metrics.AbstractMetricSource;
import org.apache.ignite3.internal.metrics.AtomicLongMetric;
import org.apache.ignite3.internal.metrics.Metric;

public class ClientHandlerMetricSource
extends AbstractMetricSource<Holder> {
    public ClientHandlerMetricSource() {
        super("client.handler");
    }

    public long connectionsInitiated() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.connectionsInitiated.value();
    }

    void connectionsInitiatedIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.connectionsInitiated.increment();
        }
    }

    public long sessionsAccepted() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.sessionsAccepted.value();
    }

    void sessionsAcceptedIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.sessionsAccepted.increment();
        }
    }

    public long sessionsActive() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.sessionsActive.value();
    }

    void sessionsActiveIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.sessionsActive.increment();
        }
    }

    void sessionsActiveDecrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.sessionsActive.decrement();
        }
    }

    public long sessionsRejected() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.sessionsRejected.value();
    }

    void sessionsRejectedIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.sessionsRejected.increment();
        }
    }

    public long sessionsRejectedTls() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.sessionsRejectedTls.value();
    }

    void sessionsRejectedTlsIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.sessionsRejectedTls.increment();
        }
    }

    public long bytesSent() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.bytesSent.value();
    }

    void bytesSentAdd(long bytes) {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.bytesSent.add(bytes);
        }
    }

    public long bytesReceived() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.bytesReceived.value();
    }

    void bytesReceivedAdd(long bytes) {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.bytesReceived.add(bytes);
        }
    }

    public long sessionsRejectedTimeout() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.sessionsRejectedTimeout.value();
    }

    void sessionsRejectedTimeoutIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.sessionsRejectedTimeout.increment();
        }
    }

    public long requestsActive() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.requestsActive.value();
    }

    void requestsActiveIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.requestsActive.increment();
        }
    }

    void requestsActiveDecrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.requestsActive.decrement();
        }
    }

    public long requestsProcessed() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.requestsProcessed.value();
    }

    void requestsProcessedIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.requestsProcessed.increment();
        }
    }

    public long requestsFailed() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.requestsFailed.value();
    }

    void requestsFailedIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.requestsFailed.increment();
        }
    }

    public long transactionsActive() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.transactionsActive.value();
    }

    public void transactionsActiveIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.transactionsActive.increment();
        }
    }

    public void transactionsActiveDecrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.transactionsActive.decrement();
        }
    }

    public long cursorsActive() {
        Holder h = (Holder)this.holder();
        return h == null ? 0L : h.cursorsActive.value();
    }

    public void cursorsActiveIncrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.cursorsActive.increment();
        }
    }

    public void cursorsActiveDecrement() {
        Holder h = (Holder)this.holder();
        if (h != null) {
            h.cursorsActive.decrement();
        }
    }

    @Override
    protected Holder createHolder() {
        return new Holder();
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final AtomicLongMetric connectionsInitiated = new AtomicLongMetric("ConnectionsInitiated", "Total initiated connections");
        private final AtomicLongMetric sessionsAccepted = new AtomicLongMetric("SessionsAccepted", "Total accepted sessions");
        private final AtomicLongMetric sessionsActive = new AtomicLongMetric("SessionsActive", "Active sessions");
        private final AtomicLongMetric sessionsRejected = new AtomicLongMetric("SessionsRejected", "Total sessions rejected due to handshake errors");
        private final AtomicLongMetric sessionsRejectedTls = new AtomicLongMetric("SessionsRejectedTls", "Total sessions rejected due to TLS handshake errors");
        private final AtomicLongMetric sessionsRejectedTimeout = new AtomicLongMetric("SessionsRejectedTimeout", "Total sessions rejected by timeout");
        private final AtomicLongMetric bytesSent = new AtomicLongMetric("BytesSent", "Total bytes sent");
        private final AtomicLongMetric bytesReceived = new AtomicLongMetric("BytesReceived", "Total bytes received");
        private final AtomicLongMetric requestsActive = new AtomicLongMetric("RequestsActive", "Requests in progress");
        private final AtomicLongMetric requestsProcessed = new AtomicLongMetric("RequestsProcessed", "Total processed requests");
        private final AtomicLongMetric requestsFailed = new AtomicLongMetric("RequestsFailed", "Total failed requests");
        private final AtomicLongMetric transactionsActive = new AtomicLongMetric("TransactionsActive", "Active transactions");
        private final AtomicLongMetric cursorsActive = new AtomicLongMetric("CursorsActive", "Active cursors");
        final List<Metric> metrics = List.of(this.connectionsInitiated, this.sessionsAccepted, this.sessionsActive, this.sessionsRejected, this.sessionsRejectedTls, this.sessionsRejectedTimeout, this.bytesSent, this.bytesReceived, this.requestsActive, this.requestsProcessed, this.requestsFailed, this.transactionsActive, this.cursorsActive);

        protected Holder() {
        }

        @Override
        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

