/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.BitSet;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ColocationMappingException;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ExecutionTarget;
import org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster.AbstractTarget;
import org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster.AllOfTarget;
import org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster.OneOfTarget;
import org.apache.ignite3.internal.sql.engine.exec.mapping.largecluster.SomeOfTarget;

class PartitionedTarget
extends AbstractTarget {
    private final boolean finalised;
    final BitSet[] partitionsNodes;
    final long[] enlistmentConsistencyTokens;

    PartitionedTarget(boolean finalised, BitSet[] partitionsNodes, long[] enlistmentConsistencyTokens) {
        super(PartitionedTarget.computeNodes(partitionsNodes));
        this.finalised = finalised;
        this.partitionsNodes = partitionsNodes;
        this.enlistmentConsistencyTokens = enlistmentConsistencyTokens;
    }

    @Override
    public ExecutionTarget finalise() {
        if (this.finalised) {
            return this;
        }
        BitSet[] newPartitionsNodes = new BitSet[this.partitionsNodes.length];
        for (int partNo = 0; partNo < this.partitionsNodes.length; ++partNo) {
            newPartitionsNodes[partNo] = PartitionedTarget.pickOne(this.partitionsNodes[partNo]);
        }
        return new PartitionedTarget(true, newPartitionsNodes, this.enlistmentConsistencyTokens);
    }

    @Override
    public ExecutionTarget colocateWith(ExecutionTarget other) throws ColocationMappingException {
        assert (other instanceof AbstractTarget) : other == null ? "<null>" : other.getClass().getCanonicalName();
        return ((AbstractTarget)other).colocate(this);
    }

    @Override
    public ExecutionTarget trimTo(ExecutionTarget other) {
        assert (other instanceof AbstractTarget) : other == null ? "<null>" : other.getClass().getCanonicalName();
        if (this.finalised) {
            return this;
        }
        BitSet[] newPartitionsNodes = new BitSet[this.partitionsNodes.length];
        boolean changed = false;
        Int2ObjectFunction<BitSet> partitionNodesResolver = this.partitionNodeResolver(other);
        for (int i = 0; i < this.partitionsNodes.length; ++i) {
            BitSet newNodes = this.partitionsNodes[i];
            BitSet otherNodes = (BitSet)partitionNodesResolver.get(i);
            if (!newNodes.equals(otherNodes) && newNodes.intersects(otherNodes)) {
                newNodes = (BitSet)newNodes.clone();
                newNodes.and(otherNodes);
                changed = true;
            }
            newPartitionsNodes[i] = newNodes;
        }
        if (changed) {
            return new PartitionedTarget(false, newPartitionsNodes, this.enlistmentConsistencyTokens);
        }
        return this;
    }

    private Int2ObjectFunction<BitSet> partitionNodeResolver(ExecutionTarget other) {
        Int2ObjectFunction partitionNodesResolver;
        if (other instanceof PartitionedTarget && ((PartitionedTarget)other).partitionsNodes.length == this.partitionsNodes.length) {
            PartitionedTarget otherPartitioned = (PartitionedTarget)other;
            partitionNodesResolver = partId -> otherPartitioned.partitionsNodes[partId];
        } else {
            BitSet otherNodes = ((AbstractTarget)other).nodes;
            partitionNodesResolver = partId -> otherNodes;
        }
        return partitionNodesResolver;
    }

    @Override
    ExecutionTarget colocate(AllOfTarget other) throws ColocationMappingException {
        return PartitionedTarget.colocate(other, this);
    }

    @Override
    ExecutionTarget colocate(OneOfTarget other) throws ColocationMappingException {
        return PartitionedTarget.colocate(other, this);
    }

    @Override
    ExecutionTarget colocate(PartitionedTarget other) throws ColocationMappingException {
        return PartitionedTarget.colocate(this, other);
    }

    @Override
    ExecutionTarget colocate(SomeOfTarget other) throws ColocationMappingException {
        return PartitionedTarget.colocate(this, other);
    }

    private static BitSet computeNodes(BitSet[] partitionsNodes) {
        BitSet nodes = new BitSet();
        for (BitSet nodesOfPartition : partitionsNodes) {
            nodes.or(nodesOfPartition);
        }
        return nodes;
    }
}

